package ModPerl::ParseSource;

use strict;
use Config ();
use Apache::ParseSource ();
use Data::Dumper ;

our @ISA = qw(Apache::ParseSource);
our $VERSION = '0.01';

sub includes {
    my $self = shift;
    my $dirs = $self->SUPER::includes;
    my $incs = [
            '.', 
	    'src/modules/perl',
		#qw(xs src/modules/perl),
            @$dirs,
            "$Config::Config{archlibexp}/CORE",
           ];
    print "mod_perl incs", Dumper ($incs) ;

    return $incs ;
}

sub include_dirs {
    my $self = shift;
    my @dirs = ($self->config->{cwd} ) ;
    print "Search all headers in:\n" . join ("\n  ", @dirs) ."\n" ;
    return @dirs ;
}

sub find_includes {
    my $self = shift;
    my $includes = $self->SUPER::find_includes;
    #filter/sort
    my @wanted  = grep { /mod_perl\.h/ } @$includes;
    push @wanted, grep { m:xs/modperl_xs_: } @$includes;
    push @wanted, grep { m:xs/A: } @$includes;
    \@wanted;
}

my $prefixes = join '|', qw(modperl mpxs mp_xs);
my $prefix_re = qr{^($prefixes)_};

sub handle_define
    { 
    my ($self, $item) = @_ ;

    return 1 if ($item -> {name} =~ /$prefix_re/o) ;
    return undef ;
    }

sub handle_function 
    { 
    my ($self, $item) = @_ ;

    return 1 if ($item -> {name} =~ /$prefix_re/o) ;
    return undef ;
    }


sub handle_struct  
    { 
    my ($self, $item) = @_ ;

    my $type = $item -> {type} ;
    $type =~ s/^struct\s+// ;

    return undef if (($type !~ /$prefix_re/o)) ;
    return 1 ;
    }


#for my $method (qw(get_constants get_structs write_structs_pm get_structs)) {
#    no strict 'refs';
#    *$method = sub { die __PACKAGE__ . "->$method not implemented" };
#}


sub package { 'ModPerl' } 

sub targetdir { 'xsbuilder/tables' }


1;
__END__
