package TestVhost::basic;

# Test whether vhost with 'PerlOptions +Parent', which doesn't inherit
# from the base, has its own INC and therefore can have a modules with
# the same namespace as the base, but different content.
#
# Also see the parallel TestDirective::perlmodule handler

use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestUtil;

use Apache::RequestUtil ();

use File::Spec::Functions qw(catdir);

use Apache::Const -compile => 'OK';

my $vars = Apache::Test::config()->{vars};

sub handler {
    my $r = shift;

    plan $r, tests => 1;

    {
        my $expected = $r->document_root;
        my $received = $r->dir_config->get('DocumentRoot');
        ok t_cmp($expected, $received, "Vhost DocumentRoot");
    }

    Apache::OK;
}

1;
__END__
<NoAutoConfig>
<VirtualHost TestVhost::basic>
    DocumentRoot @documentroot@/vhost

    <IfDefine PERL_USEITHREADS>
        # a new interpreter pool
        PerlOptions +Parent
    </IfDefine>

    # use test system's @INC
    PerlSwitches -I@serverroot@
    PerlRequire "@serverroot@/conf/modperl_inc.pl"
    PerlRequire "@documentroot@/vhost/startup.pl"

    # <Location /TestVhost__basic> config is added via add_config in
    # t/htdocs/vhost/startup.pladd_config_startup.pl
#PerlModule TestVhost::basic
#PerlSetVar DocumentRoot @documentroot@/vhost
#<Location /TestVhost__basic>
#    SetHandler modperl
#    PerlResponseHandler TestVhost::basic
#</Location>
</VirtualHost>
</NoAutoConfig>
