; INSTANCE virus shield - by Eric Auer 2004 eric _at_ coli.uni-sb.de
; To compile: http://nasm.sf.net/ "nasm -o instance.com instance.asm"


 ; INSTANCE is free software; you can redistribute it and/or modify
 ; it under the terms of the GNU General Public License as published
 ; by the Free Software Foundation; either version 2 of the License,
 ; or (at your option) any later version.

 ; INSTANCE is distributed in the hope that it will be useful,
 ; but WITHOUT ANY WARRANTY; without even the implied warranty of
 ; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ; GNU General Public License for more details.

 ; You should have received a copy of the GNU General Public License
 ; along with INSTANCE; if not, write to the Free Software Foundation,
 ; Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 ; (or try http://www.gnu.org/licenses/licenses.html at www.gnu.org).


; This TSR takes a snapshot of memory structure and marks all used
; space (and too-small free space areas) as "instance data" for
; Wind*ws 3.x - in other words, kernel and all TSRs will be marked
; as "every DOS box in Wind*ws needs a separate copy of this data"
; areas. For simplicity, I use 386+ code here: You need a 386+ CPU.

	org 0x100
start:	jmp setup

; -------------------------------------

int2f:

%if 0
	cmp ax,0x4a00	; DJ mechanism message permission (DOS 5+)
	jnz other1
	cmp cx,0
	jnz other1
	mov cx,0xffff	; suppress DJ mechanism message
	iret
other1:
%endif

	cmp ax,0x1603	; get instance data (Win/386 asks us for i.d.)
	jnz chain2f
	mov ax,cs
	mov ds,ax
	mov si,instancedata	; DS:SI pointer, to our own
				; instance data structure
	mov ax,0x5248	; magic value, as with RM Nimbus DOS 3.3
	iret

chain2f:
	jmp far [cs:old2f]

; -------------------------------------

	db "OLD2F("
old2f		dd 0		; old interrupt vector
	db ") MCB0("
mcbstart	dw 0		; start segment of mcb chain
	db ") DDPT("
ddptptr		dd 0		; just nice for debug
	db ") SFT("
sftptr		dd 0		; just nice for debug
	db ") BUFFER0("
bufferptr	dd 0		; just nice for debug
	db ") CDS("
cdsptr	dd 0			; just nice for debug
	db ") NUL("
nulptr	dd 0			; just nice for debug
	db ") HMA("
hmafree	dw 0			; nonzero if HMA in use
	db ") VER("
dosver	dw 0			; just nice for debug
	db ") EBDAseg("
ebdaseg	dw 0			; segment of EBDA or 0
	db ") EBDAsz("
ebdasz	dw 0			; converted from byte (kbytes unit)

	db ")"
	align 2
	db " INSTANCE("
instancedata:
	dw 0x70			; kernel segment
	dw 0			; no (MS compatible) STACKS structure
narea	dw 0			; number of instance data areas (max 32)
areas	dw 0, 0, 0		; for each area: segment, offset, size
				; further areas overwrite setup code!

; -------------------------------------

setup:	mov ah,0x30	; get DOS version
	int 0x21
	mov [dosver],ax
	cmp al,7	; max 7.x
	ja wrongver
	cmp al,3	; min 3.1
	jb wrongver
	ja goodver
	cmp ah,1	; min 3.1
	jae goodver
wrongver:
	mov ah,9	; show string
	mov dx,wrongvermsg
	int 0x21
	mov ax,0x4c01
	int 0x21
goodver:

	; ---------

	push es
	push di
	mov ax,0x4a01	; query free HMA space (DOS 5+)
	xor bx,bx	; (for older DOS versions which ignore this call)
	int 0x2f	; returns: BX bytes, starting at ES:DI
	mov ax,es	
	and ax,di	; ... ES:DI is -1:-1 if no HMA used
	not ax		; 0 if no HMA used
	pop di
	pop es
	or bx,bx	; 0 if no HMA used
	jz nohma
	or ax,ax
	jz nohma
havehma:
	mov [hmafree],bx
	mov ah,9	; show string
	mov dx,havehmamsg
	int 0x21
nohma:

	; ---------

	push ds
	mov ax,0x40	; BIOS data segment
	mov ds,ax
	mov ax,[ds:0x0e]	; EBDA segment or 0
	or ax,ax
	jz skipebda
	mov [ebdaseg],ax
	mov ds,ax
	mov al,[ds:0]		; EBDA size in kbytes
	test al,63		; too big?
	jnz skipebda
	shl ax,10		; convert to kbytes (AH shifted away)
	mov [cs:ebdasz],ax
skipebda:
	pop ds

	mov ax,[ebdaseg]
	or ax,ax
	jz noebda
	mov ah,9		; show string
	mov dx,haveebdamsg
	int 0x21
noebda:

	; ---------

	cld
	mov di,areas		; store info here (DI must stay intact!)

	; ---------

	mov ax,[hmafree]
	jz nallochma
	inc word [narea]
	mov ax,0xffff		; segment HMA
	stosw
	mov ax,0x10		; offset HMA
	stosw
	mov ax,0xffef		; size HMA (just all)
	stosw
nallochma:

	; ---------

	mov ax,[ebdaseg]
	jz nallocebda
	inc word [narea]
	stosw			; segment EBDA
	xor ax,ax
	stosw			; offset EBDA
	mov ax,[ebdasz]
	stosw			; size EBDA
nallocebda:

	; ---------

	mov bx,realend+512	; end plus some stack
	and bx,0xfff0		; round down
	mov sp,bx		; MOVE STACK POINTER
	add bx,15		; round up
	shr bx,4		; to paragraphs
	mov ah,0x4a		; resize memory block ES
	int 0x21		; shrink ourselves

	push es
	mov es,[cs:0x2c]	; environment segment
	mov ah,0x49		; free memory block ES
	int 0x21		; drop environment
	pop es

	cmp byte [cs:dosver],5	; DOS version with UMB support?
	jb noUMBlink
	mov ax,0x5802		; get UMB link state
	int 0x21
	mov [0xfe],al		; store UMB link state
	mov ax,0x5803		; set UMB link state
	mov bx,1		; add UMBs to MCB chain
	int 0x21
noUMBlink:

	push es			; << SAVE

	mov ah,0x52	; get list of lists
	int 0x21
	; we just assume that BX is at least 2 here
	; for FreeDOS, LoL is at segment 0xcf or a bit later,
	; right after the 70:0 area which has all basic device drivers

	; LoL[0x08] will usually point to 70:xx (last CLOCK$ header)
	; unless you load another CLOCK$ driver.
	; *** we could surf the device list, last device will be, at
	; *** least in FreeDOS, at 70:xxx (to verify 70 value).
	; *** What are other useful ways to get the kernel segment?

	mov ax,[es:bx-2]	; segment of first MCB
	mov [mcbstart],ax	; -> linked nodes

	mov eax,[es:bx]		; pointer to DDPT (drive param table)
	mov [ddptptr],eax
	mov eax,[es:bx+4]	; pointer to SFT (system file table)
	mov [sftptr],eax
	mov eax,[es:bx+0x12]	; pointer to first BUFFER (linked nodes)
	mov [bufferptr],eax
	mov eax,[es:bx+0x16]	; pointer to CDS (current dir structure)
	mov [cdsptr],eax	; -> array, size=LASTDRIVE=[es:bx+21]
	mov eax,[es:bx+0x22]	; pointer to NUL header (first device)
	mov [nulptr],eax	; -> linked nodes, will usually be:
	; NUL, last_loaded, ... first_loaded, first_kernel, ... last_kernel
	; kernel devices: CON PRN AUX LPT1-LPT3 COM1-COM4 CLOCK$ A:-?:

	pop es			; << RESTORE

	; ---------

mcbsurfer:			; End of area which can be overwritten
	xor ebx,ebx		; top-of-useful linear address
	xor ecx,ecx		; start-of-useful linear address
	mov ax,[mcbstart]	; first MCB to look at

	push es			; <<< SAVE

nextmcb:
	mov es,ax
	mov bp,ax		; store segment, for convenience
	movzx eax,ax
	shl eax,4
	or al,15		; round up: include next MCB header in range!
	mov ebx,eax
	mov al,[es:0]		; normal M / last Z
	cmp al,'Z'
	jz scandone
	mov ax,[es:1]		; type / PSP for segment (8 = DOS 0 = free)
	or ax,ax		; free?
	jnz somemcb
freemcb:
	mov ax,[es:3]		; size below threshold (16*256 bytes, 4kB) ?
	cmp ax,256		; treat < 4k sized free areas as full areas
	jb somemcb

skippedrange:
	call STORERANGE		; add range to list: includes the MCB header
				; of the free MCB itself but not the contents
	mov ax,[es:3]		; size (paras)
	add ax,bp		; base (seg)
	inc ax			; next MCB seg
	push ax
	movzx eax,ax
	shl eax,4
	mov ecx,eax		; start of the next useful range
	mov ebx,eax		; nothing in the range yet
	pop ax
	jmp short nextmcb	; continue with MCB at AX:0 ...

somemcb:
	cmp ax,8		; DOS?
	jbe dosmcb
othermcb:
	mov ax,[es:3]		; size (paras)
	add ax,bp		; base (seg)
	inc ax			; next MCB seg
	jmp short nextmcb	; count this MCB as used and scan on

dosmcb:				; a DOS system data MCB
	; in DOS 5+, [8] can be "SC" for "reserved" or "SD" for "used"
	; reserved usually means things like ROM/VGA space in UMB
	cmp byte [cs:dosver],5	; DOS version with reserved range support?
	jb dosmcb2
	cmp word [es:8],"SC"	; reserved?
	jz freemcb		; treat it as free
dosmcb2:
	jmp short othermcb	; treat it as used MCB


scandone:
	mov ax,[es:1]		; type / PSP for segment (8 = DOS 0 = free)
	or ax,ax		; free?
	jnz last_is_used
	mov ax,[es:3]		; size below threshold (16*256 bytes) ?
	cmp ax,256		; treat < 4k free areas as full areas
	ja last_is_free		; free is only free if big enough
last_is_used:
	mov ax,bp		; MCB segment
	add ax,[es:3]		; size
	inc ax			; next MCB seg would be (there is none)
	; *** if this could be 0 now, we would have a problem
	movzx eax,ax
	shl eax,4
	dec eax			; round down, exclude "next MCB"
	mov ebx,eax		; update end of range
last_is_free:
	call STORERANGE		; add final ecx..ebx range to list

	pop es			; <<< RESTORE

	mov ax,") "		; only a marker for debug
	stosw
	mov ax,"**"		; only a marker for debug
	stosw

	mov ax, [narea]		; how many areas found?
	cmp ax,32		; limit for Win3.x is 32 ...!
	jb narea_okay
	mov word [narea],32	; limit
	mov ah,9		; show string
	mov dx,areamaxmsg
	int 0x21
narea_okay:

	; ---------

	cmp byte [dosver],5	; DOS version with UMB support?
	jb noUMBunlink
	mov bl,[0xfe]		; restore UMB link state
	mov bh,0
	mov ax,0x5803		; set UMB link state
	int 0x21
noUMBunlink:

	push ds
	xor ax,ax
	mov ds,ax
	mov eax,[ds:0x2f*4]	; get int vector
	mov [cs:old2f],eax
	mov ax,cs
	shl eax,16
	mov ax,int2f		; new int handler
	mov [ds:0x2f*4],eax
	pop ds

	mov ah,9		; show string
	mov dx,helpmsg		; banner message and some win3.x hints
	int 0x21

	add di,15		; round up instance data pointer
	shr di,4		; to paragraphs
	mov dx,di		; TSR size
	mov ax,0x3100		; stay TSR
	int 0x21

; -------------------------------------

STORERANGE:	; add linear ecx ... ebx range to list of areas at DI
		; destroys ebx ecx
	push ax
	push es

	push cs
	pop es

	cmp ecx,ebx
	jz norangetostore
	cmp di,mcbsurfer	; reaching dangerous areas?
	jb rangeokay		; drop range, do not overwrite setup code
	push ds
	mov ah,9		; show string
	mov dx,areaspacemsg	; out of storage space
	int 0x21
	pop ds
	jmp norangetostore

rangeokay:
	inc word [narea]	; threshold helped to avoid limit ;-)
	mov eax,ecx
	inc ebx
	sub ebx,eax		; size of range
	and cx,15		; offset
	shr eax,4
	stosw			; segment
	mov ax,cx
	stosw			; offset
multisegment:
	cmp ebx,0xfff0		; more than almost 64k?
	mov ax,bx
	jb last64k
	mov ax,0xfff0		; first part
	stosw			; size of part

	sub ebx,0xfff0		; processed almost 64k
	inc word [narea]
	mov ax,[di-6]		; di pointed to new segment, read old one
	add ax,0xfff		; move almost 64k further
	stosw			; segment save, then update di
	mov ax,[di-6]		; di pointed to new offset, read old one
	stosw			; offset is the same
	mov ax,bx		; possible rest of size
	jmp short multisegment	; continue storing (size or multisegment)

last64k:
	stosw			; size

norangetostore:
	pop es
	pop ax
	ret

; -------------------------------------

havehmamsg	db "DOS is using HMA.",13,10,"$"
haveebdamsg	db "EBDA is present. Hope Win3.x understands this.",13,10,"$"
areamaxmsg	db "Tried to mark more than 32 areas - too fragmented!",13,10
		db "Will mark only first 32 areas. Good luck.",13,10,"$"
wrongvermsg	db "Wrong DOS version, 3.1-7.x required",13,10,"$"
areaspacemsg	db "Ran out of instance data description storage space."
		db 13,10,"$"

helpmsg	db 13,10
	db "Free INSTANCE driver loaded. Try running Win3.x now,",13,10
	db "suggested command line: WIN /3 /B /D:FSVX /B",13,10
	db 13,10
	db "See: http://support.microsoft.com/?id=82731",13,10
	db "     'Wind*ws 3.1 WIN.COM Command Switches'",13,10
	db "  /B create bootlog.txt /3 386 enhanced mode",13,10
	db "  /D:FSVX no 32 bit disk access / no BIOS breakpoints /",13,10
	db "   use BIOS disk access / do not touch UMB area",13,10
	db "Avoid non-MS EMM386 / UMBPCI and fancy TSRs and mouse drivers.",13,10
	db 13,10
	db "WDCTRL.386 disk driver can show 'Invalid DOS version'",13,10
	db "  if your DOS does not support int 2f.13 interface.",13,10
	db "Set DOS version to 3.32-9.xx range, e.g. with VERSION=5.0 or",13,10
	db "  'CALLVER 5.00 WIN...' (set COMSPEC to a 5.0 shell, too)",13,10
	db "Win /S - except DOS boxes there - should not need INSTANCE.",13,10
	db "If you have 256+ MB RAM, add to [386Enh] in .ini files:",13,10
	db "Paging=No",13,10		; no swapfile to be used
	db "PageOverCommit=1",13,10	; default is 4: XMS*P. is VMem size
	db "$"


realend:

; Typical situation in DOSEMU/FreeDOS:
; 2f cf:108a,  mcb 027f,  ddpt cf:1976,  sft cf:00cc,  1st buffer cf:6d,
; cds c43f:0,  nul c33a:0 hma 2d2f,  ver 0a07,  ebdaseg 0 ebdasize 0,
; Instance info: kernel 70 stacks 0 areas 4
; Area list: 0:0/4000 9fff:0/10 c300:0/1930 df2e:0/0d20
