#include <fenv.h>
#pragma STDC FENV_ACCESS ON
#include <float.h>
#include <inttypes.h>
#include <limits.h>
#include <math.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>

static bool verbose = false;
#define PI M_PI

// return binary representation
int ulp (double x)
{
    union
    {
        double  d;
        int64_t i;
    } p;

    p.d = x;

    if (p.i) // error is 0 for 0.0
    {
        p.i   = imaxabs (p.i); // absolute value
        p.i >>= DBL_MANT_DIG - 1; // single out exponent
        p.i  -= DBL_MAX_EXP - 1; // debase exponent
        p.i   = imaxabs (p.i); // absolute exponent
        p.i   = DBL_MANT_DIG - p.i; // mantissa
    }

    return (p.i);
}

// accuracy of trigonometric functions
void trigtest()
{
    static const double range = PI; // * 2.0;
    static const double incr  = PI / 100.0;

    if (verbose)
       printf("          x                diff             accuracy\n");

    double final = 1.0;
    double x;

    for (x = -range; x <= range; x += incr)
    {
        double s1  = sin(x);
        double c1  = cos(x);
        double one = s1 * s1 + c1 * c1;
        double diff = one - 1.0;
        final *= one;

        int accuracy = ulp (diff);

        if (verbose)
            printf("%20.15f %14g %d\n",x,diff,accuracy);
    }

    final -= 1.0;

    printf("cumulative error: %d (ulp)\n",
           ulp (final));

    printf("                 %+21.15g (decimal)\n",
           final);
}

// Entry point
int main(int argc, char ** argv)
{
    int i;

    // do we have verbose output?
    if (argc > 1)
    {
        for (i = 1; i < argc; ++i)
        {
            if (!strcmp(argv[i],"-v"))
            {
                verbose = true;
                break;
            }
        }
    }

    // run tests
    trigtest();

    // done
    return 0;
}

