/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;

public class HttpMessage {
    URL servlet;
    String args;

    public HttpMessage(URL servlet) {
        this.servlet = servlet;
    }

    public InputStream sendGetMessage() throws IOException {
        return this.sendGetMessage(null);
    }

    public InputStream sendGetMessage(Properties args) throws IOException {
        String argString = "";
        if (args != null) {
            argString = "?" + this.toEncodedString(args);
        }
        URL url = new URL(String.valueOf(this.servlet.toExternalForm()) + argString);
        URLConnection con = url.openConnection();
        con.setUseCaches(false);
        return con.getInputStream();
    }

    public InputStream sendPostMessage() throws IOException {
        return this.sendPostMessage(null);
    }

    public InputStream sendPostMessage(Properties args) throws IOException {
        String argString = "";
        if (args != null) {
            argString = this.toEncodedString(args);
        }
        URLConnection con = this.servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        DataOutputStream out = new DataOutputStream(con.getOutputStream());
        out.writeBytes(argString);
        out.flush();
        out.close();
        return con.getInputStream();
    }

    public InputStream sendPostMessage(Serializable obj) throws IOException {
        URLConnection con = this.servlet.openConnection();
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "java-internal/" + obj.getClass().getName());
        ObjectOutputStream out = new ObjectOutputStream(con.getOutputStream());
        out.writeObject(obj);
        out.flush();
        out.close();
        return con.getInputStream();
    }

    private String toEncodedString(Properties args) {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> names = args.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            buf.append(String.valueOf(URLEncoder.encode(name)) + "=" + URLEncoder.encode(value));
            if (!names.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }
}

