/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.MultipartInputStreamHandler;
import com.oreilly.servlet.UploadedFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletRequest;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    private ServletRequest req;
    private File dir;
    private int maxSize;
    private Hashtable parameters = new Hashtable();
    private Hashtable files = new Hashtable();

    public MultipartRequest(ServletRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.req = request;
        this.dir = new File(saveDirectory);
        this.maxSize = maxPostSize;
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!this.dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        this.readRequest();
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String name) {
        try {
            String param = (String)this.parameters.get(name);
            if (param.equals("")) {
                return null;
            }
            return param;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFilesystemName(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getFilesystemName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getContentType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void readRequest() throws IOException {
        String type = this.req.getContentType();
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int length = this.req.getContentLength();
        if (length > this.maxSize) {
            throw new IOException("Posted content length of " + length + " exceeds limit of " + this.maxSize);
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        MultipartInputStreamHandler in = new MultipartInputStreamHandler(this.req.getInputStream(), boundary, length);
        String line = in.readLine();
        if (line == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!line.startsWith(boundary)) {
            throw new IOException("Corrupt form data: no leading boundary");
        }
        boolean done = false;
        while (!done) {
            done = this.readNextPart(in, boundary);
        }
    }

    protected boolean readNextPart(MultipartInputStreamHandler in, String boundary) throws IOException {
        String line = in.readLine();
        if (line == null) {
            return true;
        }
        String[] dispInfo = this.extractDispositionInfo(line);
        String disposition = dispInfo[0];
        String name = dispInfo[1];
        String filename = dispInfo[2];
        line = in.readLine();
        if (line == null) {
            return true;
        }
        String contentType = this.extractContentType(line);
        if (contentType != null) {
            line = in.readLine();
            if (line == null || line.length() > 0) {
                throw new IOException("Malformed line after content type: " + line);
            }
        } else {
            contentType = "application/octet-stream";
        }
        if (filename == null) {
            String value = this.readParameter(in, boundary);
            this.parameters.put(name, value);
        } else {
            this.readAndSaveFile(in, boundary, filename);
            if (filename.equals("unknown")) {
                this.files.put(name, new UploadedFile(null, null, null));
            } else {
                this.files.put(name, new UploadedFile(this.dir.toString(), filename, contentType));
            }
        }
        return false;
    }

    protected String readParameter(MultipartInputStreamHandler in, String boundary) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        while ((line = in.readLine()) != null) {
            if (line.startsWith(boundary)) break;
            sbuf.append(String.valueOf(line) + "\r\n");
        }
        if (sbuf.length() == 0) {
            return null;
        }
        sbuf.setLength(sbuf.length() - 2);
        return sbuf.toString();
    }

    protected void readAndSaveFile(MultipartInputStreamHandler in, String boundary, String filename) throws IOException {
        int result;
        File f = new File(String.valueOf(this.dir) + File.separator + filename);
        FileOutputStream fos = new FileOutputStream(f);
        BufferedOutputStream out = new BufferedOutputStream(fos, 8192);
        byte[] bbuf = new byte[102400];
        boolean rnflag = false;
        while ((result = in.readLine(bbuf, 0, bbuf.length)) != -1) {
            String line;
            if (result > 2 && bbuf[0] == 45 && bbuf[1] == 45 && (line = new String(bbuf, 0, result, "ISO-8859-1")).startsWith(boundary)) break;
            if (rnflag) {
                out.write(13);
                out.write(10);
                rnflag = false;
            }
            if (result >= 2 && bbuf[result - 2] == 13 && bbuf[result - 1] == 10) {
                out.write(bbuf, 0, result - 2);
                rnflag = true;
                continue;
            }
            out.write(bbuf, 0, result);
        }
        out.flush();
        out.close();
        fos.close();
    }

    private String extractBoundary(String line) {
        int index = line.indexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        boundary = "--" + boundary;
        return boundary;
    }

    private String[] extractDispositionInfo(String line) throws IOException {
        String[] retval = new String[3];
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String name = origline.substring(start + 6, end);
        String filename = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
            if (filename.equals("")) {
                filename = "unknown";
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        return retval;
    }

    private String extractContentType(String line) throws IOException {
        String contentType = null;
        String origline = line;
        if ((line = origline.toLowerCase()).startsWith("content-type")) {
            int start = line.indexOf(" ");
            if (start == -1) {
                throw new IOException("Content type corrupt: " + origline);
            }
            contentType = line.substring(start + 1);
        } else if (line.length() != 0) {
            throw new IOException("Malformed line after disposition: " + origline);
        }
        return contentType;
    }
}

