/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.ParameterNotFoundException;
import javax.servlet.ServletRequest;

public class ParameterParser {
    private ServletRequest req;

    public ParameterParser(ServletRequest req) {
        this.req = req;
    }

    public String getStringParameter(String name) throws ParameterNotFoundException {
        String[] values = this.req.getParameterValues(name);
        if (values == null) {
            throw new ParameterNotFoundException(String.valueOf(name) + " not found");
        }
        if (values[0].length() == 0) {
            throw new ParameterNotFoundException(String.valueOf(name) + " was empty");
        }
        return values[0];
    }

    public String getStringParameter(String name, String def) {
        try {
            return this.getStringParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public boolean getBooleanParameter(String name) throws ParameterNotFoundException {
        return new Boolean(this.getStringParameter(name));
    }

    public boolean getBooleanParameter(String name, boolean def) {
        try {
            return this.getBooleanParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public byte getByteParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Byte.parseByte(this.getStringParameter(name));
    }

    public byte getByteParameter(String name, byte def) {
        try {
            return this.getByteParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public char getCharParameter(String name) throws ParameterNotFoundException {
        String param = this.getStringParameter(name);
        if (param.length() == 0) {
            throw new ParameterNotFoundException(String.valueOf(name) + " is empty string");
        }
        return param.charAt(0);
    }

    public char getCharParameter(String name, char def) {
        try {
            return this.getCharParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public double getDoubleParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return new Double(this.getStringParameter(name));
    }

    public double getDoubleParameter(String name, double def) {
        try {
            return this.getDoubleParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public float getFloatParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return new Float(this.getStringParameter(name)).floatValue();
    }

    public float getFloatParameter(String name, float def) {
        try {
            return this.getFloatParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public int getIntParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Integer.parseInt(this.getStringParameter(name));
    }

    public int getIntParameter(String name, int def) {
        try {
            return this.getIntParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public long getLongParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Long.parseLong(this.getStringParameter(name));
    }

    public long getLongParameter(String name, long def) {
        try {
            return this.getLongParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }

    public short getShortParameter(String name) throws ParameterNotFoundException, NumberFormatException {
        return Short.parseShort(this.getStringParameter(name));
    }

    public short getShortParameter(String name, short def) {
        try {
            return this.getShortParameter(name);
        }
        catch (Exception exception) {
            return def;
        }
    }
}

