/*
 * Decompiled with CFR 0.152.
 */
package com.portaljava.util.objsmtp;

import com.portaljava.util.objsmtp.Mail;
import com.portaljava.util.objsmtp.Status;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;

public class Smtp {
    static final int DEFAULT_PORT = 25;
    static final String EOL = "\r\n";
    protected String Host = null;
    protected int Port;
    protected DataInputStream reply = null;
    protected PrintStream send = null;
    protected Socket sock = null;

    public Smtp() {
    }

    public Smtp(String host) {
        this.Host = host;
    }

    public Smtp(InetAddress address) {
        this.Host = address.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status connect() {
        Status status = new Status();
        if (this.Host == null) {
            status._Response = "-ERR Host not specified";
            status._OK = false;
            return status;
        }
        try {
            this.sock = new Socket(this.Host, this.Port);
            this.reply = new DataInputStream(this.sock.getInputStream());
            this.send = new PrintStream(this.sock.getOutputStream());
            String rstr = this.reply.readLine();
            if (!rstr.startsWith("220")) {
                throw new ProtocolException(rstr);
            }
            while (rstr.indexOf(45) == 3) {
                rstr = this.reply.readLine();
                if (rstr.startsWith("220")) continue;
                throw new ProtocolException(rstr);
            }
        }
        catch (Exception e) {
            String msg = "Exception! " + e.toString();
            status._OK = false;
            status._Response = msg;
            this.sock = null;
        }
        if (this.sock != null) {
            String msg = "SMTP: connect ok";
            status._OK = true;
            status._Response = msg;
        }
        return status;
    }

    public Status connect(String hostid) {
        return this.connect(hostid, 25);
    }

    public Status connect(String hostid, int port) {
        this.Host = hostid;
        this.Port = port;
        return this.connect();
    }

    public Status connect(InetAddress address) {
        return this.connect(address, 25);
    }

    public Status connect(InetAddress address, int port) {
        return this.connect(address.toString(), port);
    }

    private String msgDateFormat(Date senddate) {
        String formatted = "hold";
        String[] Day = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        String[] Month = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        formatted = String.valueOf(Day[senddate.getDay()]) + ", ";
        formatted = String.valueOf(formatted) + String.valueOf(senddate.getDate()) + " ";
        formatted = String.valueOf(formatted) + Month[senddate.getMonth()] + " ";
        formatted = senddate.getYear() > 99 ? String.valueOf(formatted) + String.valueOf(senddate.getYear() + 1900) + " " : String.valueOf(formatted) + String.valueOf(senddate.getYear()) + " ";
        if (senddate.getHours() < 10) {
            formatted = String.valueOf(formatted) + "0";
        }
        formatted = String.valueOf(formatted) + String.valueOf(senddate.getHours()) + ":";
        if (senddate.getMinutes() < 10) {
            formatted = String.valueOf(formatted) + "0";
        }
        formatted = String.valueOf(formatted) + String.valueOf(senddate.getMinutes()) + ":";
        if (senddate.getSeconds() < 10) {
            formatted = String.valueOf(formatted) + "0";
        }
        formatted = String.valueOf(formatted) + String.valueOf(senddate.getSeconds()) + " ";
        formatted = senddate.getTimezoneOffset() < 0 ? String.valueOf(formatted) + "+" : String.valueOf(formatted) + "-";
        if (Math.abs(senddate.getTimezoneOffset()) / 60 < 10) {
            formatted = String.valueOf(formatted) + "0";
        }
        formatted = String.valueOf(formatted) + String.valueOf(Math.abs(senddate.getTimezoneOffset()) / 60);
        if (Math.abs(senddate.getTimezoneOffset()) % 60 < 10) {
            formatted = String.valueOf(formatted) + "0";
        }
        formatted = String.valueOf(formatted) + String.valueOf(Math.abs(senddate.getTimezoneOffset()) % 60);
        return formatted;
    }

    public Status quit() {
        Status status = new Status();
        try {
            this.send.print("QUIT");
            this.send.print(EOL);
            this.send.flush();
            this.sock.close();
            String msg = "SMTP: quit ok";
            status._OK = true;
            status._Response = msg;
        }
        catch (IOException e) {
            String msg = "Exception! " + e.toString();
            status._OK = false;
            status._Response = msg;
        }
        return status;
    }

    public Status sendmsg(Mail nmail) {
        InetAddress local;
        Status status = new Status();
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ioe) {
            status._Response = "-ERR No local IP address found - is your network up?";
            status._OK = false;
            return status;
        }
        try {
            String host = local.getHostName();
            this.send.print("HELO " + host);
            this.send.print(EOL);
            this.send.flush();
            String rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            String sstr = "MAIL FROM: " + nmail.sfrom;
            this.send.print(sstr);
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            sstr = "RCPT TO: " + nmail.sto;
            this.send.print(sstr);
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            this.send.print("DATA");
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("354")) {
                throw new ProtocolException(rstr);
            }
            this.send.print("From: " + nmail.from);
            this.send.print(EOL);
            this.send.print("To: " + nmail.to);
            this.send.print(EOL);
            this.send.print("Subject: " + nmail.subject);
            this.send.print(EOL);
            Date today_date = new Date();
            this.send.print("Date: " + nmail.date);
            this.send.print(EOL);
            this.send.flush();
            this.send.print("Comment: Unauthenticated sender");
            this.send.print(EOL);
            this.send.print("X-Mailer: Mailage 1.0");
            this.send.print(EOL);
            this.send.print(EOL);
            this.send.print(nmail.body);
            this.send.print(EOL);
            this.send.print(".");
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            String msg = "SMTP: send mail ok";
            status._OK = true;
            status._Response = msg;
        }
        catch (Exception e) {
            String msg = "Exception! " + e.toString();
            status._OK = false;
            status._Response = msg;
        }
        return status;
    }

    public Status sendmsg(String from_address, String to_address, String subject, String message) throws IOException, ProtocolException {
        InetAddress local;
        Status status = new Status();
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ioe) {
            status._Response = "-ERR No local IP address found - is your network up?";
            status._OK = false;
            System.out.println("-ERR No local IP address found - is your network up?");
            return status;
        }
        try {
            String host = local.getHostName();
            this.send.print("HELO " + host);
            this.send.print(EOL);
            this.send.flush();
            String rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            String sstr = "MAIL FROM: " + from_address;
            this.send.print(sstr);
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            sstr = "RCPT TO: " + to_address;
            this.send.print(sstr);
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            this.send.print("DATA");
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("354")) {
                throw new ProtocolException(rstr);
            }
            this.send.print("From: " + from_address);
            this.send.print(EOL);
            this.send.print("To: " + to_address);
            this.send.print(EOL);
            this.send.print("Subject: " + subject);
            this.send.print(EOL);
            Date today_date = new Date();
            this.send.print("Date: " + this.msgDateFormat(today_date));
            this.send.print(EOL);
            this.send.flush();
            this.send.print("Comment: Unauthenticated sender");
            this.send.print(EOL);
            this.send.print("X-Mailer: JNet smtp");
            this.send.print(EOL);
            this.send.print(EOL);
            this.send.print(message);
            this.send.print(EOL);
            this.send.print(".");
            this.send.print(EOL);
            this.send.flush();
            rstr = this.reply.readLine();
            if (!rstr.startsWith("250")) {
                throw new ProtocolException(rstr);
            }
            String msg = "SMTP: send mail ok";
            status._OK = true;
            status._Response = msg;
        }
        catch (Exception e) {
            String msg = "Exception! " + e.toString();
            status._OK = false;
            status._Response = msg;
            System.out.println("Exception! " + e.toString());
        }
        return status;
    }

    public static void main(String[] args) {
        System.out.println("Entrou na main");
        Smtp s = new Smtp();
        try {
            s.sendmsg("dalton@portaljava.com", "dalton@portaljava.com", "subject", "msg");
        }
        catch (Exception e) {
            System.out.println("Deu erro no mail");
        }
    }
}

