# -*- coding: utf-8 -*-
"""
ldr.py

Display analog data from Arduino using Python (matplotlib)

Author: Mahesh Venkitachalam
Website: electronut.in
"""

import serial, time
import numpy as np
from collections import deque

from lib.RingBuffer import RingBuffer      
from lib.crc8 import calcCRC                                                   # Biblioteca CRC8

# plot class
class AnalogPlot:
  # constr
  def __init__(self, strPort, ser_baudrate, maxLen, tempo_anim):
      # open serial port
      self.t0 = time.time()
      
      self.draw_count = 0
      self.draw_when = 2/(tempo_anim*1e-3)
      
      self.old_size = 0;
      
      self.ser = serial.Serial(strPort, ser_baudrate, timeout=2)
      self.ser.flushInput()
      self.ser.flushOutput()

      self.maxLen = maxLen
      
      # MPX, MAP, TPS, O2A, O2B, MAT, CLT, AD01, AD02, Rot
      self.Tempo   = RingBuffer(int(maxLen))
      self.MPX     = RingBuffer(int(maxLen))
      self.MAP     = RingBuffer(int(maxLen))
      self.TPS     = RingBuffer(int(maxLen))
      self.O2A     = RingBuffer(int(maxLen))
      self.O2B     = RingBuffer(int(maxLen))
      self.MAT     = RingBuffer(int(maxLen))
      self.CLT     = RingBuffer(int(maxLen))
      self.AD01    = RingBuffer(int(maxLen))      
      self.AD02    = RingBuffer(int(maxLen))      
      self.Rot     = RingBuffer(int(maxLen))
      self.TempCpu = RingBuffer(int(maxLen))
      self.TenBat  = RingBuffer(int(maxLen))
      
#      for i in np.zeros(maxLen):       
#          self.Tempo.append(time.time()-self.t0)
#          self.MPX.append(i)
#          self.MAP.append(i)
#          self.TPS.append(i)
#          self.O2A.append(i)
#          self.O2B.append(i)
#          self.MAT.append(i)
#          self.CLT.append(i)
#          self.AD01.append(i)
#          self.AD02.append(i)
#          self.Rot.append(i)
#          self.TempCpu.append(i)          
#          self.TenBat.append(i)
          
      self.solicitacao = chr(17)

  # add data
  def add(self, data):
      self.Tempo.append(time.time()-self.t0)
      self.MPX.append(data[0])
      self.MAP.append(data[1])
      self.TPS.append(data[2])
      self.O2A.append(data[3])
      self.O2B.append(data[4])
      self.MAT.append(data[5])
      self.CLT.append(data[6])
      self.AD01.append(data[7])
      self.AD02.append(data[8])
      self.Rot.append(data[9])
      self.TempCpu.append(data[10])      
      self.TenBat.append(data[11])

  def init(self, pMPX, pMAP, pTPS, pRot):
            
        pMPX.set_data([], [])
        pMAP.set_data([], [])
        pTPS.set_data([], [])
        pRot.set_data([], [])    
    
        return pMPX, pMAP, pTPS, pRot,    
    
  # update plot
  def update(self, frameNum, 
             pMPX, pMAP, pTPS, pO2A, pO2B, pMAT, pCLT, pAD01, pAD02, pRot,
             f1s1_ax1, f1s1_ax2, f1s2, f2s1, f2s2, f2s3, f2s4,
             fig):      
      
      try:
#          f1s1_ax2.clear()
#          current_size = f1s1_ax1.bbox.width, f1s1_ax1.bbox.height
#          if self.old_size != current_size:
#              self.old_size = current_size
#              f1s1_ax1.clear()
#              fig.canvas.draw()
#              f1s1_ax1.grid()
              #pMPX.set_data([], [])
              #pMAP.set_data([], [])
              #pTPS.set_data([], [])
              #f1s1_ax1.draw()
              #fig.canvas.draw()
              #self.ax_background = self.copy_from_bbox(self.f1s1_ax1.bbox)
          #if (self.draw_count >= self.draw_when):
               #self.draw_count = 0
               #f1s1_ax1.clear()
               #fig.canvas.blit(f1s1_ax1.bbox)               
               #f1s1_ax1.plot([],[])
               #print "Entrou"
          #else:
               #self.draw_count += 1
          
          integridade_bool = False
          while not integridade_bool:
              
              self.ser.write(self.solicitacao)
              cab_bool = False
              while not cab_bool:
                  cab_byte01 = self.ser.read(1)
                  if len(cab_byte01) == 0:
                      self.ser.write(self.solicitacao)
                      continue                  
                  if ord(cab_byte01) == 105:
                      cab_byte02 = self.ser.read(1)
                      if ord(cab_byte02) == 16:
                          cab_bool = True
                      else:
                          self.ser.write(self.solicitacao)
                  else:
                      self.ser.write(self.solicitacao)
                  
              dados_serial = self.ser.read(23)
              dados_serial = cab_byte01 + cab_byte02 + dados_serial
              CRC8 = calcCRC(dados_serial[:-1])
              
              if ( CRC8 == ord(dados_serial[-1]) ):
                  integridade_bool = True        
          
          Cabecalho_r = ord(dados_serial[0]) | ( ord(dados_serial[1]) <<8 )
          MPX_r       = ord(dados_serial[2]) | ( ord(dados_serial[3]) <<8 )
          MAP_r       = ord(dados_serial[4]) | ( ord(dados_serial[5]) <<8 )
          TPS_r       = ord(dados_serial[6]) | ( ord(dados_serial[7]) <<8 )
          O2A_r       = ord(dados_serial[8]) | ( ord(dados_serial[9]) <<8 )
          O2B_r       = ord(dados_serial[10]) | ( ord(dados_serial[11]) <<8 )
          MAT_r       = ord(dados_serial[12]) | ( ord(dados_serial[13]) <<8 )
          CLT_r       = ord(dados_serial[14]) | ( ord(dados_serial[15]) <<8 )
          AD01_r      = ord(dados_serial[16]) | ( ord(dados_serial[17]) <<8 )
          AD02_r      = ord(dados_serial[18]) | ( ord(dados_serial[19]) <<8 )
          Rotacao_r   = ord(dados_serial[20]) | ( ord(dados_serial[21]) <<8 )
          TempCpu_r   = ord(dados_serial[22])
          TenBat_r    = ord(dados_serial[23])          
          
          #print TenBat_r
          # print data
          data = [MPX_r, MAP_r, TPS_r, O2A_r, O2B_r, MAT_r, CLT_r,
                  AD01_r, AD02_r, Rotacao_r, TempCpu_r, TenBat_r]        
          self.add(data)
          
          aux_Tempo    = self.Tempo.get()    
          aux_MPX      = self.MPX.get()
          aux_MAP      = self.MAP.get()
          aux_TPS      = self.TPS.get()
          aux_O2A      = self.O2A.get()
          aux_O2B      = self.O2B.get()
    
          aux_MAT      = self.MAT.get()
          aux_CLT      = self.MAT.get()
          aux_AD01     = self.MAT.get()
          aux_AD02     = self.MAT.get()
                    
          aux_Rot      = self.Rot.get()
          aux_TempCpu  = self.TempCpu.get()
          
          aux_TenBat   = self.TenBat.get()
          
          pMPX.set_data(aux_Tempo, aux_MPX)
          pMAP.set_data(aux_Tempo, aux_MAP)
          pTPS.set_data(aux_Tempo, aux_TPS)
          pO2A.set_data(aux_Tempo, aux_O2A)          
          pO2B.set_data(aux_Tempo, aux_O2B)
          pMAT.set_data(aux_Tempo, aux_MAT)
          pCLT.set_data(aux_Tempo, aux_CLT)
          pAD01.set_data(aux_Tempo, aux_AD01)
          pAD02.set_data(aux_Tempo, aux_AD02)
          pRot.set_data(aux_Tempo, aux_Rot)
          
          f1s1_ax1.set_xlim(aux_Tempo[0], aux_Tempo[-1])
          f1s1_ax2.set_xlim(aux_Tempo[0], aux_Tempo[-1])
          f1s2.set_xlim(aux_Tempo[0], aux_Tempo[-1])
    
          f2s1.set_xlim(aux_Tempo[0], aux_Tempo[-1])    
          f2s2.set_xlim(aux_Tempo[0], aux_Tempo[-1])    
          f2s3.set_xlim(aux_Tempo[0], aux_Tempo[-1])    
          f2s4.set_xlim(aux_Tempo[0], aux_Tempo[-1]) 
          
          #f1s1_ax2.fill_between(aux_Tempo, aux_Rot, 0, color='blue', alpha=.2)
          
#==============================================================================
#           if (self.draw_count >= self.draw_when):
#               self.draw_count = 0
#               fig.canvas.draw()
#           else:
#               self.draw_count += 1
#==============================================================================
      

      except KeyboardInterrupt:
          print('exiting')
      
      return pMPX, pMAP, pTPS, pO2A, pO2B, pMAT, pCLT, pAD01, pAD02, pRot,

  # clean up
  def close(self):
      # close serial
      self.ser.flush()
      self.ser.close()    

# call main
if __name__ == '__main__':
  main()
