extern "C"{
#include <GL/gl.h>
#include <GL/glut.h>
}

#include <iostream>

int fps_time = 0;
int fps_timebase = 0;
int frame = 0;
int sleep_time = 0;

#define TEXT_NUM 1
#define TEXT_SIZE 256
GLuint textures[TEXT_NUM];

void initGL (int argc, char* argv[])
{
  unsigned char* bitmap = new unsigned char [TEXT_SIZE * TEXT_SIZE * 3];

  for (int i = 0; i < TEXT_SIZE * TEXT_SIZE * 3; i += 3)
    bitmap[i] = (i * 4) % 256;

  glGenTextures (TEXT_NUM , textures);
  glEnable (GL_TEXTURE_2D);

  for (int i = 0; i < TEXT_NUM; i++){
    for (int j = 1; j < TEXT_SIZE * TEXT_SIZE * 3; j += 3) {
      bitmap[j] = (i * 4) % 256;
      bitmap[j + 1] = (i * 4) % 256;
    }
    glBindTexture (GL_TEXTURE_2D, textures[i]);

    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_S,GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_WRAP_T,GL_CLAMP);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
    
    
    glTexImage2D (GL_TEXTURE_2D, 0, GL_RGB, TEXT_SIZE, TEXT_SIZE,
		  0, GL_RGB, GL_UNSIGNED_BYTE, bitmap);
  }
  delete[] bitmap;
}

void 
keyPressed(unsigned char key, int x, int y)
{
  if (key == 'q') {
    exit (0);
  }
}

void
drawGLScene()
{

  frame++;
  fps_time = glutGet (GLUT_ELAPSED_TIME);
  if((fps_time - fps_timebase) > 1000){
    std::cout << "FPS:" << (1000 * frame) / (fps_time - fps_timebase) 
	      << std::endl;
    frame = 0;
    fps_timebase = fps_time;
  }

 

  float w = 200;
  float h = 75;
  float x = 0.0;
  for (int i = 0; i < 4; i++){
    float y = 0.0;
    for (int j = 0; j < 8; j++){
      glBindTexture (GL_TEXTURE_2D, textures[(j * 4) % TEXT_NUM]);
      glBegin (GL_QUADS);
      glVertex3f (x, y, -5);
      glTexCoord2f (0.0, 0.0);
      glVertex3f (x + w, y, -5);
      glTexCoord2f (1.0, 0.0);
      glVertex3f (x +w, y +h, -5);
      glTexCoord2f (1.0, 1.0);
      glVertex3f (x, y + h, -5);
      glTexCoord2f (0.0, 1.0);
      glEnd();
      y += h;
    }
    x += w;
  }
 
  glutSwapBuffers();
}

void 
idle()
{
  //  usleep (10000);
  
  glutPostRedisplay ();
}


int
main (int argc, char* argv[])
{
  glutInit (&argc, argv);  
  glutInitDisplayMode (GLUT_RGBA| GLUT_DOUBLE  );  
  glutInitWindowSize (800, 600);
  glutInitWindowPosition (100, 100);  
  glutCreateWindow ("");  
  
  glClearColor (0.0f, 0.0f, 0.0f, 0.0f);	
  glMatrixMode (GL_PROJECTION);
  glLoadIdentity ();			

  glOrtho (0, 800, 0, 600, 0, 500);
  glMatrixMode (GL_MODELVIEW);

  glutSetCursor(GLUT_CURSOR_NONE);
  glShadeModel (GL_FLAT);			
  glDisable (GL_DITHER);
  glEnable (GL_BLEND);
  glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

  glDisable(GL_DITHER);

  initGL (argc, argv);

  glutIdleFunc (idle);
  glutReshapeFunc (0);
  glutKeyboardFunc (keyPressed);
  glutDisplayFunc (drawGLScene);
  glutMainLoop ();  

  return 0;
}
