#include "postgres.h"

#include "fmgr.h"
#include "access/spgist.h"
#include "utils/rangetypes.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1(test_inner_consistent);
Datum
test_inner_consistent(PG_FUNCTION_ARGS)
{
	RangeType  *argument = PG_GETARG_RANGE(0);
	RangeType  *centroid = PG_GETARG_RANGE(1);
	RangeType  *prevCentroid = PG_ARGISNULL(2) ? NULL : PG_GETARG_RANGE(2);
	spgInnerConsistentIn in;
	spgInnerConsistentOut out;
	int i;
	bool		quadrants[5];

	memset(&in, 0, sizeof(in));
	memset(&out, 0, sizeof(out));

	in.scankeys = palloc0(sizeof(ScanKeyData));
	in.scankeys[0].sk_strategy = RANGESTRAT_ADJACENT;
	in.scankeys[0].sk_argument = RangeTypeGetDatum(argument);
	in.nkeys = 1;

	in.hasPrefix = true;
	in.prefixDatum = RangeTypeGetDatum(centroid);
	in.nNodes = 4;

	if (prevCentroid)
		in.reconstructedValue = PointerGetDatum(prevCentroid);

	OidFunctionCall2(3472, /* spg_range_quad_inner_consistent */
					 PointerGetDatum(&in),
					 PointerGetDatum(&out));

	memset(quadrants, 0, sizeof(quadrants));
	for (i = 0; i < out.nNodes; i++)
		quadrants[out.nodeNumbers[i]] = 1;

	elog(NOTICE, "quadrants: %d%d%d%d%d", quadrants[0], quadrants[1],
		 quadrants[2], quadrants[3], quadrants[4]);

	PG_RETURN_VOID();
}
