#include "crcmodel.h"
#include "crctable.out"

#include <stdio.h>

#define INIT 0xFFFFFFFF
#define INIT_REFLECTED 0xFFFFFFFF
#define XOROT 0xFFFFFFFF

/*
 * These crc_normal() and crc_reflected() functions are also directly from
 * Ross's document
 */

unsigned long crc_normal ();
unsigned long crc_normal (blk_adr,blk_len)
unsigned char *blk_adr;
unsigned long  blk_len;
{
    unsigned long crc = INIT;
    while (blk_len--)
       crc = crctable[((crc>>24) ^ *blk_adr++) & 0xFFL] ^ (crc << 8);
    return crc ^ XOROT;
}

unsigned long crc_reflected ();
unsigned long crc_reflected (blk_adr,blk_len)
unsigned char *blk_adr;
unsigned long  blk_len;
{
    unsigned long crc = INIT_REFLECTED;
    while (blk_len--)
       crc = crctable[(crc ^ *blk_adr++) & 0xFFL] ^ (crc >> 8);
    return crc ^ XOROT;
}

char *
bin(unsigned long x)
{
  static char buf[33];
  int i;
  for (i = 0; i < 32; i++)
  {
    if (x & (1 << (31-i)))
      buf[i] = '1';
    else
      buf[i] = '0';
  }
  buf[32] = '\0';
  return buf;
}

int main(int argc, char **argv)
{
  cm_t cm;
  char buf[1] = { 0x00 };
  int i;
  unsigned long crc;

  cm.cm_width = 32;
  cm.cm_poly = 0x04C11DB7;
  cm.cm_init = 0xFFFFFFFF;
  cm.cm_refin = 1;
  cm.cm_refot = 1;
  cm.cm_xorot = 0xFFFFFFFF;

  printf("Calculating CRC-32 (polynomial %08X) for a single zero byte:\n",
	 cm.cm_poly);

  cm_ini(&cm);
  for (i = 0; i < sizeof(buf); i++)
    cm_nxt(&cm, buf[i]);

  crc = cm_crc(&cm);
  printf("%08X %s (simple)\n", crc, bin(crc));

  crc = crc_normal(buf, sizeof(buf));
  printf("%08X %s (lookup)\n", crc, bin(crc));
  crc = crc_reflected(buf, sizeof(buf));
  printf("%08X %s (lookup reflected)\n", crc, bin(crc));
}
