/*
 * contrib/useless_gist/useless_gist.c
 */
#include "postgres.h"

#include "access/gist.h"
#include "access/skey.h"
#include "fmgr.h"

PG_MODULE_MAGIC;

PG_FUNCTION_INFO_V1(useless_compress);
PG_FUNCTION_INFO_V1(useless_union);
PG_FUNCTION_INFO_V1(useless_picksplit);
PG_FUNCTION_INFO_V1(useless_consistent);
PG_FUNCTION_INFO_V1(useless_distance);
PG_FUNCTION_INFO_V1(useless_penalty);
PG_FUNCTION_INFO_V1(useless_same);
PG_FUNCTION_INFO_V1(useless_decompress);

Datum
useless_decompress(PG_FUNCTION_ARGS)
{
	PG_RETURN_POINTER(PG_GETARG_POINTER(0));
}

Datum
useless_compress(PG_FUNCTION_ARGS)
{
	GISTENTRY  *entry = (GISTENTRY *) PG_GETARG_POINTER(0);

	PG_RETURN_POINTER(entry);
}

Datum
useless_consistent(PG_FUNCTION_ARGS)
{
	GISTENTRY  *entry = (GISTENTRY *) PG_GETARG_POINTER(0);
	int32		query = PG_GETARG_INT32(1);
	/* StrategyNumber strategy = (StrategyNumber) PG_GETARG_UINT16(2); */
	/* Oid		subtype = PG_GETARG_OID(3); */
	bool	   *recheck = (bool *) PG_GETARG_POINTER(4);

	if (GIST_LEAF(entry))
	{
		*recheck = false;
		PG_RETURN_BOOL(DatumGetInt32(entry->key) == query);
	}
	else
		PG_RETURN_BOOL(true);
}

Datum
useless_union(PG_FUNCTION_ARGS)
{
	/* GistEntryVector *entryvec = (GistEntryVector *) PG_GETARG_POINTER(0); */

	PG_RETURN_INT32(0);
}


Datum
useless_penalty(PG_FUNCTION_ARGS)
{
	/* int32		origentry = DatumGetInt32(((GISTENTRY *) PG_GETARG_POINTER(0))->key); */
	/* int32		newentry = DatumGetInt32(((GISTENTRY *) PG_GETARG_POINTER(1))->key); */
	float	   *result = (float *) PG_GETARG_POINTER(2);

	*result = fabs(drand48());

	PG_RETURN_POINTER(result);
}


Datum
useless_picksplit(PG_FUNCTION_ARGS)
{
	GistEntryVector *entryvec = (GistEntryVector *) PG_GETARG_POINTER(0);
	GIST_SPLITVEC *v = (GIST_SPLITVEC *) PG_GETARG_POINTER(1);
	OffsetNumber i,
				maxoff = entryvec->n - 1;
	int			nbytes;

	nbytes = (maxoff + 2) * sizeof(OffsetNumber);
	v->spl_left = (OffsetNumber *) palloc(nbytes);
	v->spl_right = (OffsetNumber *) palloc(nbytes);
	v->spl_ldatum = Int32GetDatum(0);
	v->spl_rdatum = Int32GetDatum(0);
	v->spl_nleft = 0;
	v->spl_nright = 0;

	for (i = FirstOffsetNumber; i <= maxoff; i = OffsetNumberNext(i))
	{
		if (v->spl_nleft < v->spl_nright)
			v->spl_left[v->spl_nleft++] = i;
		else
			v->spl_right[v->spl_nright++] = i;
	}

	PG_RETURN_POINTER(v);
}

Datum
useless_same(PG_FUNCTION_ARGS)
{
	int32		b1 = PG_GETARG_INT32(0);
	int32		b2 = PG_GETARG_INT32(1);
	bool	   *result = (bool *) PG_GETARG_POINTER(2);

	*result = (b1 == b2);
	PG_RETURN_POINTER(result);
}
