-- This program is open source, licensed under the PostgreSQL License.
-- For license terms, see the LICENSE file.

-- complain if script is sourced in psql, rather than via CREATE EXTENSION
\echo Use "CREATE EXTENSION pg_stat_autovacuum" to load this file. \quit

SET client_encoding = 'UTF8';

CREATE FUNCTION pg_stat_autovacuum(
    OUT pid integer, OUT dbid oid, OUT relid oid, OUT pos int,
    OUT working bool, OUT skipped bool, OUT finished bool, OUT cancelled bool,
    OUT tsstart timestamp with time zone, OUT tsend timestamp with time zone,
    OUT do_vacuum bool, OUT do_analyze bool, OUT do_freeze bool,
    OUT do_skiptoast bool, OUT is_wraparound bool
)
    RETURNS SETOF record
    LANGUAGE c COST 100
AS '$libdir/pg_stat_autovacuum', 'pg_stat_autovacuum';
