----------------------------------------------------
-- This script runs random selects on test tables.
--
-- Run git_demo_init.sql first to create test tables
-- used in the test.
----------------------------------------------------

CREATE OR REPLACE FUNCTION select_from_narrowtable(rounds int, maxkey int) RETURNS int AS $$
DECLARE
  x int;
  rows int;
  cnt int;
  retcnt int;
  tmp int;
BEGIN
  retcnt := 0;
  FOR cnt IN 1..$1 LOOP
    x := (random() * (maxkey-1))::int + 1;

    SELECT COUNT(*) INTO tmp FROM narrowtable WHERE key = x;
    retcnt := retcnt + tmp;
  END LOOP;
  RETURN retcnt;
END;
$$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION select_from_narrowtable2(rounds int, maxkey int) RETURNS int AS $$
DECLARE
  x int;
  rows int;
  cnt int;
  retcnt int;
  tmp int;
BEGIN
  retcnt := 0;
  FOR cnt IN 1..$1 LOOP
    x := (random() * (maxkey-1))::int + 1;

    SELECT COUNT(*) INTO tmp FROM narrowtable2 WHERE key = x;
    retcnt := retcnt + tmp;
  END LOOP;
  RETURN retcnt;
END;
$$ LANGUAGE plpgsql;

\echo Run 100000 random selects with normal index. 
\echo Repeat 3 times to ensure repeatable results.
\timing
SELECT select_from_narrowtable(100000, (SELECT MAX(key) FROM narrowtable)) AS select_with_normal_index;
SELECT select_from_narrowtable(100000, (SELECT MAX(key) FROM narrowtable)) AS select_with_normal_index;
SELECT select_from_narrowtable(100000, (SELECT MAX(key) FROM narrowtable)) AS select_with_normal_index;
\timing

-- rebuild the index as a clustered index
--ALTER INDEX narrowtable_index SET (groupthreshold=2);
--REINDEX INDEX narrowtable_index;


\echo And now run the same tests with clustered index
\timing
SELECT select_from_narrowtable2(100000, (SELECT MAX(key) FROM narrowtable2)) AS select_with_clustered_index;
SELECT select_from_narrowtable2(100000, (SELECT MAX(key) FROM narrowtable2)) AS select_with_clustered_index;
SELECT select_from_narrowtable2(100000, (SELECT MAX(key) FROM narrowtable2)) AS select_with_clustered_index;
\timing

\echo Done! Now compare the timings between the normal and clustered index runs.
