/**
 * @file debug.h
 * @brief Interface for debug dump function.
 */
#ifndef DEBUG_H_INCLUDED
#define DEBUG_H_INCLUDED

#include "access/xlog.h"
#include "access/xlog_internal.h"

/*
 * In the release, debug function call itself will be eliminated.
 */
#ifdef DEBUG

void get_segment_id(const char *filename);
void dump_page_header(int num, XLogPageHeader pheader);
void dumpXLogRecord(XLogRecPtr *ptr, size_t off, XLogRecord *record);

#else

#define get_segment_id(a)
#define dump_page_header(a, b)
#define dumpXLogRecord(a, b, c)

#endif

#endif
