/**
 * @file file.h
 * @brief Common file I/O routines for pg_archive and pg_restore.のI/F.
 */
#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED

#include "postgres.h"
#include "access/xlog.h"

int read_buff(int fd, char *buff, size_t len);
void write_buff(int fd, const char *buff, size_t len);
void copy_file(int from_fd, int to_fd);
bool is_valid_record(XLogRecord *precord);

/**
 * @brief Check if the page header in the buffer is valid.
 * @param buff Buffer to check
 */
#define IS_WAL_FILE(buff) \
	(((XLogPageHeader)(buff))->xlp_magic == XLOG_PAGE_MAGIC)

/**
 * @brief Check if the record is log switch WAL record.
 * @param rec Pointer to the record to check.
 */
#define IS_XLOG_SWITCH(rec) \
	((rec)->xl_rmid == RM_XLOG_ID && (rec)->xl_info == XLOG_SWITCH)

#endif /* !FILE_H_INCLUDED */
