
#include "postgres_fe.h"
#include "libpq-fe.h"
#include "libpq-int.h"

int
PQregisterEventProc(PGconn *conn, PGEventProc proc, void *passThrough)
{
	int i;
	PGEventRegister regevt;

	if(!proc || !conn)
		return FALSE;

	for(i=0; i < conn->nEvents; i++)
		if(conn->events[i].proc == proc)
			return FALSE; /* already registered */

	if(conn->nEvents >= conn->eventArrSize)
	{
		PGEvent *e;
		int newSize = conn->eventArrSize ? (conn->eventArrSize * 3) / 2 : 8;

		if(conn->events)
			e = (PGEvent *)realloc(conn->events,
				newSize*sizeof(PGEvent));
		else
			e = (PGEvent *)malloc(newSize*sizeof(PGEvent));

		if(!e)
			return FALSE;

		conn->eventArrSize = newSize;
		conn->events = e;
	}

	conn->events[conn->nEvents].passThrough  = passThrough;
	conn->events[conn->nEvents].data = NULL;
	conn->events[conn->nEvents].proc = proc;
	conn->nEvents++;

	regevt.conn = conn;
	if(!proc(PGEVT_REGISTER, &regevt))
	{
		conn->nEvents--;
		return FALSE;
	}

	return TRUE;
}

void *
PQinstanceData(const PGconn *conn, PGEventProc proc)
{
	int i;

	if(!conn || !proc)
		return NULL;

	for(i=0; i < conn->nEvents; i++)
		if(conn->events[i].proc == proc)
			return conn->events[i].data;

	return NULL;
}

int
PQsetInstanceData(PGconn *conn, PGEventProc proc, void *data)
{
	int i;

	if(!conn || !proc)
		return FALSE;

	for(i=0; i < conn->nEvents; i++)
	{
		if(conn->events[i].proc == proc)
		{
			conn->events[i].data = data;
			return TRUE;
		}
	}

	return FALSE;
}

void *
PQresultInstanceData(const PGresult *result, PGEventProc proc)
{
	int i;

	if(!result || !proc)
		return NULL;

	for(i=0; i < result->nEvents; i++)
		if(result->events[i].proc == proc)
			return result->events[i].data;

	return NULL;
}

int
PQresultSetInstanceData(PGresult *result, PGEventProc proc, void *data)
{
	int i;

	if(!result || !proc)
		return FALSE;

	for(i=0; i < result->nEvents; i++)
	{
		if(result->events[i].proc == proc)
		{
			result->events[i].data = data;
			return TRUE;
		}
	}

	return FALSE;
}

void *
PQpassThroughData(const PGconn *conn, PGEventProc proc)
{
	int i;

	if(!conn || !proc)
		return NULL;

	for(i=0; i < conn->nEvents; i++)
		if(conn->events[i].proc == proc)
			return conn->events[i].passThrough;

	return NULL;
}

void *
PQresultPassThroughData(const PGresult *result, PGEventProc proc)
{
	int i;

	if(!result || !proc)
		return NULL;

	for(i=0; i < result->nEvents; i++)
		if(result->events[i].proc == proc)
			return result->events[i].passThrough;

	return NULL;
}

