
#ifndef PGCALLBACK_H
#define PGCALLBACK_H

#include <libpq-fe.h>

/* Callback Event Ids */
typedef enum
{
	PGEVT_REGISTER,
	PGEVT_CONNRESET,
	PGEVT_CONNDESTROY,
	PGEVT_RESULTCREATE,
	PGEVT_RESULTCOPY,
	PGEVT_RESULTDESTROY
} PGEventId;

typedef struct
{
	const PGconn *conn;
} PGEventRegister;

typedef struct
{
	const PGconn *conn;
} PGEventConnReset;

typedef struct
{
	const PGconn *conn;
} PGEventConnDestroy;

typedef struct
{
	const PGconn *conn;
	const PGresult *result;
} PGEventResultCreate;

typedef struct
{
	const PGresult *src;
	PGresult *dest;
} PGEventResultCopy;

typedef struct
{
	const PGresult *result;
} PGEventResultDestroy;

typedef int (*PGEventProc)(PGEventId evtId, void *evtInfo);

/*
 * Registers an event proc with the given PGconn.  The passThrough argument
 * is an application specific pointer and can be set to NULL if not
 * required.  The passThrough argument can be retrieved via
 * PQpassThroughData and PQresultPassThroughData.
 *
 * The function returns a non-zero if successful.  If the function
 * fails, zero is returned.
 */
extern int
PQregisterEventProc(PGconn *conn, PGEventProc proc, void *passThrough);

/* Gets the PGconn instance data for the provided proc. */
extern void *
PQinstanceData(const PGconn *conn, PGEventProc proc);

/* Sets the PGconn instance data for the provided proc to data.
 * Returns non-zero for success and zero for failure.
 */
extern int
PQsetInstanceData(PGconn *conn, PGEventProc proc, void *data);

/* Gets the PGresult instance data for the provided proc. */
extern void *
PQresultInstanceData(const PGresult *res, PGEventProc proc);

/* Sets the PGresult instance data for the provided proc to data.
 * Returns non-zero for success and zero for failure.
 */
extern int
PQresultSetInstanceData(PGresult *result, PGEventProc proc, void *data);

/* Gets the PGconn passThrough data for the provided proc. */
extern void *
PQpassThroughData(const PGconn *conn, PGEventProc proc);

/* Gets the PGresult passThrough data for the provided proc. */
extern void *
PQresultPassThroughData(const PGresult *result, PGEventProc proc);

#endif

