!***********************************************************************
!  newbinding.f90
!
!  Copyright (C) 2005-2015  Arjen Markus
!  Copyright (C) 2006-2015 Alan W. Irwin
!
!  This file is part of PLplot.
!
!  PLplot is free software; you can redistribute it and/or modify
!  it under the terms of the GNU Library General Public License as published
!  by the Free Software Foundation; either version 2 of the License, or
!  (at your option) any later version.
!
!  PLplot is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU Library General Public License for more details.
!
!  You should have received a copy of the GNU Library General Public License
!  along with PLplot; if not, write to the Free Software
!  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
!
!
!  This file is a limited version of what should become the new style
!  Fortran bindings. It is geared to example x00f only.
!
!***********************************************************************

module plplot_types
    include 'plplot_interface_private_types.inc'
end module plplot_types

module plplot_single
    use, intrinsic :: iso_c_binding
    use plplot_types, wp => private_single

    private :: wp, private_single, private_double, private_plint, private_plunicode

    include 'plplot_interfaces.inc'
end module plplot_single

module plplot_double
    use, intrinsic :: iso_c_binding
    use plplot_types, wp => private_double

    private :: wp, private_single, private_double, private_plint, private_plunicode

    include 'plplot_interfaces.inc'

end module plplot_double

module plplot
    use plplot_single
    use plplot_double
    use plplot_types, only: plflt => private_plflt, private_plint, private_plunicode

    include 'plplot_parameters.inc'
    private :: private_plint, private_plunicode
!
! Interfaces that do not depend on the real kind
!

    interface
        subroutine plend() bind( c, name = 'c_plend' )
        end subroutine plend
    end interface

    interface
        subroutine plinit() bind( c, name = 'c_plinit' )
        end subroutine plinit
    end interface
contains

subroutine pllab( xlab, ylab, title )
   character(len=*) :: xlab, ylab, title

   interface
       subroutine c_pllab( xlab, ylab, title ) bind(c,name='c_pllab')
           implicit none
           character(len=1), dimension(*) :: xlab, ylab, title
       end subroutine c_pllab
   end interface

   call c_pllab( trim(xlab) // c_null_char, trim(ylab) // c_null_char, trim(title) // c_null_char )

end subroutine pllab

include 'plparseopts.f90'
end module plplot
