! Specify private Fortran types used by the f95 bindings.
! This file is automatically configured by CMake
!
! These private types are used along with function overloading so
! that new applications do not need specific types at all (under the
! constraint that all real arguments for the f95 binding must have a
! consistent type for a particular call to a routine.)

! Configured by CMake depending on the floating-point precision
! adopted for the core C PLplot library.
integer,  parameter :: private_plflt  = kind(1.0d0)

! The idea here is to match the Fortran 4-byte integer with
! the corresponding C types for PLINT (normally int32_t) and
! PLUNICODE (normally uint32_t).  According to websites I have
! read, Fortran has no unsigned integer types and
! using 4 here is safer than anything more complicated.
integer,  parameter :: private_plint  = 4
integer,  parameter :: private_plunicode  = 4

! Define parameters for identifying the precision, so that we can
! specify equivalent interfaces for all precisions (kinds)
integer,  parameter :: private_single  = 4
integer,  parameter :: private_double  = 8
