!***********************************************************************
!  plplot_interfaces.inc
!
!  Copyright (C) 2005-2015  Arjen Markus
!  Copyright (C) 2006-2015 Alan W. Irwin
!
!  This file is part of PLplot.
!
!  PLplot is free software; you can redistribute it and/or modify
!  it under the terms of the GNU Library General Public License as published
!  by the Free Software Foundation; either version 2 of the License, or
!  (at your option) any later version.
!
!  PLplot is distributed in the hope that it will be useful,
!  but WITHOUT ANY WARRANTY; without even the implied warranty of
!  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!  GNU Library General Public License for more details.
!
!  You should have received a copy of the GNU Library General Public License
!  along with PLplot; if not, write to the Free Software
!  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
!
!
!  This file defines the Fortran interfaces for the PLplot library.
!  Limited to example x00f!
!
!***********************************************************************

    interface plenv
        !
        ! We can not use this binding via iso_c_binding directly, as the interface would
        ! conflict with plenv_single/plenv_double which would force us to leave
        ! out one of the two, depending on the selected precision. So use an interface block
        ! locally to define the exact interface without aliasing the name. (See the implementation
        ! of plenv_single/plenv_double)
        !
        !subroutine c_plenv( xmin, xmax, ymin, ymax, just, axis ) bind(c, name='c_plenv')
        !    use iso_c_binding
        !    include 'plplot_interface_private_types.inc'
        !    implicit none
        !    real(kind=private_plflt), value :: xmin, xmax, ymin, ymax
        !    integer(kind=private_plint), value :: just, axis
        !end subroutine c_plenv

        module procedure plenv_impl
    end interface plenv

    private :: plenv_impl

    interface plline
        module procedure plline_impl
    end interface plline

    private :: plline_impl


contains

subroutine plenv_impl( xmin, xmax, ymin, ymax, just, axis )
    real(kind=wp) :: xmin, xmax, ymin, ymax
    integer :: just, axis

    interface
        subroutine c_plenv( xmin, xmax, ymin, ymax, just, axis ) bind(c, name='c_plenv')
            implicit none
            include 'plplot_interface_private_types.inc'
            real(kind=private_plflt), value :: xmin, xmax, ymin, ymax
            integer(kind=private_plint), value :: just, axis
        end subroutine c_plenv
    end interface

    call c_plenv( real(xmin,private_plflt), real(xmax,private_plflt), real(ymin,private_plflt), real(ymax,private_plflt), &
                  int(just,private_plint), int(axis,private_plint) )
end subroutine plenv_impl

subroutine plline_impl( x, y )
   real(kind=wp), dimension(:) :: x, y

   interface
       subroutine c_plline( sz, x, y ) bind(c,name='c_plline')
           implicit none
           include 'plplot_interface_private_types.inc'
           integer(kind=private_plint), value     :: sz
           real(kind=private_plflt), dimension(*) :: x, y
       end subroutine c_plline
   end interface

   call c_plline( size(x,kind=private_plint), real(x,kind=private_plflt), real(y,kind=private_plflt) )

end subroutine plline_impl

