!   Simple demo of a 2D line plot.
!
!   Copyright (C) 2011  Alan W. Irwin
!
!   This file is part of PLplot.
!
!   PLplot is free software; you can redistribute it and/or modify
!   it under the terms of the GNU Library General Public License as published
!   by the Free Software Foundation; either version 2 of the License, or
!   (at your option) any later version.
!
!   PLplot is distributed in the hope that it will be useful,
!   but WITHOUT ANY WARRANTY; without even the implied warranty of
!   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
!   GNU Library General Public License for more details.
!
!   You should have received a copy of the GNU Library General Public License
!   along with PLplot; if not, write to the Free Software
!   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

program x00f95
    !use plf95demolib
    use plplot

    integer, parameter :: NSIZE = 101

    integer, parameter :: wp = kind(1.0)
    real(kind=wp), dimension(NSIZE) :: x, y

    real(kind=wp) :: xmin = 0.0, xmax = 1.0, ymin = 0.0, ymax = 100.0
    ! integer          :: i

    ! Prepare data to be plotted.
    x = arange(0, NSIZE) / real(NSIZE-1)
    y = ymax * x**2

    ! Parse and process command line arguments
    call plparseopts( PL_PARSE_FULL )

    ! Initialize plplot
    call plinit

    ! Create a labelled box to hold the plot.
    call plenv( xmin, xmax, ymin, ymax, 0, 0 )
    call pllab( "x", "y=100 x#u2#d", "Simple PLplot demo of a 2D line plot" )

    ! Plot the data that was prepared above.
    call plline( x, y )

    ! Close PLplot library
    call plend

contains
function arange( start, stop )
    integer, intent(in) :: start, stop

    real(kind=wp), dimension(stop-start) :: arange

    integer             :: i

    arange = (/ (real(i), i = start, stop-1) /)
end function arange

end program x00f95
