
qx.Class.define("tc.SplashScreen", { extend : qx.core.Object
    ,properties : {
         widget : { check: "Object" }
    }
    ,construct : function (main_container, next_screen) {
        this.base(arguments);
        var ctx=this;
        var __cnt_h = new qx.ui.container.Composite(new qx.ui.layout.HBox(0));
        this.setWidget(__cnt_h);
        this.__main_container = main_container;
        this.__next_screen = next_screen;

        this.MainWindow = new qx.ui.container.Composite();

        this.__cnt_v = new qx.ui.layout.VBox();
        this.MainWindow.set({
             alignY: "middle"
            ,allowGrowY: false
        });
        __cnt_h.add(this.MainWindow, {flex:1});
        this.MainWindow.setLayout(this.__cnt_v);

        this.centralwidget = new qx.ui.container.Composite();
        this.centralwidget.setAlignX("center");
        this.centralwidget.set({maxWidth: 250});

        this.verticalLayout = new qx.ui.layout.VBox();
        this.centralwidget.setLayout(this.verticalLayout);

        this.btn_login = new qx.ui.form.Button();
        this.btn_login.setLabel("Click");
        this.btn_login.addListener("execute", this.on_btn_click, ctx);
        this.btn_login.setAlignX("center");
        this.btn_login.setMaxWidth(80);
        this.btn_login.setMarginTop(10);

            /*
             * menu
             */
            var menu = new tc.Menu();

            var undoButton = new qx.ui.menu.Button("Undo", "icon/16/actions/edit-undo.png");
            var redoButton = new qx.ui.menu.Button("Redo", "icon/16/actions/edit-redo.png");

            var cutButton = new qx.ui.menu.Button("Cut", "icon/16/actions/edit-cut.png");
            var copyButton = new qx.ui.menu.Button("Copy", "icon/16/actions/edit-copy.png");
            var pasteButton = new qx.ui.menu.Button("Paste", "icon/16/actions/edit-paste.png");

            var printButton = new qx.ui.menu.Button("Print", "icon/16/actions/document-print.png");

            // add buttons to menu
            menu.add(undoButton);
            menu.add(redoButton);

            menu.addSeparator();

            menu.add(cutButton);
            menu.add(copyButton);
            menu.add(pasteButton);

            menu.addSeparator();
            menu.addSeparator();

            menu.add(printButton);

            var button = new qx.ui.form.MenuButton("menu...", "icon/22/apps/preferences-users.png", menu);

        this.centralwidget.add(button);
        this.centralwidget.add(this.btn_login);
        this.MainWindow.add(this.centralwidget);
    }

    ,members : {
         MainWindow : null
        ,centralwidget : null
        ,verticalLayout : null
        ,btn_login : null
        ,__main_container : null

        ,on_btn_click: function(e) {
            var cnt_main = this.__main_container;
            cnt_main.removeAll();
            var next_screen = new this.__next_screen();
            cnt_main.add( next_screen.getWidget(), {edge:0} );
        }
    }
});

