from rdkit import Chem
from rdkit.Chem import rdFMCS
from rdkit.Chem import AllChem

moli = Chem.MolFromMol2File('moli.mol2')
molj = Chem.MolFromMol2File('molj.mol2')

moli_noh = AllChem.RemoveHs(moli)
molj_noh = AllChem.RemoveHs(molj)

# MCS pattern calculation
mcs = rdFMCS.FindMCS([moli_noh, molj_noh],
                     timeout=20, 
                     atomCompare=rdFMCS.AtomCompare.CompareAny, 
                     bondCompare=rdFMCS.BondCompare.CompareAny, 
                     matchValences=False, 
                     ringMatchesRingOnly=True, 
                     completeRingsOnly=False, 
                     matchChiralTag=False)


mcs_mol = Chem.MolFromSmarts(mcs.smartsString)

print moli_noh.GetSubstructMatch(mcs_mol)
print molj_noh.GetSubstructMatch(mcs_mol)




