function preprocess () {
	echo ('bind.tables <- function (row.vars=NULL, col.vars=NULL, ...) {\n');
	echo ('	tables <- list (...)\n');
	echo ('	output <- unlist (tables)\n');
	echo ('	dim (output) <- c (dim (tables[[1]]), length (tables))\n');
	echo ('	dimnames (output) <- c (dimnames (tables[[1]]), list (statistic=names(tables)))\n');
	echo ('	if (is.null(col.vars))\n');
	echo ('	\tcol.vars <- length(dim(tables[[1]]))\n');
	echo ('	ftable (output, row.vars=row.vars, col.vars=col.vars)\n');
	echo ('}\n');
	echo ('\n');
}

function calculate () {
	var x = getValue ("x") ;
	var y = "substitute (" + trim (getValue ("y")).replace (/\n/g, "), substitute (") + ")";

	echo ('x <- ' + x + "\n");
	echo ('yvars <- list (' + y + ')\n');
	echo ('results <- list()\n');
	echo ('descriptions <- list ()\n');
	echo ('\n');
	echo ('# calculate crosstabs\n');
	echo ('for (i in 1:length (yvars)) {\n');
	echo ('	descriptions[[i]] <- list (\'Dependent\'=rk.get.description (' + x + '), \'Independent\'=rk.get.description (yvars[[i]], is.substitute=TRUE))\n');
	echo ('	yvar <- eval (yvars[[i]], envir=globalenv ())\n');
	echo ('	results[[i]] <- xtabs(~ x + yvar)\n');
	echo ('	names(dimnames(results[[i]])) <- c(descriptions[[i]][[\'Dependent\']], descriptions[[i]][[\'Independent\']])\n');
	echo ('}\n');
	if (getValue ("chisq") == "TRUE") {
		echo ('\n');
		echo ('# calculate chisquares\n');
		echo ('chisquares <- list ()\n');
		echo ('for (i in 1:length (results)) {\n');
		echo ('	chisquares[[i]] <- chisq.test (results[[i]], simulate.p.value = ' + getValue ("simpv"));
		if (getValue ("simpv") == "TRUE") {
			echo (',B=(');
			echo (getValue ("B"));
			echo (') ');
		}
		echo (')\n');
		echo ('}\n');
	}
	echo ('\n');

	echo ('# Calculate the cells of table\n');
	echo ('tables <- results\n');
        echo ('tables.row <- list()\n');
	echo ('tables.column <- list()\n');
	echo ('tables.total <- list()\n');
	echo ('output <- list()\n');
	echo ('for (i in 1:length(tables)) {\n');
	if (getValue("row") == "TRUE")
		echo ('	tables.row[[i]] <- prop.table(tables[[i]], 1) * 100\n');
	if (getValue("column") == "TRUE")
		echo ('	tables.column[[i]] <- prop.table(tables[[i]], 2) * 100\n');
	if (getValue("total") == "TRUE")
		echo ('	tables.total[[i]] <- prop.table(tables[[i]]) * 100\n');
	echo ('\n');

	if (getValue("margins") == "TRUE") {
		echo ('tables[[i]] <- addmargins(tables[[i]])\n');
		if (getValue("row") == "TRUE")
			echo('	tables.row[[i]] <- addmargins(tables.row[[i]])\n');
		if (getValue("column") == "TRUE")
			echo('	tables.column[[i]] <- addmargins(tables.column[[i]])\n');
		if (getValue("total") == "TRUE")
			echo('	tables.total[[i]] <- addmargins(tables.total[[i]])\n');
		if (getValue("chisq") == "TRUE")
			echo ('	chisquares[[i]]$expected <- addmargins(chisquares[[i]]$expected)\n');
		echo ('\n');
	}

	if (getValue("round") == "TRUE") {
		if (getValue("row") == "TRUE")
			echo ('	tables.row[[i]] <- round(tables.row[[i]], ' + getValue("decimals") + ')\n');
		if (getValue("column") == "TRUE")
			echo ('	tables.column[[i]] <- round(tables.column[[i]], ' + getValue("decimals") + ')\n');
		if (getValue("total") == "TRUE")
			echo ('	tables.column[[i]] <- round(tables.column[[i]], ' + getValue("decimals") + ')\n');
		if (getValue("chisq") == "TRUE")
			echo ('	chisquares[[i]]$expected <- round(chisquares[[i]]$expected, ' + getValue("decimals") + ')\n');
		echo ('\n');
	}

	echo ('	output[[i]] <- bind.tables("counts" = tables[[i]]');
	if (getValue("row") == "TRUE")
		echo (', "% of row" = tables.row[[i]]');
	if (getValue("column") == "TRUE")
		echo (', "% of column" = tables.column[[i]]');
	if (getValue("total") == "TRUE")
		echo (', "% of total" = tables.total[[i]]');
	if (getValue("chisq") == "TRUE")
		echo (', "expected" = chisquares[[i]]$expected');
	echo (')\n');
	echo ('}\n');
	echo ('\n');
}

function printout () {
	doPrintout (true);
}

function preview () {
	calculate ();
	doPrintout (false);
}

function doPrintout (full) {
	if (full) {
		echo ('rk.header ("Crosstabs (n to 1)", level=1)\n');
		echo ('for (i in 1:length (results)) {\n');
		echo ('	rk.header ("Crosstabs (n to 1)", parameters=list ("Dependent", descriptions[[i]][[\'Dependent\']], "Independent", descriptions[[i]][[\'Independent\']]), level=2)\n');
		echo ('	rk.print(output[[i]])');
		if (getValue ("chisq") == "TRUE") {
			echo ('\n');
			echo ('	rk.header ("Pearson\'s Chi Square Test for Crosstabs", list ("Dependent", descriptions[[i]][[\'Dependent\']], "Independent", descriptions[[i]][[\'Independent\']], "Method", chisquares[[i]][["method"]]), level=2)\n');
			echo ('	chisq.show <- as.list(chisquares[[i]][1:3])\n');
			echo ('	names(chisq.show) <- c(names(chisq.show[[1]]), names(chisq.show[[2]]), names(chisq.show)[3])\n');
			echo ('	rk.results (chisq.show)\n');
		}

		if (getValue ("barplot") == "TRUE") {
			echo ('\n');
			echo ('	rk.header ("Barplot for Crosstabs", list ("Dependent", descriptions[[i]][[\'Dependent\']], "Independent", descriptions[[i]][[\'Independent\']]' + getValue ('barplot_embed.code.preprocess') + '), level=2)\n');
			echo ('	rk.graph.on ()\n');
			echo ('	try ({\n');
			printIndented ("\t\t", getValue ('barplot_embed.code.printout'));
			echo ('	})\n');
			echo ('	rk.graph.off ()\n');
		}
		echo ('}\n');
	} else {
		// produce a single barplot of the first result
		echo ("i <- 1\n");
		echo (getValue ('barplot_embed.code.printout'));
	}

}

