#ifndef _941e9637_242c_405b_826e_019ba5bcc305_
#define _941e9637_242c_405b_826e_019ba5bcc305_

#include <locale>
#include <iterator>

namespace soci { namespace utf { namespace  impl {

	// statically deduce value type from iterator type
	template<typename _TOutIt>
	struct _SIterator2Value
	{ typedef typename std::iterator_traits<_TOutIt>::value_type value_type; };

	// partial specializations for inserters:
	// RATIONALE: cannot use directly 'iterator_traits' because for inserters it returns 'void' type
	template<typename _TCont> struct _SIterator2Value<std::back_insert_iterator<_TCont> >
	{ typedef typename _TCont::value_type value_type; };
	template<typename _TCont> struct _SIterator2Value<std::front_insert_iterator<_TCont> >
	{ typedef typename _TCont::value_type value_type; };
	template<typename _TCont> struct _SIterator2Value<std::insert_iterator<_TCont> >
	{ typedef typename _TCont::value_type value_type; };

	// brutal cast ignores signed/unsigned feature, simply casts number as bit sequence
	// RATIONALE: [char -1] must become [unsigned long 0xFF], not 0xFFFFFFFF !
	template<typename _TTo, typename _TFrom>
	bool brutal_cast(_TFrom from, _TTo& to)
	{
		enum { _szMin = (sizeof(_TFrom) < sizeof(_TTo)) ? sizeof(_TFrom) : sizeof(_TTo), };
		to = 0;
		for (size_t i=0; i<_szMin; ++i) {
			to |= ((from >> i*8) & 0xFF) << i*8;
			from &= ~(0xFF << i*8);
		}
		return !from;
	}

	// returns enum from std::codecvt_base
	template<typename _TItUTF_from, typename _TValueUNICODE>
	int _utf8_to_unicode_eat_one(_TItUTF_from& itB, const _TItUTF_from itE, bool isBreakOnZero, _TValueUNICODE& valueUnicode, bool& isFinished)
	{
		_TItUTF_from it = itB;
		if (isBreakOnZero) {
			if (!*it) { isFinished = true; return std::codecvt_base::ok; }
		} else {
			if (it == itE) { isFinished = true; return std::codecvt_base::ok; }
		}
		isFinished = false;

		unsigned long targetSymbolUNICODE = 0;
		const unsigned char c0 = *(it++);
		if (!(c0 & 0x80)) { // 0xxxxxxx
			targetSymbolUNICODE = c0;
		} else if ((c0 & 0xE0) == 0xC0) { // 110xxxxx 10xxxxxx
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			unsigned char c1 = *(it++);
			if ((c1 & 0xC0) != 0x80) { return std::codecvt_base::error; }
			targetSymbolUNICODE = ((c0 & 0x1F) << 6) | (c1 & 0x3F);
		} else if ((c0 & 0xF0) == 0xE0) { // 1110xxxx 10xxxxxx 10xxxxxx
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			unsigned char c1 = *(it++);
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			unsigned char c2 = *(it++);
			if ((c1 & 0xC0) != 0x80) { return std::codecvt_base::error; }
			if ((c2 & 0xC0) != 0x80) { return std::codecvt_base::error; }
			targetSymbolUNICODE = ((c0 & 0x0F) << 12) | ((c1 & 0x3F) << 6) | (c2 & 0x3F);
		} else if ((c0 & 0xF8) == 0xF0) { // 11110xxx 10xxxxxx 10xxxxxx 10xxxxxx
			++it;
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			unsigned char c1 = *(it++);
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			unsigned char c2 = *(it++);
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			unsigned char c3 = *(it++);

			if ((c1 & 0xC0) != 0x80) { return std::codecvt_base::error; }
			if ((c2 & 0xC0) != 0x80) { return std::codecvt_base::error; }
			if ((c3 & 0xC0) != 0x80) { return std::codecvt_base::error; }
			targetSymbolUNICODE = ((c0 & 0x07) << 18) | ((c1 & 0x3F) << 12) | ((c2 & 0x3F) << 6) | (c3 & 0x3F);
		} else {
			return std::codecvt_base::error;
		}
		
		if (!brutal_cast(targetSymbolUNICODE, valueUnicode)) {
			return std::codecvt_base::error;
		}
		itB = it;
		return std::codecvt_base::ok;
	}

	// returns enum from std::codecvt_base
	template<typename _TItUTF_from, typename _TValueUNICODE>
	int _utf16_to_unicode_eat_one(_TItUTF_from& itB, const _TItUTF_from itE, bool isBreakOnZero, _TValueUNICODE& valueUnicode, bool& isFinished)
	{
		_TItUTF_from it = itB;
		if (isBreakOnZero) {
			if (!*it) { isFinished = true; return std::codecvt_base::ok; }
		} else {
			if (it == itE) { isFinished = true; return std::codecvt_base::ok; }
		}
		isFinished = false;

		// borrowed from http://tools.ietf.org/html/rfc2781
		unsigned long targetSymbolUNICODE = 0;
		const unsigned short c0 = *(it++);
		unsigned short c1 = 0;
		if (c0 < 0xD800 || c0 >= 0xE000) { // 0xxxxxxx
			targetSymbolUNICODE = c0;
		} else if (c0 >= 0xD800 && c0 < 0xDC00) {
			if (isBreakOnZero ? !*it : (it == itE)) { return std::codecvt_base::partial; }
			c1 = *(it++);
			if (c1 < 0xDC00 || c1 >= 0xE000) {
				return std::codecvt_base::error;
			}
			targetSymbolUNICODE = ((c0 & 0x03FF) << 10) | (c1 & 0x03FF) | 0x10000;
		} else {
			return std::codecvt_base::error;
		}

		if (!brutal_cast(targetSymbolUNICODE, valueUnicode)) {
			return std::codecvt_base::error;
		}
		itB = it;
		return std::codecvt_base::ok;
	}

	template<typename _TValueUnicode, typename _TItUTF_from, typename _TItUNICODE_to>
	bool utf8_to_unicode_as(const _TItUTF_from itB, const _TItUTF_from itE, _TItUNICODE_to itTarget, _TItUNICODE_to* itTargetEnd)
	{
		_TValueUnicode valueUnicode;

		bool isFinished = false;
		int ret = 0;
		
		_TItUTF_from it = itB;
		while (
			(ret = impl::_utf8_to_unicode_eat_one(it, itE, false, valueUnicode, isFinished)) == std::codecvt_base::ok
			&&
			!isFinished)
		{
			*(itTarget++) = valueUnicode;
		}
		if (itTargetEnd) {
			*itTargetEnd = itTarget;
		}
		return ret == std::codecvt_base::ok;
	}

	template<typename _TValueUnicode, typename _TItUTF_from, typename _TItUNICODE_to>
	bool utf16_to_unicode_as(const _TItUTF_from itB, const _TItUTF_from itE, _TItUNICODE_to itTarget, _TItUNICODE_to* itTargetEnd)
	{
		_TValueUnicode valueUnicode;

		bool isFinished = false;
		int ret = 0;
		
		_TItUTF_from it = itB;
		while (
			(ret = impl::_utf16_to_unicode_eat_one(it, itE, false, valueUnicode, isFinished)) == std::codecvt_base::ok
			&&
			!isFinished)
		{
			*(itTarget++) = valueUnicode;
		}
		if (itTargetEnd) {
			*itTargetEnd = itTarget;
		}
		return ret == std::codecvt_base::ok;
	}

	template<typename _TValueTarget, typename _TItUNICODE_to>
	bool utf8_to_unicode_as(const char* str, _TItUNICODE_to itTarget, _TItUNICODE_to* itTargetEnd)
	{
		bool isFinished = false;
		_TValueTarget valueUnicode;
		int ret = 0;

		while (
			(ret = impl::_utf8_to_unicode_eat_one(str, (const char*)0, true, valueUnicode, isFinished)) == std::codecvt_base::ok
			&&
			!isFinished)
		{
			*(itTarget++) = valueUnicode;
		}
		if (itTargetEnd) {
			*itTargetEnd = itTarget;
		}
		return ret == std::codecvt_base::ok;
	}

	inline void _ThrowNotConvertibleToUTF(unsigned long unicode, const char* whatUTF)
	{
		std::stringstream ss;
		ss << "unicode symbol code 0x"
			<< std::setw(8) << std::uppercase << std::hex << std::setfill('0') << unicode
			<< " is not convertible to " << whatUTF;
		throw std::runtime_error(ss.str());
	}

	template<typename _TItUTF_to>
	_TItUTF_to _utf8_from_unicode_eat_one(unsigned long unicode, _TItUTF_to itTarget)
	{
		typedef unsigned char _TValueTo;
		if ((unicode & 0x7F) == unicode) {
			// ASCII
			*(itTarget++) = static_cast<_TValueTo>(unicode);
		} else if ((unicode & 0x7FF) == unicode) {
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 6) & 0x1F) | 0xC0);
			*(itTarget++) = static_cast<_TValueTo>(((unicode     ) & 0x3F) | 0x80);
		} else if ((unicode & 0xFFFF) == unicode) {
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 12) & 0x0F) | 0xE0);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >>  6) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode      ) & 0x3F) | 0x80);
		} else if ((unicode & 0x1FFFFF) == unicode) {
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 18) & 0x07) | 0xF0);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 12) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >>  6) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode      ) & 0x3F) | 0x80);
		} else if ((unicode & 0x3FFFFFF) == unicode) {
			// theoretically possible, but so far (2011) not used by UNICODE consortium
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 24) & 0x03) | 0xF8);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 18) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 12) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >>  6) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode      ) & 0x3F) | 0x80);
		} else if ((unicode & 0x7FFFFFF) == unicode) {
			// theoretically possible, but so far (2011) not used by UNICODE consortium
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 30) & 0x01) | 0xFC);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 24) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 18) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >> 12) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode >>  6) & 0x3F) | 0x80);
			*(itTarget++) = static_cast<_TValueTo>(((unicode      ) & 0x3F) | 0x80);
		} else {
			_ThrowNotConvertibleToUTF(unicode, "UTF-8");
		}
		return itTarget;
	}

	template<typename _TItUTF_to>
	_TItUTF_to _utf16_from_unicode_eat_one(unsigned long unicode, _TItUTF_to itTarget)
	{
		typedef unsigned short _TValueTo;
		bool isError = false;
		if (unicode < 0x10000) {
			if (unicode >= 0xD800 && unicode < 0xE000) {
				isError = true;
			} else {
				*(itTarget++) = static_cast<_TValueTo>(unicode);
			}
		} else if (unicode <= 0x10FFFF) {
			unicode -= 0x10000;
			if (unicode <= 0xFFFFF) {
				unsigned short c0 = 0xD800;
				unsigned short c1 = 0xDC00;
				c0 |= (unicode >> 10) & 0x03FF;
				c1 |= (unicode & 0x03FF);
				*(itTarget++) = static_cast<_TValueTo>(c0);
				*(itTarget++) = static_cast<_TValueTo>(c1);
			} else {
				isError = true;
			}
		} else {
			isError = true;
		}
		if (isError) {
			_ThrowNotConvertibleToUTF(unicode, "UTF-16");
		}
		return itTarget;
	}

}}}

#endif // _QWETWTEGHERHEYJRHEHJT23465AD55_2392_4c8e_8C7E_833A0EB5DC55_
