#!/usr/bin/env perl

# Parses http://www.adobe.com/products/acrobat/js/readstep2_servefile.js
# and extracts the WinXP stuff

use strict;
use warnings;

use constant url => "http://www.adobe.com/products/acrobat/js/readstep2_servefile.js";

my $fileinfo;
if(@ARGV) {
	$fileinfo = join('', <>);
} else {
	require LWP;
	require LWP::UserAgent;

	my $ua = LWP::UserAgent->new;
	#$ua->agent("lwp/0.1 ");
	$ua->timeout(10);
	$ua->env_proxy;

	my $res = $ua->get(+url);
	unless($res->is_success) {
		print STDERR "Provide the readstep2_servefile.js on command line
Failed downloading from: " . url . "
Reason: " . $res->status_line . "
Maybe you need to set the http_proxy environment variable?\n";
		exit 3;
	}

	$fileinfo = $res->decoded_content
                || $res->content;

}

my $platform = '';
my $order = '';
my $fnam = '';
my $lang = '';
my $vers = '';
my $major = '';

print <<EOF;
:: OPTIONAL: Install Adobe Reader
\@Echo off

:: Download any available version, be it v7 or v6
EOF

for (split(/\n+/, $fileinfo)) {
	if(/form\.platform\.value\.indexOf\("([a-zA-Z]+)"\) >= 0/) {
		$platform = lc($1);
		$order = $major = $vers = $lang = '';
	} elsif(/form\.order\.value\.indexOf\("(\d+)"\) == 0/) {
		$order = $1;
	} elsif(/sf\.READERFILE = "([^"]+)"/) {
		$fnam = $1;
		if($fnam =~ m!/((\d)[\d\.]+)/([a-zA-Z]{3})/!) {
			$major = $2;
			$vers = $1;
			$lang = lc($3);
		}

		if($platform eq 'winxp' && $order == 1
		 && $fnam !~ /_distrib/
		 && $fnam =~ /\.exe$/
		 && $fnam !~ /_DLM_/
		) {
			print ":: URL|"
			 , uc($lang)
			 , "|$fnam|packages/adobereader/adberdr${major}_${lang}.exe\n";
		}
	}
}


print <<EOF;
if not exist %Z%\\packages\\adobereader\\adberdr7_%WINLANG%.exe goto no_v7

: also see: http://wiki.altiris.com/index.php/Adobe_Acrobat_Reader

:: Stupid Adobe installer does not wait for msiexec to finish.  So we
:: extract everything to a temporary folder, install by hand, and
:: delete the temporary folder.
todo.pl "rmdir /s /q \\"%TEMP%\\adberdr\\""
todo.pl "for %%m in (\\"%TEMP%\\adberdr\\Adobe Reader 7.0*.msi\\") do msiexec /qb /l* %SystemDrive%\\netinst\\logs\\adobe-reader.txt /i \\"%%m\\" REBOOT=ReallySuppress"
todo.pl ".ignore-err 131 %Z%\\packages\\adobereader\\adberdr7_%WINLANG%.exe /S -nos_ne -nos_o\\"%TEMP%\\adberdr\\""
goto done

:no_v7
if not exist %Z%\\packages\\adobereader\\adberdr6_%WINLANG%.exe goto no_v6

ECHO Somebody ought to add the installation for Adobe Reader v6!
pause

:no_v6
:done
EOF

