

// C++.
#include <cstdlib>

// WX.
// For compilers that support precompilation, includes <wx/wx.h>.
#include <wx/wxprec.h>
#if defined(__BORLANDC__)
#pragma hdrstop
#endif
// For all other compilers, include the necessary headers.
#if !defined(WX_PRECOMP)
#   include <wx/string.h>
#   include <wx/log.h>
#   include <wx/intl.h>
#endif

// wxluatest
#include "WxLuaErrorEventHandler.h"

// Declare the wxLua binding initialization functions as extern
// so we don't have to #include the binding header for simplicity.
extern bool wxLuaBinding_wx_init();
extern bool wxLuaBinding_wxluanstest_init();


int main(int argC, char** argV)
{

#ifdef __WXGTK__
    // this call is very important since otherwise scripts using the decimal
    // point '.' could not work with those locales which use a different symbol
    // (e.g. the comma) for the decimal point...
    // It doesn't work to put os.setlocale('c', 'numeric') in the Lua file that
    // you want to use decimal points in. That's because the file has been lexed
    // and compiler before the locale has changed, so the lexer - the part that
    // recognises numbers - will use the old locale.
    setlocale(LC_NUMERIC, "C");
#endif

    // Initialize wxLua by first attaching the bindings we want to use
    //   note: make sure you link to the binding libraries
    if (wxLuaBinding_wx_init() == true)
    {
        wxLogMessage(wxT("wxLuaBinding initialised OK."));
    }
    else
    {
        wxLogMessage(wxT("wxLuaBinding could not be initialised, quitting"));
        return EXIT_FAILURE;
    }

    // Initialize wxluatest bindings.
    if (wxLuaBinding_wxluanstest_init() == true)
    {
        wxLogMessage(wxT("wxluanstest binding initialised OK."));
    }
    else
    {
        wxLogFatalError(
                wxT("wxluanstest binding could not be initialised, quitting"));
        return EXIT_FAILURE;
    }


    // Create the error handler.
    WxLuaErrorEventHandler* p_wxLuaErrorHandler =
            new WxLuaErrorEventHandler();

    wxLuaState wxlState = wxLuaState(p_wxLuaErrorHandler, wxID_ANY);
    if (wxlState.Ok() == true)
    {
        wxLogMessage(wxT("wxLua state created OK."));
    }
    else
    {
        wxLogFatalError(wxT("Unable to create wxLua state, quitting"));
        return EXIT_FAILURE;
    }

    const wxString scriptPath(wxT("wxluanstest_prog.lua"));
    wxLogMessage(wxT("Running script ") + scriptPath);
    if (wxlState.RunFile(scriptPath) == 0)
    {
        wxLogMessage(wxT("lua script completed."));
    }
    else
    {
        wxLogError(wxT("lua script failed."));
        return EXIT_FAILURE;
    }


    return EXIT_SUCCESS;
}
