/* AbiWord
 * Copyright (C) 1998 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "ut_types.h"
#include "ut_string.h"
#include "ut_assert.h"
#include "ut_debugmsg.h"

// This header defines some functions for BeOS dialogs,
// like centering them, measuring them, etc.
#include "ut_dialogHelper.h"

#include "gr_BeOSGraphics.h"

#include "xap_App.h"
#include "xap_BeOSApp.h"
#include "xap_BeOSFrame.h"
#include "xap_Prefs.h"

#include "ap_Dialog_Id.h"
#include "ap_Prefs_SchemeIds.h"

#include "ap_Strings.h"

#include "ap_BeOSDialog_Options.h"

/*****************************************************************/

#define WIDGET_DIALOG_TAG "dialog"

/*****************************************************************/

XAP_Dialog * AP_BeOSDialog_Options::static_constructor(XAP_DialogFactory * pFactory,
                                                         XAP_Dialog_Id id)
{
    AP_BeOSDialog_Options * p = new AP_BeOSDialog_Options(pFactory,id);
    return p;
}

AP_BeOSDialog_Options::AP_BeOSDialog_Options(XAP_DialogFactory * pDlgFactory,
                                                 XAP_Dialog_Id id)
    : AP_Dialog_Options(pDlgFactory,id)
{
#if 0
	XAP_Prefs *prefs = m_pApp->getPrefs();
	UT_ASSERT(prefs);
	UT_DEBUGMSG(("AP_BeOSDialog_Options::AP_BeOSDialog_Options[%s:%d]", __FILE__, __LINE__));
	UT_DEBUGMSG(("    current pref : %s",
		prefs->getCurrentScheme()->getSchemeName()) );

	UT_Bool b = prefs->savePrefsFile();
	UT_DEBUGMSG(("    prefs saved (%d) in %s", b, prefs->getPrefsPathname() ));

	UT_uint32 i;
	XAP_PrefsScheme *ps;
	for ( i = 0; (ps = prefs->getNthScheme(i)) != 0; i++ ) {
		UT_DEBUGMSG(("    %d [%s]", i, ps->getSchemeName() ));
	
		XML_Char const *pszKey, *pszValue;
		for ( UT_uint32 j = 0; ps->getNthValue(j, &pszKey, &pszValue ); j++ ) {
			UT_DEBUGMSG(("        %x %-30s : %s", j, pszKey, pszValue ));
		}
	}
#endif
}

AP_BeOSDialog_Options::~AP_BeOSDialog_Options(void)
{
}

/*****************************************************************/

// sample callback function
static void s_ok_clicked(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_OK(); }

static void s_cancel_clicked(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_Cancel(); }

static void s_delete_clicked(GtkWidget * /* widget */,
                             gpointer /* data */,
                             AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(dlg); dlg->event_WindowDelete(); }

// toggle buttons
#if 0
static void s_check_widoworphancontrol_toggled(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_WidowOrphanControlToggled(); }

static void s_check_keeplinestogether_toggled(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_KeepLinesTogetherToggled(); }

static void s_check_keepwithnext_toggled(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_KeepWithNextToggled(); }

static void s_check_pagebreakbefore_toggled(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_PageBreakBeforeToggled(); }

static void s_check_suppresslinenumbers_toggled(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_SuppressLineNumbersToggled(); }

static void s_check_nohyphenate_toggled(GtkWidget * widget, AP_BeOSDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_NoHyphenateToggled(); }
#endif

// preview drawing area

/*****************************************************************/

void AP_BeOSDialog_Options::runModal(XAP_Frame * pFrame)
{
#if 0
    // Build the window's widgets and arrange them
    GtkWidget * mainWindow = _constructWindow();
    UT_ASSERT(mainWindow);

    // Populate the window's data items
    _populateWindowData();

    // To center the dialog, we need the frame of its parent.
    XAP_BeOSFrame * pBeOSFrame = static_cast<XAP_BeOSFrame *>(pFrame);
    UT_ASSERT(pBeOSFrame);
    
    // Get the GtkWindow of the parent frame
    GtkWidget * parentWindow = pBeOSFrame->getTopLevelWindow();
    UT_ASSERT(parentWindow);
    
    // Center our new dialog in its parent and make it a transient
    // so it won't get lost underneath
    centerDialog(parentWindow, mainWindow);
    gtk_window_set_transient_for(GTK_WINDOW(mainWindow), GTK_WINDOW(parentWindow));

    // Show the top level dialog,
    gtk_widget_show(mainWindow);

    // Make it modal, and stick it up top
    gtk_grab_add(mainWindow);

    // Run into the GTK event loop for this window.
    gtk_main();

    _storeWindowData();
    
    gtk_widget_destroy(mainWindow);
#endif
}

void AP_BeOSDialog_Options::event_OK(void)
{
    m_answer = AP_Dialog_Options::a_OK;
//    gtk_main_quit();
}

void AP_BeOSDialog_Options::event_Cancel(void)
{
    m_answer = AP_Dialog_Options::a_CANCEL;
//    gtk_main_quit();
}

void AP_BeOSDialog_Options::event_WindowDelete(void)
{
    m_answer = AP_Dialog_Options::a_CANCEL;    
//    gtk_main_quit();
}

/****************************************/

// Alignment methods

//void AP_BeOSDialog_Options::event_AlignmentChanged(void) { }

/****************************************/

// generic methods for spin buttons
#if 0
void AP_BeOSDialog_Options::event_UpdateEntry(GtkWidget * widget)
{
    gchar * oldtext = gtk_entry_get_text(GTK_ENTRY(widget));

    XML_Char * newtext = _filterUserInput((XML_Char *) oldtext);

    // we have to protect this section with a lock, so that updating
    // the text doesn't trigger this same event
    {
        gtk_object_set_data(GTK_OBJECT(widget), "updatelock", (void *) TRUE);
    
        if ( ((gboolean) gtk_object_get_data(GTK_OBJECT(widget), "updatelock")) == FALSE)
            gtk_entry_set_text(GTK_ENTRY(widget), (const gchar *) newtext);

        gtk_object_set_data(GTK_OBJECT(widget), "updatelock", (void *) FALSE);
    }
}
#endif

#if 0
void AP_BeOSDialog_Options::event_UnitSpinButtonChanged(GtkWidget * spinbutton, GtkAdjustment * adj)
{
    UT_ASSERT(spinbutton && adj);
    
    const char * newvalue =
        UT_convertToDimensionString(m_dim, (double) adj->value, ".1");

    UT_ASSERT(newvalue);

    GtkSpinButton * sb = GTK_SPIN_BUTTON(spinbutton);

    GtkEntry * entry = & sb->entry;
    
    gtk_entry_set_text(entry, newvalue);
}

void AP_BeOSDialog_Options::event_UnitlessSpinButtonChanged(GtkWidget * spinbutton, GtkAdjustment * adj)
{
    UT_ASSERT(spinbutton && adj);
    
    const char * newvalue =
        UT_convertToDimensionString(m_dim, (double) adj->value, ".1");

    UT_ASSERT(newvalue);

    GtkSpinButton * sb = GTK_SPIN_BUTTON(spinbutton);

    GtkEntry * entry = & sb->entry;
    
    gtk_entry_set_text(entry, newvalue);
}
#endif

/****************************************/

/*****************************************************************/

#if 0

AP_Dialog_Options::tAlignment AP_BeOSDialog_Options::_gatherAlignmentType(void) {}
void AP_BeOSDialog_Options::_setAlignmentType(AP_Dialog_Options::tAlignment alignment) {}
AP_Dialog_Options::tSpecialIndent AP_BeOSDialog_Options::_gatherSpecialIndentType(void) {}
void AP_BeOSDialog_Options::_setSpecialIndentType(AP_Dialog_Options::tSpecialIndent indent) {}
AP_Dialog_Options::tLineSpacing AP_BeOSDialog_Options::_gatherLineSpacingType(void) {}
void AP_BeOSDialog_Options::_setLineSpacingType(AP_Dialog_Options::tLineSpacing spacing) {}
    
const XML_Char *    AP_BeOSDialog_Options::_gatherLeftIndent(void) {}
void                AP_BeOSDialog_Options::_setLeftIndent(const XML_Char * indent) {}
const XML_Char *    AP_BeOSDialog_Options::_gatherRightIndent(void) {}
void                AP_BeOSDialog_Options::_setRightIndent(const XML_Char * indent) {}
const XML_Char *    AP_BeOSDialog_Options::_gatherSpecialIndent(void) {}
void                AP_BeOSDialog_Options::_setSpecialIndent(const XML_Char * indent) {}
    
const XML_Char *    AP_BeOSDialog_Options::_gatherBeforeSpacing(void) {}
void                AP_BeOSDialog_Options::_setBeforeSpacing(const XML_Char * spacing) {}
const XML_Char *    AP_BeOSDialog_Options::_gatherAfterSpacing(void) {}
void                AP_BeOSDialog_Options::_setAfterSpacing(const XML_Char * spacing) {}
const XML_Char *    AP_BeOSDialog_Options::_gatherSpecialSpacing(void) {}    
void                AP_BeOSDialog_Options::_setSpecialSpacing(const XML_Char * spacing) {}
    
UT_Bool                AP_BeOSDialog_Options::_gatherWidowOrphanControl(void) {}
void                AP_BeOSDialog_Options::_setWidowOrphanControl(UT_Bool b) {}
UT_Bool                AP_BeOSDialog_Options::_gatherKeepLinesTogether(void) {}
void                AP_BeOSDialog_Options::_setKeepLinesTogether(UT_Bool b) {}
UT_Bool                AP_BeOSDialog_Options::_gatherKeepWithNext(void) {}
void                AP_BeOSDialog_Options::_setKeepWithNext(UT_Bool b) {}
UT_Bool                AP_BeOSDialog_Options::_gatherSuppressLineNumbers(void) {}
void                AP_BeOSDialog_Options::_setSuppressLineNumbers(UT_Bool b) {}
UT_Bool                AP_BeOSDialog_Options::_gatherNoHyphenate(void) {}
void                AP_BeOSDialog_Options::_setNoHyphenate(UT_Bool b) {}

#endif

/*****************************************************************/

/*
GtkWidget* AP_BeOSDialog_Options::_constructWindow ()
{
}
*/

UT_Bool     AP_BeOSDialog_Options::_gatherSpellCheckAsType(void)	{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellCheckAsType(UT_Bool b) { b = b; }
UT_Bool     AP_BeOSDialog_Options::_gatherSpellHideErrors(void)	{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellHideErrors(UT_Bool b)	{ b = b; }
UT_Bool     AP_BeOSDialog_Options::_gatherSpellSuggest(void)		{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellSuggest(UT_Bool b)		{ b = b; }
UT_Bool     AP_BeOSDialog_Options::_gatherSpellMainOnly(void)		{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellMainOnly(UT_Bool b)	{ b = b; }
UT_Bool     AP_BeOSDialog_Options::_gatherSpellUppercase(void)		{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellUppercase(UT_Bool b)	{ b = b; }
UT_Bool     AP_BeOSDialog_Options::_gatherSpellNumbers(void)		{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellNumbers(UT_Bool b)		{ b = b; }
UT_Bool     AP_BeOSDialog_Options::_gatherSpellInternet(void)		{ return UT_TRUE; }
void        AP_BeOSDialog_Options::_setSpellInternet(UT_Bool b)	{ b = b; }
