/* AbiWord
 * Copyright (C) 1998 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include "ut_types.h"
#include "ut_string.h"
#include "ut_assert.h"
#include "ut_debugmsg.h"

// This header defines some functions for Unix dialogs,
// like centering them, measuring them, etc.
#include "ut_dialogHelper.h"

#include "gr_UnixGraphics.h"

#include "xap_App.h"
#include "xap_UnixApp.h"
#include "xap_UnixFrame.h"
#include "xap_Prefs.h"

#include "ap_Dialog_Id.h"
#include "ap_Prefs_SchemeIds.h"

#include "ap_Strings.h"

#include "ap_UnixDialog_Options.h"

/*****************************************************************/

#define WIDGET_DIALOG_TAG "dialog"

/*****************************************************************/

XAP_Dialog * AP_UnixDialog_Options::static_constructor(XAP_DialogFactory * pFactory,
                                                         XAP_Dialog_Id id)
{
    AP_UnixDialog_Options * p = new AP_UnixDialog_Options(pFactory,id);
    return p;
}

AP_UnixDialog_Options::AP_UnixDialog_Options(XAP_DialogFactory * pDlgFactory,
                                                 XAP_Dialog_Id id)
    : AP_Dialog_Options(pDlgFactory,id)
{
#if 0
	XAP_Prefs *prefs = m_pApp->getPrefs();
	UT_ASSERT(prefs);
	UT_DEBUGMSG(("AP_UnixDialog_Options::AP_UnixDialog_Options[%s:%d]", __FILE__, __LINE__));
	UT_DEBUGMSG(("    current pref : %s",
		prefs->getCurrentScheme()->getSchemeName()) );

	UT_Bool b = prefs->savePrefsFile();
	UT_DEBUGMSG(("    prefs saved (%d) in %s", b, prefs->getPrefsPathname() ));

	UT_uint32 i;
	XAP_PrefsScheme *ps;
	for ( i = 0; (ps = prefs->getNthScheme(i)) != 0; i++ ) {
		UT_DEBUGMSG(("    %d [%s]", i, ps->getSchemeName() ));
	
		XML_Char const *pszKey, *pszValue;
		for ( UT_uint32 j = 0; ps->getNthValue(j, &pszKey, &pszValue ); j++ ) {
			UT_DEBUGMSG(("        %x %-30s : %s", j, pszKey, pszValue ));
		}
	}
#endif
}

AP_UnixDialog_Options::~AP_UnixDialog_Options(void)
{
}

/*****************************************************************/

// sample callback function
static void s_ok_clicked(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_OK(); }

static void s_cancel_clicked(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_Cancel(); }

static void s_delete_clicked(GtkWidget * /* widget */,
                             gpointer /* data */,
                             AP_UnixDialog_Options * dlg)
{ UT_ASSERT(dlg); dlg->event_WindowDelete(); }

// toggle buttons
#if 0
static void s_check_widoworphancontrol_toggled(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_WidowOrphanControlToggled(); }

static void s_check_keeplinestogether_toggled(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_KeepLinesTogetherToggled(); }

static void s_check_keepwithnext_toggled(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_KeepWithNextToggled(); }

static void s_check_pagebreakbefore_toggled(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_PageBreakBeforeToggled(); }

static void s_check_suppresslinenumbers_toggled(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_SuppressLineNumbersToggled(); }

static void s_check_nohyphenate_toggled(GtkWidget * widget, AP_UnixDialog_Options * dlg)
{ UT_ASSERT(widget && dlg); dlg->event_NoHyphenateToggled(); }
#endif

// preview drawing area

/*****************************************************************/

void AP_UnixDialog_Options::runModal(XAP_Frame * pFrame)
{
    // Build the window's widgets and arrange them
    GtkWidget * mainWindow = _constructWindow();
    UT_ASSERT(mainWindow);

    // Populate the window's data items
    _populateWindowData();

    // To center the dialog, we need the frame of its parent.
    XAP_UnixFrame * pUnixFrame = static_cast<XAP_UnixFrame *>(pFrame);
    UT_ASSERT(pUnixFrame);
    
    // Get the GtkWindow of the parent frame
    GtkWidget * parentWindow = pUnixFrame->getTopLevelWindow();
    UT_ASSERT(parentWindow);
    
    // Center our new dialog in its parent and make it a transient
    // so it won't get lost underneath
    centerDialog(parentWindow, mainWindow);
    gtk_window_set_transient_for(GTK_WINDOW(mainWindow), GTK_WINDOW(parentWindow));

    // Show the top level dialog,
    gtk_widget_show(mainWindow);

    // Make it modal, and stick it up top
    gtk_grab_add(mainWindow);

    // Run into the GTK event loop for this window.
    gtk_main();

    _storeWindowData();
    
    gtk_widget_destroy(mainWindow);
}

void AP_UnixDialog_Options::event_OK(void)
{
    m_answer = AP_Dialog_Options::a_OK;
    gtk_main_quit();
}

void AP_UnixDialog_Options::event_Cancel(void)
{
    m_answer = AP_Dialog_Options::a_CANCEL;
    gtk_main_quit();
}

void AP_UnixDialog_Options::event_WindowDelete(void)
{
    m_answer = AP_Dialog_Options::a_CANCEL;    
    gtk_main_quit();
}

/****************************************/

// Alignment methods

//void AP_UnixDialog_Options::event_AlignmentChanged(void) { }

/****************************************/

// generic methods for spin buttons
#if 0
void AP_UnixDialog_Options::event_UpdateEntry(GtkWidget * widget)
{
    gchar * oldtext = gtk_entry_get_text(GTK_ENTRY(widget));

    XML_Char * newtext = _filterUserInput((XML_Char *) oldtext);

    // we have to protect this section with a lock, so that updating
    // the text doesn't trigger this same event
    {
        gtk_object_set_data(GTK_OBJECT(widget), "updatelock", (void *) TRUE);
    
        if ( ((gboolean) gtk_object_get_data(GTK_OBJECT(widget), "updatelock")) == FALSE)
            gtk_entry_set_text(GTK_ENTRY(widget), (const gchar *) newtext);

        gtk_object_set_data(GTK_OBJECT(widget), "updatelock", (void *) FALSE);
    }
}
#endif

#if 0
void AP_UnixDialog_Options::event_UnitSpinButtonChanged(GtkWidget * spinbutton, GtkAdjustment * adj)
{
    UT_ASSERT(spinbutton && adj);
    
    const char * newvalue =
        UT_convertToDimensionString(m_dim, (double) adj->value, ".1");

    UT_ASSERT(newvalue);

    GtkSpinButton * sb = GTK_SPIN_BUTTON(spinbutton);

    GtkEntry * entry = & sb->entry;
    
    gtk_entry_set_text(entry, newvalue);
}

void AP_UnixDialog_Options::event_UnitlessSpinButtonChanged(GtkWidget * spinbutton, GtkAdjustment * adj)
{
    UT_ASSERT(spinbutton && adj);
    
    const char * newvalue =
        UT_convertToDimensionString(m_dim, (double) adj->value, ".1");

    UT_ASSERT(newvalue);

    GtkSpinButton * sb = GTK_SPIN_BUTTON(spinbutton);

    GtkEntry * entry = & sb->entry;
    
    gtk_entry_set_text(entry, newvalue);
}
#endif

/****************************************/

/*****************************************************************/

#if 0

AP_Dialog_Options::tAlignment AP_UnixDialog_Options::_gatherAlignmentType(void) {}
void AP_UnixDialog_Options::_setAlignmentType(AP_Dialog_Options::tAlignment alignment) {}
AP_Dialog_Options::tSpecialIndent AP_UnixDialog_Options::_gatherSpecialIndentType(void) {}
void AP_UnixDialog_Options::_setSpecialIndentType(AP_Dialog_Options::tSpecialIndent indent) {}
AP_Dialog_Options::tLineSpacing AP_UnixDialog_Options::_gatherLineSpacingType(void) {}
void AP_UnixDialog_Options::_setLineSpacingType(AP_Dialog_Options::tLineSpacing spacing) {}
    
const XML_Char *    AP_UnixDialog_Options::_gatherLeftIndent(void) {}
void                AP_UnixDialog_Options::_setLeftIndent(const XML_Char * indent) {}
const XML_Char *    AP_UnixDialog_Options::_gatherRightIndent(void) {}
void                AP_UnixDialog_Options::_setRightIndent(const XML_Char * indent) {}
const XML_Char *    AP_UnixDialog_Options::_gatherSpecialIndent(void) {}
void                AP_UnixDialog_Options::_setSpecialIndent(const XML_Char * indent) {}
    
const XML_Char *    AP_UnixDialog_Options::_gatherBeforeSpacing(void) {}
void                AP_UnixDialog_Options::_setBeforeSpacing(const XML_Char * spacing) {}
const XML_Char *    AP_UnixDialog_Options::_gatherAfterSpacing(void) {}
void                AP_UnixDialog_Options::_setAfterSpacing(const XML_Char * spacing) {}
const XML_Char *    AP_UnixDialog_Options::_gatherSpecialSpacing(void) {}    
void                AP_UnixDialog_Options::_setSpecialSpacing(const XML_Char * spacing) {}
    
UT_Bool                AP_UnixDialog_Options::_gatherWidowOrphanControl(void) {}
void                AP_UnixDialog_Options::_setWidowOrphanControl(UT_Bool b) {}
UT_Bool                AP_UnixDialog_Options::_gatherKeepLinesTogether(void) {}
void                AP_UnixDialog_Options::_setKeepLinesTogether(UT_Bool b) {}
UT_Bool                AP_UnixDialog_Options::_gatherKeepWithNext(void) {}
void                AP_UnixDialog_Options::_setKeepWithNext(UT_Bool b) {}
UT_Bool                AP_UnixDialog_Options::_gatherSuppressLineNumbers(void) {}
void                AP_UnixDialog_Options::_setSuppressLineNumbers(UT_Bool b) {}
UT_Bool                AP_UnixDialog_Options::_gatherNoHyphenate(void) {}
void                AP_UnixDialog_Options::_setNoHyphenate(UT_Bool b) {}

#endif

/*****************************************************************/

GtkWidget* AP_UnixDialog_Options::_constructWindow ()
{
    GtkWidget *windowOptions;
    GtkWidget *vbox1;
    GtkWidget *notebook1;
    GtkWidget *hbox1;
    GtkWidget *vbox2;
    GtkWidget *checkbuttonSpellCheckAsType;
    GtkWidget *checkbuttonSpellHideErrors;
    GtkWidget *checkbuttonSpellSuggest;
    GtkWidget *checkbuttonSpellMainOnly;
    GtkWidget *checkbuttonSpellUppercase;
    GtkWidget *checkbuttonSpellNumbers;
    GtkWidget *checkbuttonSpellInternet;
    GtkWidget *hbox2;
    GtkWidget *labelSpellCustom;
    GtkWidget *listSpellDicts;
    GtkWidget *listSpellDicts_menu;
    GtkWidget *glade_menuitem;
    GtkWidget *buttonSpellDictionary;
    GtkWidget *labelSpell;
    GtkWidget *hbox3;
    GtkWidget *hbuttonbox2;
    GtkWidget *buttonOK;
    GtkWidget *buttonCancel;

    windowOptions = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_object_set_data (GTK_OBJECT (windowOptions), "windowOptions", windowOptions);
    gtk_window_set_title (GTK_WINDOW (windowOptions), "Options");

    vbox1 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox1);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "vbox1", vbox1,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (vbox1);
    gtk_container_add (GTK_CONTAINER (windowOptions), vbox1);

    notebook1 = gtk_notebook_new ();
    gtk_widget_ref (notebook1);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "notebook1", notebook1,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (notebook1);
    gtk_box_pack_start (GTK_BOX (vbox1), notebook1, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (notebook1), 10);

    //----------------------------------------------------------
	// begin spelling

    hbox1 = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox1);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "hbox1", hbox1,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbox1);
    gtk_container_add (GTK_CONTAINER (notebook1), hbox1);
    gtk_container_set_border_width (GTK_CONTAINER (hbox1), 10);

    vbox2 = gtk_vbox_new (FALSE, 0);
    gtk_widget_ref (vbox2);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "vbox2", vbox2,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (vbox2);
    gtk_box_pack_start (GTK_BOX (hbox1), vbox2, TRUE, TRUE, 5);

    checkbuttonSpellCheckAsType = gtk_check_button_new_with_label ("Check s&pelling as you type");
    gtk_widget_ref (checkbuttonSpellCheckAsType);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellCheckAsType", checkbuttonSpellCheckAsType,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellCheckAsType);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellCheckAsType, FALSE, FALSE, 0);

    checkbuttonSpellHideErrors = gtk_check_button_new_with_label ("Hide &spelling errors in the document");
    gtk_widget_ref (checkbuttonSpellHideErrors);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellHideErrors", checkbuttonSpellHideErrors,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellHideErrors);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellHideErrors, FALSE, FALSE, 0);

    checkbuttonSpellSuggest = gtk_check_button_new_with_label ("A&lways suggest corrections");
    gtk_widget_ref (checkbuttonSpellSuggest);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellSuggest", checkbuttonSpellSuggest,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellSuggest);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellSuggest, FALSE, FALSE, 0);

    checkbuttonSpellMainOnly = gtk_check_button_new_with_label ("Suggest from &main dictionary only");
    gtk_widget_ref (checkbuttonSpellMainOnly);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellMainOnly", checkbuttonSpellMainOnly,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellMainOnly);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellMainOnly, FALSE, FALSE, 0);

    checkbuttonSpellUppercase = gtk_check_button_new_with_label ("Ignore words in &UPPERCASE");
    gtk_widget_ref (checkbuttonSpellUppercase);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellUppercase", checkbuttonSpellUppercase,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellUppercase);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellUppercase, FALSE, FALSE, 0);

    checkbuttonSpellNumbers = gtk_check_button_new_with_label ("Ignore words with num&bers");
    gtk_widget_ref (checkbuttonSpellNumbers);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellNumbers", checkbuttonSpellNumbers,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellNumbers);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellNumbers, FALSE, FALSE, 0);

    checkbuttonSpellInternet = gtk_check_button_new_with_label ("Ignore Internet and &file addresses");
    gtk_widget_ref (checkbuttonSpellInternet);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "checkbuttonSpellInternet", checkbuttonSpellInternet,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (checkbuttonSpellInternet);
    gtk_box_pack_start (GTK_BOX (vbox2), checkbuttonSpellInternet, FALSE, FALSE, 0);

    hbox2 = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox2);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "hbox2", hbox2,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbox2);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox2, FALSE, FALSE, 0);

    labelSpellCustom = gtk_label_new ("Custom dickion&ary: ");
    gtk_widget_ref (labelSpellCustom);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "labelSpellCustom", labelSpellCustom,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (labelSpellCustom);
    gtk_box_pack_start (GTK_BOX (hbox2), labelSpellCustom, FALSE, FALSE, 0);

    listSpellDicts = gtk_option_menu_new ();
    gtk_widget_ref (listSpellDicts);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "listSpellDicts", listSpellDicts,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (listSpellDicts);
    gtk_box_pack_start (GTK_BOX (hbox2), listSpellDicts, FALSE, FALSE, 10);
    listSpellDicts_menu = gtk_menu_new ();
    glade_menuitem = gtk_menu_item_new_with_label ("custom.dic");
    gtk_widget_show (glade_menuitem);
    gtk_menu_append (GTK_MENU (listSpellDicts_menu), glade_menuitem);
    gtk_option_menu_set_menu (GTK_OPTION_MENU (listSpellDicts), listSpellDicts_menu);

    buttonSpellDictionary = gtk_button_new_with_label ("&Dictionary...");
    gtk_widget_ref (buttonSpellDictionary);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "buttonSpellDictionary", buttonSpellDictionary,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (buttonSpellDictionary);
    gtk_box_pack_start (GTK_BOX (hbox2), buttonSpellDictionary, FALSE, FALSE, 0);

    labelSpell = gtk_label_new ("Spelling");
    gtk_widget_ref (labelSpell);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "labelSpell", labelSpell,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (labelSpell);
    gtk_notebook_set_tab_label (GTK_NOTEBOOK (notebook1), gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook1), 0), labelSpell);

    hbox3 = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox3);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "hbox3", hbox3,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbox3);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 0);

    hbuttonbox2 = gtk_hbutton_box_new ();
    gtk_widget_ref (hbuttonbox2);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "hbuttonbox2", hbuttonbox2,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (hbuttonbox2);
    gtk_box_pack_end (GTK_BOX (hbox3), hbuttonbox2, FALSE, TRUE, 0);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox2), 20);

//------------------------------------------------------------
// end spelling stuff

    buttonOK = gtk_button_new_with_label ("Ok");
    gtk_widget_ref (buttonOK);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "buttonOK", buttonOK,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (buttonOK);
    gtk_container_add (GTK_CONTAINER (hbuttonbox2), buttonOK);
    GTK_WIDGET_SET_FLAGS (buttonOK, GTK_CAN_DEFAULT);

    buttonCancel = gtk_button_new_with_label ("Cancel");
    gtk_widget_ref (buttonCancel);
    gtk_object_set_data_full (GTK_OBJECT (windowOptions), "buttonCancel", buttonCancel,
                              (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (buttonCancel);
    gtk_container_add (GTK_CONTAINER (hbuttonbox2), buttonCancel);
    GTK_WIDGET_SET_FLAGS (buttonCancel, GTK_CAN_DEFAULT);

    //////////////////////////////////////////////////////////////////////
    // the control buttons
    gtk_signal_connect(GTK_OBJECT(buttonOK),
                       "clicked",
                       GTK_SIGNAL_FUNC(s_ok_clicked),
                       (gpointer) this);
    
    gtk_signal_connect(GTK_OBJECT(buttonCancel),
                       "clicked",
                       GTK_SIGNAL_FUNC(s_cancel_clicked),
                       (gpointer) this);


    // the catch-alls
    gtk_signal_connect_after(GTK_OBJECT(windowOptions),
                             "delete_event",
                             GTK_SIGNAL_FUNC(s_delete_clicked),
                             (gpointer) this);

    gtk_signal_connect_after(GTK_OBJECT(windowOptions),
                             "destroy",
                             NULL,
                             NULL);

    // Update member variables with the important widgets that
    // might need to be queried or altered later.

    m_windowMain = windowOptions;

    m_checkbuttonSpellCheckAsType	= checkbuttonSpellCheckAsType;
    m_checkbuttonSpellHideErrors	= checkbuttonSpellHideErrors;
    m_checkbuttonSpellSuggest		= checkbuttonSpellSuggest;
    m_checkbuttonSpellMainOnly		= checkbuttonSpellMainOnly;
    m_checkbuttonSpellUppercase		= checkbuttonSpellUppercase;
    m_checkbuttonSpellNumbers		= checkbuttonSpellNumbers;
    m_checkbuttonSpellInternet		= checkbuttonSpellInternet;

	m_listSpellDicts				= listSpellDicts;
	m_listSpellDicts_menu			= listSpellDicts_menu;
	m_buttonSpellDictionary			= buttonSpellDictionary;

    m_buttonOK = buttonOK;
    m_buttonCancel = buttonCancel;
    return windowOptions;
}

void AP_UnixDialog_Options::_populateWindowData(void)
{
	
	// TODO: move this logic when we get a PrefsListener API
	const XML_Char * szAutoSpell;
	if (m_pApp->getPrefsValue(AP_PREF_KEY_AutoSpellCheck,&szAutoSpell))
		m_SpellCheckAsType = (szAutoSpell[0] == '1') ? UT_TRUE : UT_FALSE;

	_setSpellCheckAsType( m_SpellCheckAsType );

#if 0
    // alignment option menu 
    UT_ASSERT(m_listAlignment);
    gtk_option_menu_set_history(GTK_OPTION_MENU(m_listAlignment),
                                (gint) m_paragraphData.m_alignmentType);

    // indent and paragraph margins
    UT_ASSERT(m_spinbuttonLeft);
    gtk_entry_set_text(GTK_ENTRY(m_spinbuttonLeft),
                       (const gchar *) m_paragraphData.m_leftIndent);

    UT_ASSERT(m_spinbuttonRight);
    gtk_entry_set_text(GTK_ENTRY(m_spinbuttonRight),
                       (const gchar *) m_paragraphData.m_rightIndent);

    UT_ASSERT(m_spinbuttonBy);
    gtk_entry_set_text(GTK_ENTRY(m_spinbuttonBy),
                       (const gchar *) m_paragraphData.m_specialIndent);

    UT_ASSERT(m_listSpecial);
    gtk_option_menu_set_history(GTK_OPTION_MENU(m_listSpecial),
                                (gint) m_paragraphData.m_specialIndentType);
    
    // if m_specialIndentType is "(none)" (OptionsDialogData::indent_NONE)
    // then the "By" spin should be disabled

    if (m_paragraphData.m_specialIndentType == OptionsDialogData::indent_NONE)
        gtk_widget_set_sensitive(GTK_WIDGET(m_spinbuttonBy), FALSE);
    else
        gtk_widget_set_sensitive(GTK_WIDGET(m_spinbuttonBy), TRUE);
#endif    
}


UT_Bool     AP_UnixDialog_Options::_gatherSpellCheckAsType(void) 
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellCheckAsType) );
}

void        AP_UnixDialog_Options::_setSpellCheckAsType(UT_Bool b) 
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellCheckAsType), b );
}

UT_Bool     AP_UnixDialog_Options::_gatherSpellHideErrors(void) 
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellHideErrors) );
}

void        AP_UnixDialog_Options::_setSpellHideErrors(UT_Bool b) 
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellHideErrors), b );
}

UT_Bool     AP_UnixDialog_Options::_gatherSpellSuggest(void) 
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellSuggest) );
}

void        AP_UnixDialog_Options::_setSpellSuggest(UT_Bool b) 
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellSuggest), b );
}

UT_Bool     AP_UnixDialog_Options::_gatherSpellMainOnly(void)
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellMainOnly) );
}

void        AP_UnixDialog_Options::_setSpellMainOnly(UT_Bool b)
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellMainOnly), b );
}

UT_Bool     AP_UnixDialog_Options::_gatherSpellUppercase(void)
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellUppercase) );
}

void        AP_UnixDialog_Options::_setSpellUppercase(UT_Bool b)
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellUppercase), b );
}

UT_Bool     AP_UnixDialog_Options::_gatherSpellNumbers(void) 
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellNumbers) );
}

void        AP_UnixDialog_Options::_setSpellNumbers(UT_Bool b) 
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellNumbers), b );
}

UT_Bool     AP_UnixDialog_Options::_gatherSpellInternet(void) 
{ 
	return gtk_toggle_button_get_active ( 
				GTK_TOGGLE_BUTTON(m_checkbuttonSpellInternet) );
}

void        AP_UnixDialog_Options::_setSpellInternet(UT_Bool b) 
{ 
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(m_checkbuttonSpellInternet), b );
}

