/* AbiWord
 * Copyright (C) 1998 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "ut_assert.h"
#include "ut_string.h"
#include "ut_debugmsg.h"

#include "xap_Dialog_Id.h"
#include "xap_DialogFactory.h"
#include "xap_Prefs.h"

#include "ap_Dialog_Options.h"
#include "ap_Prefs_SchemeIds.h"

AP_Dialog_Options::AP_Dialog_Options(XAP_DialogFactory * pDlgFactory, XAP_Dialog_Id id)
	: XAP_Dialog_NonPersistent(pDlgFactory,id)
{
	m_answer = a_OK;
}

AP_Dialog_Options::~AP_Dialog_Options(void)
{
}

AP_Dialog_Options::tAnswer AP_Dialog_Options::getAnswer(void) const
{
	return m_answer;
}

#define SAVE_PREF_BOOL(key,var) {szBuffer[0] = ((var)==UT_TRUE ? '1' : '0'); \
								 pPrefsScheme->setValue( key, szBuffer );}
void AP_Dialog_Options::_storeWindowData(void)
{
	XAP_Prefs *pPrefs = m_pApp->getPrefs();
	UT_ASSERT(pPrefs);

	XAP_PrefsScheme *pPrefsScheme = pPrefs->getCurrentScheme();
	UT_ASSERT(pPrefs->getCurrentScheme());

	// check to see if there is any other scheme besides _buildin_
	UT_ASSERT( pPrefsScheme );	
	if ( !strcmp( pPrefs->getCurrentScheme()->getSchemeName(), "_builtin_") ) {
		// TODO: need to decide on a scheme default name
		const XML_Char new_name[] = "user_prefs";
		
		pPrefsScheme = new XAP_PrefsScheme(new_name);
		UT_ASSERT( pPrefsScheme );	
		pPrefs->addScheme( pPrefsScheme );
		pPrefs->setCurrentScheme( new_name );
	}

	// save the values to the Prefs classes
	XML_Char szBuffer[] = { 0, 0 };		// needed by SAVE_PREF_BOOL macro
	SAVE_PREF_BOOL( AP_PREF_KEY_AutoSpellCheck, _gatherSpellCheckAsType() );

	// do we want to save the preferences automatically here?
	// probably not, but for now, lets do until I add the TODO 
	// "do you want to save your changes?" dialog
	//			shack@uiuc.edu
	if ( pPrefs->getAutoSavePrefs() == UT_FALSE ) {
		// TODO: check the results
		pPrefs->savePrefsFile();
	}
}
#undef SAVE_PREF_BOOL

