/* AbiWord
 * Copyright (C) 1998 AbiSource, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef AP_DIALOG_OPTIONS_H
#define AP_DIALOG_OPTIONS_H

#include "xap_Frame.h"
#include "xap_Dialog.h"
#include "xav_View.h"

class XAP_Frame;

class AP_Dialog_Options : public XAP_Dialog_NonPersistent
{
 public:

	AP_Dialog_Options(XAP_DialogFactory * pDlgFactory, XAP_Dialog_Id id);
	virtual ~AP_Dialog_Options(void);

	virtual void	runModal(XAP_Frame * pFrame) = 0;

	// answer from dialog
	typedef enum { a_OK, a_CANCEL } tAnswer;

	AP_Dialog_Options::tAnswer	getAnswer(void) const;

 protected:
	void _storeWindowData(void);	// calls the following functions to
									// lookup values to set as preferences
								// don't see any need to make virtual yet, all
								// optdlgs should as for the same preferences

	virtual UT_Bool			_gatherSpellCheckAsType(void) = 0;
	virtual void			_setSpellCheckAsType(UT_Bool b) = 0;
	virtual UT_Bool			_gatherSpellHideErrors(void) = 0;
	virtual void			_setSpellHideErrors(UT_Bool b) = 0;
	virtual UT_Bool			_gatherSpellSuggest(void) = 0;
	virtual void			_setSpellSuggest(UT_Bool b) = 0;
	virtual UT_Bool			_gatherSpellMainOnly(void) = 0;
	virtual void			_setSpellMainOnly(UT_Bool b) = 0;
	virtual UT_Bool			_gatherSpellUppercase(void) = 0;
	virtual void			_setSpellUppercase(UT_Bool b) = 0;
	virtual UT_Bool			_gatherSpellNumbers(void) = 0;
	virtual void			_setSpellNumbers(UT_Bool b) = 0;
	virtual UT_Bool			_gatherSpellInternet(void) = 0;
	virtual void			_setSpellInternet(UT_Bool b) = 0;
	
 protected:
	
	tAnswer				m_answer;
	UT_Bool				m_SpellCheckAsType;
	UT_Bool				m_SpellHideErrors;
	UT_Bool				m_SpellSpellSuggest;
	UT_Bool				m_SpellMainOnly;
	UT_Bool				m_SpellUppercase;
	UT_Bool				m_SpellNumbers;
	UT_Bool				m_SpellInternet;
};

#endif /* AP_DIALOG_PARAGRAPH_H */
