/* gcc -g -Wall -pedantic -ansi main.c table.o -o table `pkg-config gtk+-2.0 --cflags --libs` */
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include "table.h"

/* #define DBG printf("%s\n", __FUNCTION__) */
#define DBG

static GtkWidget *window = NULL;

/***** <MARTIN> *****/
static void
new_table (GtkWidget *table, int rows, int cols, gpointer* data)
{
	printf("rows: %d, cols: %d\n", rows, cols);
}
/***** </MARTIN> *****/

static void
menuitem_cb (gpointer             callback_data,
             guint                callback_action,
             GtkWidget           *widget)
{
}

static GtkItemFactoryEntry menu_items[] =
{
	{ "/_File",            NULL,         0,                     0, "<Branch>" },
	{ "/File/_New",        "<control>N", menuitem_cb,       0, "<StockItem>", GTK_STOCK_NEW },
	{ "/File/_Open",       "<control>O", menuitem_cb,       0, "<StockItem>", GTK_STOCK_OPEN },
	{ "/File/_Save",       "<control>S", menuitem_cb,       0, "<StockItem>", GTK_STOCK_SAVE },
	{ "/File/Save _As...", NULL,         menuitem_cb,       0, "<StockItem>", GTK_STOCK_SAVE },
	{ "/File/sep1",        NULL,         menuitem_cb,       0, "<Separator>" },
	{ "/File/_Quit",       "<control>Q", menuitem_cb,       0, "<StockItem>", GTK_STOCK_QUIT },

	{ "/_Preferences",                    NULL, 0,               0, "<Branch>" },
	{ "/_Preferences/_Color",             NULL, 0,               0, "<Branch>" },
	{ "/_Preferences/Color/_Red",         NULL, menuitem_cb, 0, "<RadioItem>" },
	{ "/_Preferences/Color/_Green",       NULL, menuitem_cb, 0, "/Preferences/Color/Red" },
	{ "/_Preferences/Color/_Blue",        NULL, menuitem_cb, 0, "/Preferences/Color/Red" },
	{ "/_Preferences/_Shape",             NULL, 0,               0, "<Branch>" },
	{ "/_Preferences/Shape/_Square",      NULL, menuitem_cb, 0, "<RadioItem>" },
	{ "/_Preferences/Shape/_Rectangle",   NULL, menuitem_cb, 0, "/Preferences/Shape/Square" },
	{ "/_Preferences/Shape/_Oval",        NULL, menuitem_cb, 0, "/Preferences/Shape/Rectangle" },

	/* If you wanted this to be right justified you would use "<LastBranch>", not "<Branch>".
	 * Right justified help menu items are generally considered a bad idea now days.
	 */
	{ "/_Help",            NULL,         0,                     0, "<Branch>" },
	{ "/Help/_About",      NULL,         menuitem_cb,       0 },
};

static void
toolbar_cb (GtkWidget *button,
            gpointer   data)
{
	gtk_main_quit();
}

static void
update_statusbar (GtkTextBuffer *buffer,
                  GtkStatusbar  *statusbar)
{
	gchar *msg;
	gint row, col;
	gint count;
	GtkTextIter iter;
  
	gtk_statusbar_pop (statusbar, 0); /* clear any previous message, underflow is allowed */

	count = gtk_text_buffer_get_char_count (buffer);

	gtk_text_buffer_get_iter_at_mark (buffer,
					  &iter,
					  gtk_text_buffer_get_insert (buffer));

	row = gtk_text_iter_get_line (&iter);
	col = gtk_text_iter_get_line_offset (&iter);

	msg = g_strdup_printf ("Cursor at row %d column %d - %d chars in document",
			       row, col, count);

	gtk_statusbar_push (statusbar, 0, msg);

	g_free (msg);
}

static void
mark_set_callback (GtkTextBuffer     *buffer,
                   const GtkTextIter *new_location,
                   GtkTextMark       *mark,
                   gpointer           data)
{
	update_statusbar (buffer, GTK_STATUSBAR (data));
}

GtkWidget *
do_appwindow (void)
{  
	if (!window)
	{
		GtkWidget *abi_table;
		GtkWidget *table;
		GtkWidget *toolbar;
		GtkWidget *statusbar;
		GtkWidget *contents;
		GtkWidget *sw;
		GtkTextBuffer *buffer;
		GtkAccelGroup *accel_group;      
		GtkItemFactory *item_factory;

		/* Create the toplevel window
		 */
      
		window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title (GTK_WINDOW (window), "Application Window");

		/* NULL window variable when window is closed */
		g_signal_connect (G_OBJECT (window), "destroy",
				  G_CALLBACK (gtk_widget_destroyed),
				  &window);

		table = gtk_table_new (1, 4, FALSE);
      
		gtk_container_add (GTK_CONTAINER (window), table);
      
		/* Create the menubar
		 */
      
		accel_group = gtk_accel_group_new ();
		gtk_window_add_accel_group (GTK_WINDOW (window), accel_group);
		g_object_unref (accel_group);
      
		item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);

		/* Set up item factory to go away with the window */
		g_object_ref (item_factory);
		gtk_object_sink (GTK_OBJECT (item_factory));
		g_object_set_data_full (G_OBJECT (window),
					"<main>",
					item_factory,
					(GDestroyNotify) g_object_unref);

		/* create menu items */
		gtk_item_factory_create_items (item_factory, G_N_ELEMENTS (menu_items),
					       menu_items, window);

		gtk_table_attach (GTK_TABLE (table),
				  gtk_item_factory_get_widget (item_factory, "<main>"),
				  /* X direction */          /* Y direction */
				  0, 1,                      0, 1,
				  GTK_EXPAND | GTK_FILL,     0,
				  0,                         0);

		/* Create the toolbar
		 */
		toolbar = gtk_toolbar_new ();

		/***** <MARTIN> *****/
		abi_table = abi_table_new ();

		g_signal_connect_object (abi_table, "selected",
					 G_CALLBACK (new_table), NULL, 0);

		abi_table_embed_on_toolbar(ABI_TABLE(abi_table), GTK_TOOLBAR(toolbar));
		/***** </MARTIN> *****/
		
		gtk_toolbar_insert_stock (GTK_TOOLBAR (toolbar),
					  GTK_STOCK_QUIT,
					  "This is a demo button with a 'quit' icon",
					  NULL,
					  G_CALLBACK (toolbar_cb),
					  window, /* user data for callback */
					  -1);  /* -1 means "append" */

		gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

		gtk_table_attach (GTK_TABLE (table),
				  toolbar,
				  /* X direction */       /* Y direction */
				  0, 1,                   1, 2,
				  GTK_EXPAND | GTK_FILL,  0,
				  0,                      0);

		/* Create document
		 */

		sw = gtk_scrolled_window_new (NULL, NULL);

		gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw),
						GTK_POLICY_AUTOMATIC,
						GTK_POLICY_AUTOMATIC);

		gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw),
						     GTK_SHADOW_IN);
      
		gtk_table_attach (GTK_TABLE (table),
				  sw,
				  /* X direction */       /* Y direction */
				  0, 1,                   2, 3,
				  GTK_EXPAND | GTK_FILL,  GTK_EXPAND | GTK_FILL,
				  0,                      0);

		gtk_window_set_default_size (GTK_WINDOW (window),
					     200, 200);
      
		contents = gtk_text_view_new ();

		gtk_container_add (GTK_CONTAINER (sw),
				   contents);

		/* Create statusbar */

		statusbar = gtk_statusbar_new ();
		gtk_table_attach (GTK_TABLE (table),
				  statusbar,
				  /* X direction */       /* Y direction */
				  0, 1,                   3, 4,
				  GTK_EXPAND | GTK_FILL,  0,
				  0,                      0);

		/* Show text widget info in the statusbar */
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (contents));
      
		g_signal_connect_object (buffer,
					 "changed",
					 G_CALLBACK (update_statusbar),
					 statusbar,
					 0);

		g_signal_connect_object (buffer,
					 "mark_set", /* cursor moved */
					 G_CALLBACK (mark_set_callback),
					 statusbar,
					 0);
      
		update_statusbar (buffer, GTK_STATUSBAR (statusbar));
	}

	if (!GTK_WIDGET_VISIBLE (window))
	{
		gtk_widget_show_all (window);
	}
	else
	{    
		gtk_widget_destroy (window);
		window = NULL;
	}

	return window;
}

int
main(int argc, char* argv[])
{
	GtkWidget *main_window;
/*  GtkWidget *drawing_area; */
 
	gtk_init (&argc, &argv);
	main_window = do_appwindow();
  
	gtk_widget_show_all(main_window);

	gtk_main ();

	return(0);
}
