/*
 * Copyright 2006 The Apache Software Foundation or its licensors, as
 * applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef ITransport_hpp_
#define ITransport_hpp_

#include "core/ICommand.hpp"
#include "core/FutureResponse.hpp"
#include "commands/Response.hpp"

namespace openwire
{
  namespace client
  {
    namespace core
    {
      using openwire::client::commands::Response;

/*
 * Represents the logical networking transport layer
 */
struct ITransport
{
	virtual void oneway(ICommand* command) = 0 ;
	virtual FutureResponse* asyncRequest(ICommand* command) = 0 ;
	virtual Response* request(ICommand* command) = 0 ;
} ;

/* namespace */
    }
  }
}

#endif /*ITransport_hpp_*/
