/*
 * Copyright 2006 The Apache Software Foundation or its licensors, as
 * applicable.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef SocketTransport_hpp_
#define SocketTransport_hpp_

#include <apr_general.h>
#include <apr_pools.h>
#include <apr_hash.h>
#include <apr_network_io.h>
#include <apr_thread_proc.h>
#include <apr_thread_mutex.h>

#include "commands/Response.hpp"
#include "core/FutureResponse.hpp"
#include "core/ITransport.hpp"
#include "core/ICommand.hpp"
#include "core/SocketReader.hpp"
#include "core/SocketWriter.hpp"

namespace openwire
{
  namespace client
  {
    namespace core
    {
      using openwire::client::commands::Response;

/*
 * An implementation of ITransport that uses sockets to communicate with
 * the broker.
 */
class SocketTransport : public ITransport
{
private:
    SocketReader       *socketReader ;
    SocketWriter       *socketWriter ;
    apr_pool_t         *memoryPool ;
    apr_thread_mutex_t *transmissionLock ;
    apr_socket_t       *socket ;
    apr_sockaddr_t     *local_sa, *remote_sa ;
    char               *local_ip, *remote_ip ;
    apr_thread_t       *readThread ;
    apr_hash_t         *requestMap ;
    bool               closed ;
    long               nextCommandId ;
    
public:
    SocketTransport(const char* host, int port) ;
    virtual ~SocketTransport() ;

    virtual void oneway(ICommand* command) ;
    virtual FutureResponse* asyncRequest(ICommand* command) ;
    virtual Response* request(ICommand* command) ;

protected:
    virtual void init() ;
    virtual void send(ICommand* command) ;
    virtual long getNextCommandId() ;
    virtual apr_socket_t* connect(const char* host, int port) ;

private:
    static void* APR_THREAD_FUNC readLoop(apr_thread_t *thread, void *data) ;
} ;

/* namespace */
    }
  }
}

#endif /*SocketTransport_hpp_*/
