/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.runtime.reflect;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.StringMaker;

abstract class SignatureImpl
implements Signature {
    int modifiers = -1;
    String name;
    Class declaringType;
    String stringRep;
    ClassLoader lookupClassLoader = null;
    static final char SEP = '-';
    static Hashtable prims = new Hashtable();
    static String[] EMPTY_STRING_ARRAY;
    static Class[] EMPTY_CLASS_ARRAY;
    static final String INNER_SEP = ":";
    static /* synthetic */ Class class$java$lang$ClassNotFoundException;

    SignatureImpl(int n, String string, Class clazz) {
        this.modifiers = n;
        this.name = string;
        this.declaringType = clazz;
    }

    abstract String toString(StringMaker var1);

    public final String toString() {
        return this.toString(StringMaker.middleStringMaker);
    }

    public final String toShortString() {
        return this.toString(StringMaker.shortStringMaker);
    }

    public final String toLongString() {
        return this.toString(StringMaker.longStringMaker);
    }

    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = this.extractInt(0);
        }
        return this.modifiers;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.extractString(1);
        }
        return this.name;
    }

    public Class getDeclaringType() {
        if (this.declaringType == null) {
            this.declaringType = this.extractType(2);
        }
        return this.declaringType;
    }

    String fullTypeName(Class clazz) {
        if (clazz == null) {
            return "ANONYMOUS";
        }
        if (clazz.isArray()) {
            return this.fullTypeName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName().replace('$', '.');
    }

    String stripPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    String shortTypeName(Class clazz) {
        if (clazz == null) {
            return "ANONYMOUS";
        }
        if (clazz.isArray()) {
            return this.shortTypeName(clazz.getComponentType()) + "[]";
        }
        return this.stripPackageName(clazz.getName()).replace('$', '.');
    }

    void addFullTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.fullTypeName(classArray[n]));
            ++n;
        }
    }

    void addShortTypeNames(StringBuffer stringBuffer, Class[] classArray) {
        int n = 0;
        while (n < classArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.shortTypeName(classArray[n]));
            ++n;
        }
    }

    void addTypeArray(StringBuffer stringBuffer, Class[] classArray) {
        this.addFullTypeNames(stringBuffer, classArray);
    }

    public void setLookupClassLoader(ClassLoader classLoader) {
        this.lookupClassLoader = classLoader;
    }

    private ClassLoader getLookupClassLoader() {
        if (this.lookupClassLoader == null) {
            this.lookupClassLoader = this.getClass().getClassLoader();
        }
        return this.lookupClassLoader;
    }

    public SignatureImpl(String string) {
        this.stringRep = string;
    }

    String extractString(int n) {
        int n2 = 0;
        int n3 = this.stringRep.indexOf(45);
        while (n-- > 0) {
            n2 = n3 + 1;
            n3 = this.stringRep.indexOf(45, n2);
        }
        if (n3 == -1) {
            n3 = this.stringRep.length();
        }
        return this.stringRep.substring(n2, n3);
    }

    int extractInt(int n) {
        String string = this.extractString(n);
        return Integer.parseInt(string, 16);
    }

    Class extractType(int n) {
        String string = this.extractString(n);
        return this.makeClass(string);
    }

    Class makeClass(String string) {
        if (string.equals("*")) {
            return null;
        }
        Class clazz = (Class)prims.get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.getLookupClassLoader().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return class$java$lang$ClassNotFoundException == null ? (class$java$lang$ClassNotFoundException = SignatureImpl.class$("java.lang.ClassNotFoundException")) : class$java$lang$ClassNotFoundException;
        }
    }

    String[] extractStrings(int n) {
        String string = this.extractString(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, INNER_SEP);
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = stringTokenizer.nextToken();
            ++n3;
        }
        return stringArray;
    }

    Class[] extractTypes(int n) {
        String string = this.extractString(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, INNER_SEP);
        int n2 = stringTokenizer.countTokens();
        Class[] classArray = new Class[n2];
        int n3 = 0;
        while (n3 < n2) {
            classArray[n3] = this.makeClass(stringTokenizer.nextToken());
            ++n3;
        }
        return classArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        prims.put("void", Void.TYPE);
        prims.put("boolean", Boolean.TYPE);
        prims.put("byte", Byte.TYPE);
        prims.put("char", Character.TYPE);
        prims.put("short", Short.TYPE);
        prims.put("int", Integer.TYPE);
        prims.put("long", Long.TYPE);
        prims.put("float", Float.TYPE);
        prims.put("double", Double.TYPE);
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_CLASS_ARRAY = new Class[0];
    }
}

