#!/bin/bash

# script: genXML for the jhALFS project
# version: 0.2
# license: GPL 2.x or up
# authors: George Makrydakis <gmakmail - at - gmail.com>
# infnote: to be fused with the renewed x2sh into a single x2sh entity!

declare -a farray
declare -a fstore
declare -i _store=0
declare -i lcnt=0
declare -i collectSTART=0
declare -i collectSTOP=0
declare -r _isTAG="userinput"
declare _auth
declare _matchthis="$_isTAG"
declare _shrtmatch
declare _longmatch
declare -i sz_befor=0
declare -i sz_after=0
declare -i sz_position=0
declare -a stringstack=();


declare -a chapterlist=(chapter01 \
			chapter02 \
			chapter03 \
			chapter04 \
			chapter05 \
			chapter06 \
			chapter07 \
			chapter08 \
			chapter09);

for selectchapter in ${chapterlist[@]}
do
	cd $selectchapter
		for filenameinput in *.xml
		do
			while read farray[lcnt]
			do
				((lcnt++))
			done < "$filenameinput"

			filenameinput=${filenameinput%%.xml}
			fstore[_store]="<$filenameinput chapterID="'"'"$selectchapter"'"'">"
			((_store++))
		for ((lcnt=0; lcnt < ${#farray[@]}; lcnt++));
		do
			
		case ${farray[lcnt]} in
		
			*\<${_isTAG}\>*)
		
				if [[ "${farray[lcnt]}" =~ "</$_isTAG>" ]] ;	   
				then
					_auth="${farray[lcnt]}"
					_shrtmatch="${farray[lcnt]}"
					_longmatch="${_auth##*$_matchthis}"
					while [ "$_shrtmatch" != "$_longmatch" ] ;
					do
						sz_befor=${#_shrtmatch}
						_shrtmatch="${_shrtmatch#*$_matchthis}"
						sz_after=${#_shrtmatch}
						sz_position=$((sz_position + sz_befor - sz_after))
						stringstack=(${stringstack[@]} $((sz_position - ${#_matchthis})));
					done
					firstTAGmet=${_auth:$((${stringstack[0]} - 1)):1}
					lasttTAGmet=${_auth:$((${stringstack[$((${#stringstack[@]} - 1))]} - 1)):1}
					sz_position=0; stringstack=(); #FIXME: stringstack is a "backport" - PENDING!
					case "$firstTAGmet""!""$lasttTAGmet" in
						'<!/')	# trim start + end, FIXME: in between? - PENDING!
							# The LFS book only has 2 (two) tags like userinput / line
							farray[lcnt]="${farray[lcnt]#*$_isTAG}"
							farray[lcnt]="${farray[lcnt]%$_isTAG*}"
							fstore[_store]="<$_isTAG""${farray[lcnt]}""$_isTAG>"
							((_store++))
						;;
						'/!/')	# trim only end, FIXME: in between ? - PENDING!
							# The LFS book only has 2 (two) tags like userinput / line
							farray[lcnt]="${farray[lcnt]%$_isTAG*}"
							fstore[_store]="${farray[lcnt]}""$_isTAG>"
							((_store++))
						;;
						'/!<')	# trim NOTHING, FIXME: in between? - PENDING!
							# The LFS book only has 2 (two) tags like userinput / line
							fstore[_store]="${farray[lcnt]}"
							((collectSTART = lcnt + 1))
							((_store++))
						;;
						'<!<')	# trim only start, FIXME: in between ? - PENDING!
							# The LFS book only has 2 (two) tags like userinput / line
							farray[lcnt]="${farray[lcnt]#*$_isTAG}"
							fstore[_store]="<$_isTAG""${farray[lcnt]}"
							((_store++))
						;;
					esac
				elif [[ ! "${farray[lcnt]}" =~ "</$_isTAG>" ]] ;
				then
					farray[lcnt]="${farray[lcnt]#*$_isTAG}"
					fstore[_store]="<$_isTAG""${farray[lcnt]}"
					((_store++)); ((collectSTART = lcnt + 1))
				fi
				;;
			*\</${_isTAG}\>*)
				if [[  "${farray[lcnt]}" =~ "</$_isTAG>" ]] ;
				then
					collectSTOP=lcnt
					((lcnt++))
					if [ $((collectSTOP - collectSTART)) -ge 0 ] ;
						then
						for ((addthis=$collectSTART; addthis < $collectSTOP; addthis++));
						do
							fstore[_store]="${farray[addthis]}"
							((_store++))
						done
						farray[collectSTOP]="${farray[collectSTOP]%$_isTAG*}"
						fstore[_store]="${farray[collectSTOP]}$_isTAG>"
						((_store++))
					fi
					collectSTOP=0; collectSTART=0
				fi
				;;
		esac
		done
		farray=(); lcnt=0
		fstore[_store]="</$filenameinput>"
		((_store++))
	done
	cd ..
done

function printallout ()
{
echo "<jhLFSroot>"
for ((_store=0; _store < ${#fstore[@]}; _store++));
do
	printf "%s\n" "${fstore[_store]}"
done
echo "</jhLFSroot>"
}

printallout
