#!/bin/bash

# x2sh booster - for the x2sh component to the jhalfs project
# author: George Makrydakis > gmakmail a|t gmail d0t c0m <
# license: GPL 2.0 or up
# revision: A1-print-nocomment
# instructions: run in the LFS book root

	declare -a x2SHraw
	declare -a x2SHchapters=(chapter01 \
				chapter02 \
				chapter03 \
				chapter04 \
				chapter05 \
				chapter06 \
				chapter07 \
				chapter08 \
				chapter09);
				
	declare -i x2SHindex=0
	declare -i lcnt=0

	declare  x2SHfile
	declare  originalsize

	declare otag
	declare ctag
	declare mpnt1
	declare mpnt2
	declare srcvar

	for x2SHpart in ${x2SHchapters[@]}
	do
		cd $x2SHpart
	for x2SHfile in *.xml
	do
		x2SHraw=(); lcnt=0;
		while read x2SHraw[lcnt]
		do
			((lcnt++))
		done <"$x2SHfile"

	for ((lcnt=0; lcnt < ${#x2SHraw[@]}; lcnt++));
	do
		case ${x2SHraw[lcnt]} in
			'')
			;;
			*)
				case ${x2SHraw[lcnt]} in
					*\<*)
						if [  "${x2SHraw[lcnt]%%<*}" != "" ] ; then
							printf "%s\n" "${x2SHraw[lcnt]%%<*}"
						fi
					;;
					*)
						if [ "${x2SHraw[lcnt]#>}" = "${x2SHraw[lcnt]}" ] ; then
							printf "%s\n" "${x2SHraw[lcnt]}"
						fi
					;;
				esac

			;;
		esac

		mpnt1="${x2SHraw[lcnt]}"
		mpnt2="${x2SHraw[lcnt]}"
		originalsize="${#x2SHraw[lcnt]}"

		until [ "$mpnt1" = "${x2SHraw[lcnt]##*<}" ] && \
		      [ "$mpnt2" = "${x2SHraw[lcnt]##*>}" ] ;	
		do
			mpnt1=${mpnt1#*<}; mpnt2=${mpnt2#*>}
			otag=$((originalsize - ${#mpnt1} - 1))
			ctag=$((originalsize - ${#mpnt2} - otag))
			if [ $ctag -ge 0 ] ; then
				printf "%s\n" "${x2SHraw[lcnt]:$otag:$ctag}"
				srcvar="$mpnt1"; srcvar="${srcvar#*>}"; srcvar="${srcvar%%<*}"
				case "$srcvar" in
					'')
					;;
					*)
						printf "%s\n" "$srcvar"
						srcvar=""
					;;
					
				esac
			elif [ $ctag -lt 0 ] ; then
				x2SHraw[$((lcnt + 1))]="<""${x2SHraw[lcnt]##*<}"" ${x2SHraw[$((lcnt + 1))]}"
				break
			fi
		done
	done
done
cd ..
done

