/*
 * usbmidi.c - ALSA USB US-428 Firmware Download driver
 *
 * Copyright (c) 2002 Karsten Wiese
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed and/or modified under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


struct us428_control{
	unsigned short TransferBuLe;
	unsigned char  TransferBuffer[ 16];
	unsigned char  Request;
	unsigned short Value;
};


struct us428_control us428_firmware[ 602] = {
#include "usbsnoop.log"
};






/*
 * Probes for a supported device.
 */
int main( )
{
	int	i, err;

	printf( "decoding hex\n");


	for( i = 0; i < ( sizeof(us428_firmware)/sizeof(struct us428_control)); ++i){
	  int j,k;
	  char bu[ 8];
	 
	  printf( "transfer type=control dir=out timeout=1000 requesttype=0x40 request=0xa0 value=0x%X size=0x%X\n",
		  (int)us428_firmware[ i].Value,
		  j = (int)us428_firmware[ i].TransferBuLe
	  );
		   if( j){
		     k = 0;
		     do{
		       printf( "%02X ", (int)us428_firmware[ i].TransferBuffer[ k]);
		     }while( ++k < j);
		     printf( "\n");
		   }


/*			{
			signed long T = HZ / 50;
				set_current_state( TASK_UNINTERRUPTIBLE);
				while( T = schedule_timeout( T));
			return NULL;	 
			}*/
			
	}
	printf( "quit\n");

	
	return 0;
}

