package org.apache.tools.ant.taskdefs.optional.scm.writer;
/**
 * ============================================================================
 *                   The Apache Software License, Version 1.1
 * ============================================================================
 * 
 *    Copyright (C) 2000-2002 The Apache Software Foundation. All
 *    rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modifica-
 * tion, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of  source code must  retain the above copyright  notice,
 *    this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * 3. The end-user documentation included with the redistribution, if any, must
 *    include  the following  acknowledgment:  "This product includes  software
 *    developed  by the  Apache Software Foundation  (http://www.apache.org/)."
 *    Alternately, this  acknowledgment may  appear in the software itself,  if
 *    and wherever such third-party acknowledgments normally appear.
 * 
 * 4. The names "Ant" and  "Apache Software Foundation"  must not be used to
 *    endorse  or promote  products derived  from this  software without  prior
 *    written permission. For written permission, please contact
 *    apache@apache.org.
 * 
 * 5. Products  derived from this software may not  be called "Apache", nor may
 *    "Apache" appear  in their name,  without prior written permission  of the
 *    Apache Software Foundation.
 * 
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
 * APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
 * DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
 * ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
 * (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * This software  consists of voluntary contributions made  by many individuals
 * on behalf of the  Apache Software Foundation.  For more  information  on the 
 * Apache Software Foundation, please see <http://www.apache.org/>.
 *
 */

import com.starbase.starteam.ChangeRequest;
import com.starbase.starteam.User;
import com.starbase.starteam.Folder;
import com.starbase.starteam.File;
import com.starbase.starteam.Server;
import java.io.IOException;

/**
 * Interface that will need to be extended to create your own log writers.
 * @author Kevin Landry <A href="mailto:klandry@ceira.com">klandry@ceira.com</A>
 */
public interface ChangeLogWriter {
	
	/**
	 * Set the name of this log file.
	 * @param name log file name
	 */
  public void setLogName( String name );
  
  /**
   * Opens the file for writing.
   * @throws IOException if an error occured while opening/creating the file.
   */
  public void openFile() throws IOException;
  
  /**
   * Writes any header information for the file
   * @param starTeam server object
   * @param info build label text
   * @throws IOException if an error occured while writing
   */
  public void writeHeader(Server starTeam, String info) throws IOException;
  
  /**
   * Writes a change request to the log
   * @param folder Star Team Folder
   * @param cr Change Request to be written
   * @param user Owner of change request
   * @throws IOException if an error occured while writing
   */
  public void writeCR( Folder folder, ChangeRequest cr, User user) throws IOException;
  
  /**
   * Writes the revision information since the last label.
   * @param dir Star Team Folder
   * @param files revision files to be written
   * @param starTeam server object
   * @throws IOException if an error occured while writing
   */
  public void writeRevision( Folder dir, File[] files, Server starTeam ) throws IOException;
  
  /**
   * Writes to the log the newly checked in file
   * @param dir Star Team Folder
   * @param file new file that was checked in
   * @param starTeam server object
   * @throws IOException if an error occured while writing
   */
  public void writeFileAdded( Folder dir, File file, Server starTeam ) throws IOException;
  
  /**
   * Writes to the log that a file was removed from this label.
   * @param dir Star Team Folder
   * @param file file that was removed
   * @param starTeam server information
   * @throws IOException if an error occured while writing
   */
  public void writeFileDeleted( Folder dir, File file, Server starTeam ) throws IOException;
  
  /**
   * Writes the footer information to the change log
   * @throws IOException if an error occured while writing
   */
  public void writeFooter() throws IOException;
  
  /**
   * Closes the change log
   * @throws IOException if an error occured while writing
   */
  public void closeFile() throws IOException;
}
