/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.ClassFileInputStream;
import org.apache.tools.analyzer.HashedVector;
import org.apache.tools.analyzer.IStatusListener;
import org.apache.tools.analyzer.LoadItem;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.ClassInfo;

public class ClassLoad {
    public UniqueVector fileList;
    private static int FOUND = 5;
    private static int NOTFOUND = 15;
    private static int ERROR = 25;
    public static int pky = 0;
    private int n = 0;
    private boolean messageShown = false;
    private IStatusListener statusListener;
    private HashedVector unitInformation;

    public ClassLoad(HashedVector hashedVector, IStatusListener iStatusListener) {
        this.unitInformation = hashedVector;
        this.statusListener = iStatusListener;
    }

    private ClassFileInputStream getStream(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return ClassFileInputStream.getMyDataInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    private boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public boolean load() {
        this.n = 0;
        return this.loadAllClasses();
    }

    private boolean loadAllClasses() {
        return this.loadAllClassesFromSet(this.fileList);
    }

    public boolean loadAllClassesFromSet(UniqueVector uniqueVector) {
        int n = 0;
        while (n < uniqueVector.size()) {
            boolean bl;
            LoadItem loadItem = (LoadItem)uniqueVector.elementAt(n);
            File file = new File(loadItem.name);
            if (file == null ? !AnalyzerUtilities.twoChoiceBox("Specified file or directory " + loadItem.name + " not found") : !(bl = this.isDirectory(file) ? this.loadClassesFromDirectory(file, loadItem.name, loadItem.includeSubDirs) : ("class".equals(AnalyzerUtilities.fileExtension(loadItem.name)) ? this.loadClassFromFile(loadItem.name) : AnalyzerUtilities.twoChoiceBox("Specified item " + loadItem.name + " not found or not .class, .zip, .jar or directory")))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean loadClass(ClassFileInputStream classFileInputStream, String string, boolean bl) {
        ++this.n;
        if (this.statusListener != null) {
            this.statusListener.status("Loading " + string);
        }
        ClassInfo classInfo = new ClassInfo(this.unitInformation, string, classFileInputStream, this, bl);
        boolean bl2 = classInfo.load();
        if (classFileInputStream != null) {
            if (classFileInputStream.close()) {
                return bl2;
            }
            return false;
        }
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    public boolean loadClassByName(String var1_1) {
        var1_1 = AnalyzerUtilities.removeExtension(var1_1);
        var2_2 = this.fileList;
        if (var2_2.size() == 0) {
            AnalyzerUtilities.alert("Path list to search for classes is empty");
            return false;
        }
        var3_3 = 0;
        while (var3_3 < var2_2.size()) {
            block9: {
                block10: {
                    block8: {
                        var4_4 = (LoadItem)var2_2.elementAt(var3_3);
                        var5_5 = new File(var4_4.name);
                        if (var5_5 != null) break block8;
                        if (!AnalyzerUtilities.twoChoiceBox("Specified file or directory " + var4_4.name + " not found")) {
                            return false;
                        }
                        break block9;
                    }
                    if (!var5_5.isDirectory()) break block10;
                    var6_6 = this.loadClassFromDirectoryByName(var5_5, var4_4.name, var4_4.includeSubDirs, var1_1);
                    ** GOTO lbl24
                }
                if (!"class".equals(AnalyzerUtilities.fileExtension(var4_4.name))) {
                    if (!AnalyzerUtilities.twoChoiceBox("Specified item " + var4_4.name + " not .class, .zip, .jar or directory")) {
                        return false;
                    }
                } else {
                    var6_6 = this.loadClassFromFileByNameWithStream(var4_4.name, var1_1, null);
lbl24:
                    // 2 sources

                    if (var6_6 == ClassLoad.ERROR) {
                        return false;
                    }
                    if (var6_6 != ClassLoad.NOTFOUND && var6_6 == ClassLoad.FOUND) {
                        return true;
                    }
                }
            }
            ++var3_3;
        }
        return false;
    }

    private int loadClassFromDirectoryByName(File file, String string, boolean bl, String string2) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return NOTFOUND;
        }
        String string3 = String.valueOf(AnalyzerUtilities.makeFileNameFromJavaName(string2)) + ".class";
        String string4 = AnalyzerUtilities.makeFullName(string, string3);
        File file2 = new File(string4);
        if (file2 == null && !AnalyzerUtilities.twoChoiceBox("Error accessing " + string4)) {
            return ERROR;
        }
        ClassFileInputStream classFileInputStream = this.getStream(string4);
        if (classFileInputStream != null) {
            int n = this.loadClassFromFileByNameWithStream(string4, string2, classFileInputStream);
            if (n == ERROR) {
                return ERROR;
            }
            if (n == NOTFOUND) {
                AnalyzerUtilities.alert("LoadClassFromDirectoryByName: Error 1001");
                return ERROR;
            }
            if (n == FOUND) {
                return FOUND;
            }
        } else {
            int n = 0;
            while (n < stringArray.length) {
                String string5 = AnalyzerUtilities.makeFullName(string, stringArray[n]);
                file2 = new File(string5);
                if (file2 == null) {
                    if (!AnalyzerUtilities.twoChoiceBox("Error accessing " + string5)) {
                        return ERROR;
                    }
                } else if (file2.isDirectory() && bl) {
                    int n2 = this.loadClassFromDirectoryByName(file2, string5, true, string2);
                    if (n2 == ERROR) {
                        return ERROR;
                    }
                    if (n2 == FOUND) {
                        return FOUND;
                    }
                }
                ++n;
            }
        }
        return NOTFOUND;
    }

    private boolean loadClassFromFile(String string) {
        ClassFileInputStream classFileInputStream = this.getStream(string);
        if (classFileInputStream == null) {
            return AnalyzerUtilities.twoChoiceBox("Error accessing " + string);
        }
        return this.loadClass(classFileInputStream, string, false);
    }

    private int loadClassFromFileByNameWithStream(String string, String string2, ClassFileInputStream classFileInputStream) {
        if (classFileInputStream == null) {
            classFileInputStream = this.getStream(string);
        }
        if (AnalyzerUtilities.nameCompatible(string, string2)) {
            if (this.loadClass(classFileInputStream, string, true)) {
                return FOUND;
            }
            return ERROR;
        }
        return NOTFOUND;
    }

    private boolean loadClassesFromDirectory(File file, String string, boolean bl) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = AnalyzerUtilities.makeFullName(string, stringArray[n]);
            File file2 = new File(string2);
            if (file2 == null && !AnalyzerUtilities.twoChoiceBox("Error accessing " + string2)) {
                return false;
            }
            if (file2.isDirectory() ? bl && !this.loadClassesFromDirectory(file2, string2, true) : "class".equals(AnalyzerUtilities.fileExtension(string2)) && !this.loadClassFromFile(string2)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

