/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.util.Vector;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.ReachableBlock;
import org.apache.tools.analyzer.Statement;
import org.apache.tools.analyzer.TargetSet;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;

public class CodeBlock {
    private static final boolean debug = false;
    public static final String unitTab = "   ";
    public UniqueVector subBlocks = new UniqueVector();
    public CodeBlock entry = null;
    public CodeBlock superBlock = null;
    public String type;
    public UniqueVector nextBlockList = new UniqueVector(2, 2);
    public UniqueVector orderNextList = new UniqueVector(2, 2);
    public UniqueVector orderPrevList = new UniqueVector(2, 2);
    public UniqueVector targetSets;
    public CodeBlock nextBlock = null;
    public UniqueVector breakPlaces = new UniqueVector(2, 2);
    public ReachableBlock loopSwitchBreak = null;
    public ReachableBlock continueBlock = null;
    public boolean namedBlock = false;
    public String blockLabel;
    public boolean synch = false;
    public Instruction first = null;
    public Instruction last = null;
    public boolean search;
    public boolean processed;
    public UniqueVector initializers = new UniqueVector(1, 1);

    public CodeBlock(String string) {
        this.type = string;
    }

    public CodeBlock(Instruction instruction, Instruction instruction2, String string, CodeBlock codeBlock) {
        this.first = instruction;
        this.last = instruction2;
        this.type = string;
        Instruction instruction3 = this.first;
        while (true) {
            instruction3.enclosingCodeBlock = this;
            if (instruction3.equals(this.last)) break;
            instruction3 = instruction3.theNextInstruction();
        }
    }

    public void addNextBlockList(CodeBlock codeBlock) {
        if (!this.nextBlockList.contains(codeBlock)) {
            this.nextBlockList.addElement(codeBlock);
        }
    }

    public void addSubBlock(CodeBlock codeBlock) {
        this.subBlocks.addElement(codeBlock);
        codeBlock.superBlock = this;
    }

    public int allInstructionsBetween(int n, int n2, boolean bl) throws DecompilerException {
        if (!this.simple()) {
            throw new DecompilerException(8203);
        }
        Instruction instruction = this.first;
        int n3 = -1;
        while (true) {
            int n4 = n > instruction.location || n2 <= instruction.location ? 3 : 2;
            if (n3 < 0) {
                n3 = n4;
            } else if (n3 != n4) {
                return 1;
            }
            if (bl) {
                AnalyzerUtilities.p("current is " + instruction.toString());
            }
            if (instruction.equals(this.last)) {
                return n3;
            }
            if (instruction.nextInstructionList.size() != 1 && !instruction.equals(this.last)) {
                throw new DecompilerException(8205);
            }
            instruction = (Instruction)instruction.nextInstructionList.elementAt(0);
        }
    }

    public int complexity() {
        if (this.simple()) {
            return this.numberOfStatements() + this.nextBlockList.size();
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.subBlocks.size()) {
            n += ((CodeBlock)this.subBlocks.elementAt(n2)).complexity();
            ++n2;
        }
        return n + this.subBlocks.size();
    }

    private boolean containedInBreaks(CodeBlock codeBlock) {
        int n = 0;
        while (n < this.breakPlaces.size()) {
            ReachableBlock reachableBlock = (ReachableBlock)this.breakPlaces.elementAt(n);
            if (reachableBlock.block == codeBlock) {
                return true;
            }
            ++n;
        }
        if (this.loopSwitchBreak != null && this.loopSwitchBreak.block == codeBlock) {
            return true;
        }
        return this.continueBlock != null && this.continueBlock.block == codeBlock;
    }

    public boolean containsAll(UniqueVector uniqueVector) {
        int n = 0;
        while (n < uniqueVector.size()) {
            if (!this.containsAsSubBlock((CodeBlock)uniqueVector.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean containsAsSubBlock(CodeBlock codeBlock) {
        int n = 0;
        while (n < this.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)this.subBlocks.elementAt(n);
            if (codeBlock2.equals(codeBlock)) {
                return true;
            }
            if (!codeBlock2.simple() && codeBlock2.containsAsSubBlock(codeBlock)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsDirectly(CodeBlock codeBlock) {
        int n = 0;
        while (n < this.subBlocks.size()) {
            if (((CodeBlock)this.subBlocks.elementAt(n)).equals(codeBlock)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsInstruction(Instruction instruction) {
        if (this.simple()) {
            Instruction instruction2 = this.first;
            while (true) {
                if (instruction2.equals(instruction)) {
                    return true;
                }
                if (!instruction2.equals(this.last)) {
                    instruction2 = instruction2.theNextInstruction();
                    continue;
                }
                break;
            }
        } else {
            int n = 0;
            while (n < this.subBlocks.size()) {
                CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n);
                if (codeBlock.containsInstruction(instruction)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    private String description() {
        if (this.type == "LOOP") {
            return "LOOP ";
        }
        if (this.type == "IFTRUE") {
            return "IF TRUE ";
        }
        if (this.type == "IFFALSE") {
            return "IF FALSE ";
        }
        if (this.simple()) {
            return "SIMPLE ";
        }
        if (this.type == "TRY") {
            return "TRY ";
        }
        if (this.type == "CATCH") {
            return "CATCH ";
        }
        if (this.type == "TRYCATCHFINALLY") {
            return "TRYCATCH ";
        }
        if (this.type == "FINALLY") {
            return "FINALLY ";
        }
        if (this.type == "IF") {
            return "IF ";
        }
        if (this.type == "SWITCH") {
            return "SWITCH ";
        }
        if (this.type == "CASE") {
            return "CASE ";
        }
        if (this.type == "MAIN") {
            return "MAIN ";
        }
        return "????????????????? ";
    }

    private void doBreak(UniqueVector uniqueVector, String string, CodeBlock codeBlock, CodeBlock codeBlock2) throws DecompilerException {
        String string2 = this.findBreak(codeBlock);
        if (string2 != null) {
            uniqueVector.addElement(String.valueOf(string) + string2);
        } else {
            String string3 = "none";
            if (codeBlock2 != null) {
                string3 = codeBlock2.name();
            }
            uniqueVector.addElement(String.valueOf(string) + "// break not found: " + codeBlock.name() + " next is " + string3 + ";");
            Decompiler.report("// break not found: " + codeBlock.name() + " next is " + string3);
        }
    }

    private void doCatch(UniqueVector uniqueVector, String string) throws DecompilerException {
        String string2 = Decompiler.findTypeForCatch(this.startLocation());
        string2 = NameMgr.useConvert(string2, 1);
        int n = Decompiler.findNumberForCatch(this.startLocation());
        String string3 = "catch (" + string2 + " parCatchException" + n + ")";
        String string4 = "{";
        uniqueVector.addElement(String.valueOf(string) + string3);
        uniqueVector.addElement(String.valueOf(string) + string4);
        this.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
        this.doSubBlocks(uniqueVector, string);
        uniqueVector.addElement(String.valueOf(string) + "}");
    }

    private void doFinally(UniqueVector uniqueVector, String string) throws DecompilerException {
        uniqueVector.addElement(String.valueOf(string) + "finally");
        uniqueVector.addElement(String.valueOf(string) + "{");
        this.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
        this.doSubBlocks(uniqueVector, string);
        uniqueVector.addElement(String.valueOf(string) + "}");
    }

    private void doIf(UniqueVector uniqueVector, String string) throws DecompilerException {
        this.doInitializers(uniqueVector, string);
        if (this.entry.type != "SIMPLECONDBRANCH") {
            throw new DecompilerException(1521);
        }
        if (this.entry.last.statement == null) {
            throw new DecompilerException(1522);
        }
        if (this.entry.last.statement.oper != "IF") {
            throw new DecompilerException(1523);
        }
        if (this.entry.nextBlockList.size() != 2) {
            throw new DecompilerException(1525);
        }
        if (this.entry.last.statement.action == "NEVER") {
            this.entry.source(uniqueVector, string);
            return;
        }
        CodeBlock codeBlock = (CodeBlock)this.entry.nextBlockList.elementAt(1);
        CodeBlock codeBlock2 = (CodeBlock)this.entry.nextBlockList.elementAt(0);
        if (!codeBlock.equals(this.entry.getTrueBranch(false)) && codeBlock.startLocation() != this.entry.getTrueBranch(false).startLocation()) {
            AnalyzerUtilities.p(String.valueOf(this.entry.getTrueBranch(false).name()) + " " + codeBlock.name());
        }
        if (!codeBlock2.equals(this.entry.getFalseBranch(false)) && codeBlock2.startLocation() != this.entry.getFalseBranch(false).startLocation()) {
            AnalyzerUtilities.p(String.valueOf(this.entry.getFalseBranch(false).name()) + " " + codeBlock2.name());
        }
        CodeBlock codeBlock3 = this.find(true);
        CodeBlock codeBlock4 = this.find(false);
        boolean bl = true;
        boolean bl2 = true;
        if (codeBlock3 == null && this.nextBlock != null && codeBlock.equals(this.nextBlock)) {
            bl = false;
        }
        if (codeBlock4 == null && this.nextBlock != null && codeBlock2.equals(this.nextBlock)) {
            bl2 = false;
        }
        if (bl) {
            if (codeBlock3 != null && codeBlock4 != null && codeBlock4.complexity() < codeBlock3.complexity()) {
                this.flipConditional(this.entry);
                CodeBlock codeBlock5 = codeBlock3;
                codeBlock3 = codeBlock4;
                codeBlock4 = codeBlock5;
            }
            this.entry.source(uniqueVector, string);
            if (codeBlock3 == null) {
                this.doBreak(uniqueVector, String.valueOf(string) + unitTab, codeBlock, this.nextBlock);
            } else {
                codeBlock3.source(uniqueVector, string);
            }
            if (bl2) {
                uniqueVector.addElement(String.valueOf(string) + "else");
                if (codeBlock4 == null) {
                    this.doBreak(uniqueVector, String.valueOf(string) + unitTab, codeBlock2, this.nextBlock);
                } else {
                    codeBlock4.source(uniqueVector, string);
                }
            }
        } else {
            this.flipConditional(this.entry);
            this.entry.source(uniqueVector, string);
            if (bl2) {
                if (codeBlock4 == null) {
                    this.doBreak(uniqueVector, String.valueOf(string) + unitTab, codeBlock2, this.nextBlock);
                } else {
                    codeBlock4.source(uniqueVector, string);
                }
            } else {
                uniqueVector.addElement(String.valueOf(string) + ";");
            }
        }
    }

    private void doIfOption(UniqueVector uniqueVector, String string) throws DecompilerException {
        UniqueVector uniqueVector2 = new UniqueVector();
        int n = this.doSubBlocks(uniqueVector2, string);
        if (n == 1 && uniqueVector2.size() == 1 && this.initializers.size() == 0) {
            uniqueVector.addElement(uniqueVector2.elementAt(0));
        } else {
            uniqueVector.addElement(String.valueOf(string) + "{");
            this.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
            int n2 = 0;
            while (n2 < uniqueVector2.size()) {
                uniqueVector.addElement(uniqueVector2.elementAt(n2));
                ++n2;
            }
            uniqueVector.addElement(String.valueOf(string) + "}");
        }
    }

    private void doInitializers(UniqueVector uniqueVector, String string) {
        int n = 0;
        while (n < this.initializers.size()) {
            uniqueVector.addElement(String.valueOf(string) + (String)this.initializers.elementAt(n));
            ++n;
        }
    }

    private void doLoop(UniqueVector uniqueVector, String string) throws DecompilerException {
        UniqueVector uniqueVector2 = new UniqueVector();
        this.doLoopBody(uniqueVector2, string);
        if (this.namedBlock) {
            uniqueVector.addElement("");
            uniqueVector.addElement(String.valueOf(this.blockLabel) + ":");
            uniqueVector.addElement("");
        } else {
            uniqueVector.addElement("");
        }
        int n = 0;
        while (n < uniqueVector2.size()) {
            uniqueVector.addElement(uniqueVector2.elementAt(n));
            ++n;
        }
        uniqueVector.addElement("");
    }

    private void doLoopBody(UniqueVector uniqueVector, String string) throws DecompilerException {
        String string2 = null;
        CodeBlock codeBlock = null;
        UniqueVector uniqueVector2 = new UniqueVector(2, 2);
        Object var6_6 = null;
        if (this.entry.type == "IF" && this.subBlocks.size() == 1) {
            CodeBlock codeBlock2 = (CodeBlock)this.entry.entry.nextBlockList.elementAt(1);
            CodeBlock codeBlock3 = (CodeBlock)this.entry.entry.nextBlockList.elementAt(0);
            CodeBlock codeBlock4 = null;
            boolean bl = false;
            boolean bl2 = false;
            if (codeBlock2.equals(this.nextBlock)) {
                codeBlock4 = this.entry.find(false);
                bl = true;
                bl2 = false;
            } else if (codeBlock3.equals(this.nextBlock)) {
                codeBlock4 = this.entry.find(true);
                bl = true;
                bl2 = true;
            }
            int n = this.entry.entry.numberOfStatements();
            if (bl && n == 1) {
                UniqueVector uniqueVector3 = new UniqueVector(2, 2);
                if (!bl2) {
                    this.flipConditional(this.entry.entry);
                }
                this.entry.entry.source(uniqueVector3, string);
                if (uniqueVector3.size() != 1) {
                    throw new DecompilerException(15002);
                }
                String string3 = (String)uniqueVector3.elementAt(0);
                if (string3.indexOf("if") >= 0) {
                    if (string2 != null) {
                        String string4 = this.ifToFor(string3, string2);
                        uniqueVector.addElement(string4);
                    } else {
                        uniqueVector.addElement(this.ifToWhile(string3));
                    }
                    if (codeBlock4 == null) {
                        uniqueVector.addElement(String.valueOf(string) + unitTab + ";");
                    } else {
                        uniqueVector.addElement(String.valueOf(string) + "{");
                        codeBlock4.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
                        codeBlock4.doSubBlocks(uniqueVector, string, codeBlock);
                        int n2 = 0;
                        while (n2 < uniqueVector2.size()) {
                            uniqueVector.addElement(uniqueVector2.elementAt(n2));
                            ++n2;
                        }
                        uniqueVector.addElement(String.valueOf(string) + "}");
                    }
                    return;
                }
                throw new DecompilerException(15003);
            }
        }
        uniqueVector.addElement(String.valueOf(string) + "while ( true )");
        uniqueVector.addElement(String.valueOf(string) + "{");
        this.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
        this.doSubBlocks(uniqueVector, string);
        uniqueVector.addElement(String.valueOf(string) + "}");
    }

    private int doSubBlocks(UniqueVector uniqueVector, String string) throws DecompilerException {
        return this.doSubBlocks(uniqueVector, string, null);
    }

    private int doSubBlocks(UniqueVector uniqueVector, String string, CodeBlock codeBlock) throws DecompilerException {
        Object object;
        int n = 0;
        UniqueVector uniqueVector2 = new UniqueVector();
        CodeBlock codeBlock2 = this.entry;
        while (codeBlock2 != null) {
            if (!this.containsDirectly(codeBlock2)) break;
            object = new UniqueVector();
            n += codeBlock2.source((UniqueVector)object, String.valueOf(string) + unitTab);
            uniqueVector2.addElement(object);
            codeBlock2 = codeBlock2.nextBlock;
        }
        object = "";
        int n2 = 0;
        int n3 = this.breakPlaces.size() - 1;
        while (n3 >= 0) {
            ReachableBlock reachableBlock = (ReachableBlock)this.breakPlaces.elementAt(n3);
            if (reachableBlock.used) {
                uniqueVector.addElement(String.valueOf(reachableBlock.label) + ":");
                object = String.valueOf(object) + unitTab;
                uniqueVector.addElement(String.valueOf(string) + (String)object + "{");
                ++n2;
                n += 2;
            }
            --n3;
        }
        codeBlock2 = this.entry;
        int n4 = 0;
        while (codeBlock2 != null) {
            if (!this.containsDirectly(codeBlock2) || codeBlock2 == codeBlock) break;
            UniqueVector uniqueVector3 = (UniqueVector)uniqueVector2.elementAt(n4);
            ++n4;
            if (this.isBreakPlace(codeBlock2)) {
                uniqueVector.addElement(String.valueOf(string) + (String)object + "}");
                object = this.tabs(--n2);
            }
            int n5 = 0;
            while (n5 < uniqueVector3.size()) {
                uniqueVector.addElement(String.valueOf(object) + uniqueVector3.elementAt(n5));
                ++n5;
            }
            codeBlock2 = codeBlock2.nextBlock;
        }
        boolean bl = false;
        if (this.nextBlock != null && this.isBreakPlace(this.nextBlock)) {
            bl = true;
        }
        if (bl) {
            uniqueVector.addElement(String.valueOf(string) + (String)object + "}");
        }
        return n;
    }

    private void doSwitch(UniqueVector uniqueVector, String string) throws DecompilerException {
        UniqueVector uniqueVector2 = new UniqueVector();
        this.doSwitchBody(uniqueVector2, string);
        if (this.namedBlock) {
            uniqueVector.addElement("");
            uniqueVector.addElement(String.valueOf(this.blockLabel) + ":");
            uniqueVector.addElement("");
        }
        int n = 0;
        while (n < uniqueVector2.size()) {
            uniqueVector.addElement(uniqueVector2.elementAt(n));
            ++n;
        }
    }

    private void doSwitchBody(UniqueVector uniqueVector, String string) throws DecompilerException {
        this.doInitializers(uniqueVector, string);
        this.entry.source(uniqueVector, string);
        uniqueVector.addElement(String.valueOf(string) + "{");
        int n = 0;
        while (n < this.targetSets.size()) {
            TargetSet targetSet = (TargetSet)this.targetSets.elementAt(n);
            this.outputTargetSet(uniqueVector, targetSet, string);
            ++n;
        }
        uniqueVector.addElement(String.valueOf(string) + "}");
    }

    private void doTry(UniqueVector uniqueVector, String string) throws DecompilerException {
        if (!this.synch) {
            uniqueVector.addElement(String.valueOf(string) + "try");
        }
        uniqueVector.addElement(String.valueOf(string) + "{");
        this.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
        this.doSubBlocks(uniqueVector, string);
        uniqueVector.addElement(String.valueOf(string) + "}");
    }

    private void doTryCatchFinally(UniqueVector uniqueVector, String string) throws DecompilerException {
        this.doInitializers(uniqueVector, string);
        int n = 0;
        while (n < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n);
            if (codeBlock.type == "TRY") {
                codeBlock.source(uniqueVector, string);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n2);
            if (codeBlock.type == "CATCH") {
                codeBlock.source(uniqueVector, string);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n3);
            if (codeBlock.type == "FINALLY") {
                codeBlock.source(uniqueVector, string);
            }
            ++n3;
        }
    }

    private void doUnordered(UniqueVector uniqueVector, String string) throws DecompilerException {
        uniqueVector.addElement(String.valueOf(string) + "{");
        this.doInitializers(uniqueVector, String.valueOf(string) + unitTab);
        this.doSubBlocks(uniqueVector, string);
        uniqueVector.addElement(String.valueOf(string) + "}");
    }

    private CodeBlock enclosingBreakable() {
        CodeBlock codeBlock = this.superBlock;
        if (codeBlock == null) {
            return null;
        }
        if (codeBlock.type == "LOOP" || codeBlock.type == "SWITCH") {
            return codeBlock;
        }
        return codeBlock.enclosingBreakable();
    }

    private CodeBlock enclosingLoop() {
        CodeBlock codeBlock = this.superBlock;
        if (codeBlock == null) {
            return null;
        }
        if (codeBlock.type == "LOOP") {
            return codeBlock;
        }
        return codeBlock.enclosingLoop();
    }

    public boolean equals(CodeBlock codeBlock) {
        return codeBlock == this;
    }

    private CodeBlock find(boolean bl) throws DecompilerException {
        if (this.type != "IF") {
            throw new DecompilerException(1529);
        }
        int n = 0;
        while (n < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n);
            if (bl && codeBlock.type == "IFTRUE") {
                return codeBlock;
            }
            if (!bl && codeBlock.type == "IFFALSE") {
                return codeBlock;
            }
            ++n;
        }
        return null;
    }

    private String findBreak(CodeBlock codeBlock) {
        CodeBlock codeBlock2 = this.enclosingBreakable();
        CodeBlock codeBlock3 = this.enclosingLoop();
        CodeBlock codeBlock4 = this.superBlock;
        while (codeBlock4 != null) {
            if (codeBlock4.loopSwitchBreak != null && codeBlock4.loopSwitchBreak.block.equals(codeBlock)) {
                if (codeBlock4 == codeBlock2) {
                    return "break;";
                }
                codeBlock4.namedBlock = true;
                return "break " + codeBlock4.blockLabel + ";";
            }
            if (codeBlock4.continueBlock != null && codeBlock4.continueBlock.block.equals(codeBlock)) {
                if (codeBlock4 == codeBlock3) {
                    return "continue;";
                }
                codeBlock4.namedBlock = true;
                return "continue " + codeBlock4.blockLabel + ";";
            }
            codeBlock4 = codeBlock4.superBlock;
        }
        codeBlock4 = this.superBlock;
        while (codeBlock4 != null) {
            int n = 0;
            while (n < codeBlock4.breakPlaces.size()) {
                ReachableBlock reachableBlock = (ReachableBlock)codeBlock4.breakPlaces.elementAt(n);
                if (reachableBlock.block.equals(codeBlock)) {
                    reachableBlock.used = true;
                    return "break " + reachableBlock.label + ";";
                }
                ++n;
            }
            codeBlock4 = codeBlock4.superBlock;
        }
        return null;
    }

    public CodeBlock findFinallyStartingAt(int n) {
        int n2 = 0;
        while (n2 < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n2);
            if (codeBlock.type == "FINALLY" && codeBlock.startLocation() == n) {
                return codeBlock;
            }
            ++n2;
        }
        return null;
    }

    public CodeBlock findTry() {
        int n = 0;
        while (n < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n);
            if (codeBlock.type == "TRY") {
                return codeBlock;
            }
            ++n;
        }
        return null;
    }

    private void flipConditional(CodeBlock codeBlock) throws DecompilerException {
        if (codeBlock.last == null) {
            throw new DecompilerException(12301);
        }
        if (codeBlock.last.statement == null) {
            throw new DecompilerException(12302);
        }
        Statement statement = codeBlock.last.statement;
        if (statement.oper != "IF") {
            throw new DecompilerException(1527);
        }
        Operand operand = new Operand("NOT", null, statement.get(0), null, new Type("boolean"), null, null);
        statement.replaceOperand(operand);
    }

    public CodeBlock getBranch(boolean bl, boolean bl2) throws DecompilerException {
        if (this.type != "SIMPLECONDBRANCH") {
            throw new DecompilerException(1531);
        }
        CodeBlock codeBlock = bl ? this.last.getNextInstructionForValue((int)101).enclosingCodeBlock : this.last.getNextInstructionForValue((int)102).enclosingCodeBlock;
        return codeBlock;
    }

    public CodeBlock getFalseBranch(boolean bl) throws DecompilerException {
        return this.getBranch(false, bl);
    }

    private CodeBlock getNextStartingAt(int n) {
        int n2 = 0;
        while (n2 < this.nextBlockList.size()) {
            CodeBlock codeBlock = (CodeBlock)this.nextBlockList.elementAt(n2);
            if (codeBlock.startLocation() == n) {
                return codeBlock;
            }
            ++n2;
        }
        return null;
    }

    public CodeBlock getTrueBranch(boolean bl) throws DecompilerException {
        return this.getBranch(true, bl);
    }

    private String ifToFor(String string, String string2) throws DecompilerException {
        int n = 0;
        while (n < string2.length()) {
            if (string2.charAt(n) != ' ') break;
            ++n;
        }
        string2 = string2.substring(n, string2.length() - 1);
        int n2 = string.indexOf("if");
        if (n2 < 0) {
            throw new DecompilerException(1537);
        }
        return String.valueOf(string.substring(0, n2)) + "for ( ;" + string.substring(n2 + 4, string.length() - 1) + "; " + string2 + " )";
    }

    private String ifToWhile(String string) throws DecompilerException {
        int n = string.indexOf("if");
        if (n < 0) {
            throw new DecompilerException(1535);
        }
        return String.valueOf(string.substring(0, n)) + "while" + string.substring(n + 2, string.length());
    }

    private boolean isBreakPlace(CodeBlock codeBlock) {
        int n = 0;
        while (n < this.breakPlaces.size()) {
            ReachableBlock reachableBlock = (ReachableBlock)this.breakPlaces.elementAt(n);
            if (reachableBlock.used && reachableBlock.block == codeBlock) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public CodeBlock isEntryForBlock(CodeBlock codeBlock) {
        if (codeBlock.entry != null && codeBlock.entry.equals(this)) {
            return codeBlock;
        }
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            CodeBlock codeBlock3 = this.isEntryForBlock(codeBlock2);
            if (codeBlock3 != null) {
                return codeBlock3;
            }
            ++n;
        }
        return null;
    }

    public static boolean jumpToLoopTop(CodeBlock codeBlock, CodeBlock codeBlock2) {
        return codeBlock2.type == "LOOP" && codeBlock2.containsAsSubBlock(codeBlock) || codeBlock2.equals(codeBlock);
    }

    public String labelIt() {
        if (this.blockLabel == null) {
            this.blockLabel = ReachableBlock.makeALabel();
        }
        return this.blockLabel;
    }

    private CodeBlock lastSimple(CodeBlock codeBlock) throws DecompilerException {
        if (this.type == "LOOP" && this.subBlocks.size() == 1) {
            CodeBlock codeBlock2 = (CodeBlock)this.subBlocks.elementAt(0);
            if (codeBlock2.type == "IF" && codeBlock2.subBlocks.size() == 2) {
                CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(1);
                if (codeBlock3.type == "IFTRUE") {
                    CodeBlock codeBlock4 = codeBlock3.entry;
                    while (true) {
                        CodeBlock codeBlock5;
                        if ((codeBlock5 = codeBlock4.nextBlock) == codeBlock) {
                            if (codeBlock4.simple()) {
                                return codeBlock4;
                            }
                            return null;
                        }
                        if (!codeBlock3.containsDirectly(codeBlock5)) {
                            return null;
                        }
                        codeBlock4 = codeBlock5;
                    }
                }
            }
        }
        return null;
    }

    public String name() {
        if (this.simple()) {
            return " ( SIMPLE " + this.first.location + " ) ";
        }
        int n = this.entry != null ? this.entry.startLocation() : -1;
        return " ( " + this.description() + " " + n + " ) ";
    }

    public boolean neverAction() {
        return this.neverAction(false);
    }

    public boolean neverAction(boolean bl) {
        if (!this.simple()) {
            return false;
        }
        Instruction instruction = this.first;
        while (instruction.saveLabel < 0) {
            if (instruction.referringInstructionList.size() > 1) {
                return false;
            }
            if (bl && instruction.equals(this.last)) {
                return true;
            }
            if (instruction.statement != null && instruction.statement.action != "NEVER") {
                return false;
            }
            if (!bl && instruction.equals(this.last)) {
                return true;
            }
            instruction = instruction.theNextInstruction();
        }
        return false;
    }

    public boolean neverActionButLast() {
        return this.neverAction(true);
    }

    public int numberOfReferringInstructions() throws DecompilerException {
        if (this.simple()) {
            return this.first.referringInstructionList.size();
        }
        if (this.entry != null) {
            return this.entry.numberOfReferringInstructions();
        }
        throw new DecompilerException(8221);
    }

    private int numberOfStatements() {
        if (!this.simple()) {
            return 0;
        }
        int n = 0;
        Instruction instruction = this.first;
        while (true) {
            if (instruction.generatesStatement()) {
                ++n;
            }
            if (instruction.equals(this.last)) break;
            instruction = instruction.theNextInstruction();
        }
        return n;
    }

    public boolean orderedContainer() {
        return this.type == "IF" || this.type == "SWITCH" || this.type == "TRYCATCHFINALLY";
    }

    private void outputTargetSet(UniqueVector uniqueVector, TargetSet targetSet, String string) throws DecompilerException {
        int n = targetSet.smallestValue;
        if (targetSet.isDefault) {
            uniqueVector.addElement(String.valueOf(string) + "default:");
        } else {
            while (true) {
                uniqueVector.addElement(String.valueOf(string) + "case " + n + ":");
                int n2 = targetSet.getNextValueAbove(n);
                if (n2 == n) break;
                n = n2;
            }
        }
        if (targetSet.caseBlock == null) {
            CodeBlock codeBlock = this.getNextStartingAt(targetSet.targetLocation);
            if (codeBlock == this.loopSwitchBreak.block) {
                uniqueVector.addElement(String.valueOf(string) + unitTab + "break;");
            } else {
                this.doBreak(uniqueVector, String.valueOf(string) + unitTab, codeBlock, null);
            }
        } else {
            targetSet.caseBlock.doSubBlocks(uniqueVector, String.valueOf(string) + unitTab);
        }
    }

    public void print(boolean bl) throws DecompilerException {
        UniqueVector uniqueVector = new UniqueVector();
        this.toString(uniqueVector, "", bl);
        int n = 0;
        while (n < uniqueVector.size()) {
            AnalyzerUtilities.p(uniqueVector.elementAt(n));
            ++n;
        }
        AnalyzerUtilities.p("");
    }

    public CodeBlock protectedTryCatch() throws DecompilerException {
        if (this.type != "TRYCATCHFINALLY") {
            return null;
        }
        if (this.subBlocks.size() != 2) {
            return null;
        }
        CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(1);
        CodeBlock codeBlock2 = (CodeBlock)this.subBlocks.elementAt(0);
        if (codeBlock.type != "TRY") {
            throw new DecompilerException(8217);
        }
        if (codeBlock.subBlocks.size() == 1 && ((CodeBlock)codeBlock.subBlocks.elementAt((int)0)).type == "TRYCATCHFINALLY") {
            return (CodeBlock)codeBlock.subBlocks.elementAt(0);
        }
        return null;
    }

    public boolean reachesDirectlyNoAction(CodeBlock codeBlock) {
        CodeBlock codeBlock2 = this;
        while (!codeBlock2.equals(codeBlock) || !codeBlock2.neverActionButLast()) {
            if (!codeBlock2.neverAction()) {
                return false;
            }
            if (codeBlock2.nextBlockList.size() != 1) {
                return false;
            }
            if (codeBlock2.last.referringInstructionList.size() != 1) {
                return false;
            }
            codeBlock2 = (CodeBlock)codeBlock2.nextBlockList.elementAt(0);
        }
        return true;
    }

    public CodeBlock removeSingleCatch() {
        boolean bl = false;
        int n = 0;
        while (n < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n);
            if (codeBlock.type == "CATCH") {
                if (bl) {
                    Decompiler.report("Found unexpected catch block");
                } else {
                    bl = true;
                    this.subBlocks.removeElement(codeBlock);
                }
            }
            ++n;
        }
        return null;
    }

    public void repointTo(CodeBlock codeBlock, CodeBlock codeBlock2) {
        if (this.entry != null && this.entry == codeBlock) {
            this.entry = codeBlock2;
        }
        UniqueVector uniqueVector = new UniqueVector();
        int n = 0;
        while (n < this.nextBlockList.size()) {
            CodeBlock codeBlock3 = (CodeBlock)this.nextBlockList.elementAt(n);
            if (codeBlock3.equals(codeBlock)) {
                uniqueVector.addElement(codeBlock2);
            } else {
                uniqueVector.addElement(codeBlock3);
            }
            ++n;
        }
        this.nextBlockList = uniqueVector;
        int n2 = 0;
        while (n2 < this.subBlocks.size()) {
            ((CodeBlock)this.subBlocks.elementAt(n2)).repointTo(codeBlock, codeBlock2);
            ++n2;
        }
    }

    public void setContinue() throws DecompilerException {
    }

    public void setNextNoLoop(boolean bl, CodeBlock codeBlock) {
        this.processed = true;
        int n = 0;
        while (n < this.nextBlockList.size()) {
            CodeBlock codeBlock2 = (CodeBlock)this.nextBlockList.elementAt(n);
            if (!(codeBlock2.processed || codeBlock2 == codeBlock || codeBlock2.type == "LOOP" && codeBlock2.containsAsSubBlock(this) || codeBlock2.equals(this))) {
                codeBlock2.search = bl;
                codeBlock2.setNextNoLoop(bl, codeBlock);
            }
            ++n;
        }
    }

    public void setOnBreak(CodeBlock codeBlock) {
        if (codeBlock == null) {
            return;
        }
        if (this.containedInBreaks(codeBlock)) {
            return;
        }
        ReachableBlock reachableBlock = new ReachableBlock(codeBlock, true);
        this.breakPlaces.addElement(reachableBlock);
    }

    public void setStdBreak(CodeBlock codeBlock) {
        if (codeBlock == null) {
            return;
        }
        if (this.containedInBreaks(codeBlock)) {
            return;
        }
        ReachableBlock reachableBlock = new ReachableBlock(codeBlock, false);
        this.labelIt();
        this.loopSwitchBreak = reachableBlock;
    }

    public boolean simple() {
        return this.type == "SIMPLECONDBRANCH" || this.type == "SIMPLEMULTIBRANCH" || this.type == "SIMPLEOTHER";
    }

    public int source(UniqueVector uniqueVector, String string) throws DecompilerException {
        if (this.simple()) {
            Object object;
            this.doInitializers(uniqueVector, string);
            Instruction instruction = this.first;
            int n = 0;
            while (true) {
                if (instruction.statement != null) {
                    object = instruction.statement.makeStatement();
                    int n2 = 0;
                    while (n2 < ((Vector)object).size()) {
                        uniqueVector.addElement(String.valueOf(string) + ((Vector)object).elementAt(n2));
                        ++n;
                        ++n2;
                    }
                }
                if (instruction.saveLabel >= 0) {
                    n += instruction.makeSaveStatement(uniqueVector, string);
                }
                if (instruction.equals(this.last)) break;
                instruction = (Instruction)instruction.nextInstructionList.elementAt(0);
            }
            if (this.nextBlockList.size() == 1 && this.type != "SIMPLECONDBRANCH" && this.type != "SIMPLEMULTIBRANCH") {
                object = (CodeBlock)this.nextBlockList.elementAt(0);
                if (this.nextBlock == null || !((CodeBlock)object).equals(this.nextBlock)) {
                    this.doBreak(uniqueVector, string, (CodeBlock)object, this.nextBlock);
                }
            }
            return n;
        }
        if (this.type == "LOOP") {
            this.doLoop(uniqueVector, string);
        } else if (this.type == "IF") {
            this.doIf(uniqueVector, string);
        } else if (this.type == "IFTRUE") {
            this.doIfOption(uniqueVector, string);
        } else if (this.type == "IFFALSE") {
            this.doIfOption(uniqueVector, string);
        } else if (this.type == "TRYCATCHFINALLY") {
            this.doTryCatchFinally(uniqueVector, string);
        } else if (this.type == "TRY") {
            this.doTry(uniqueVector, string);
        } else if (this.type == "CATCH") {
            this.doCatch(uniqueVector, string);
        } else if (this.type == "FINALLY") {
            this.doFinally(uniqueVector, string);
        } else if (this.type == "MAIN") {
            this.doUnordered(uniqueVector, string);
        } else if (this.type == "SWITCH") {
            this.doSwitch(uniqueVector, string);
        } else {
            throw new DecompilerException(1215);
        }
        return 99;
    }

    public int startLocation() {
        if (this.simple()) {
            return this.first.location;
        }
        if (this.entry != null) {
            return this.entry.startLocation();
        }
        return -1;
    }

    private String tabs(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + unitTab;
            ++n2;
        }
        return string;
    }

    public void toString(UniqueVector uniqueVector, String string, boolean bl) throws DecompilerException {
        Object object;
        String string2 = String.valueOf(string) + "[ ";
        string2 = String.valueOf(string2) + this.name();
        string2 = String.valueOf(string2) + "-->";
        int n = 0;
        while (n < this.nextBlockList.size()) {
            object = (CodeBlock)this.nextBlockList.elementAt(n);
            string2 = String.valueOf(string2) + ((CodeBlock)object).name();
            ++n;
        }
        if (this.entry != null) {
            string2 = String.valueOf(string2) + " entry = " + this.entry.name();
        }
        string2 = this.nextBlock != null ? String.valueOf(string2) + " next = " + this.nextBlock.name() : String.valueOf(string2) + " next = NULL";
        string2 = this.loopSwitchBreak != null ? String.valueOf(string2) + " loopSwitchBreak = " + this.loopSwitchBreak.block.name() : String.valueOf(string2) + " loopSwitchBreak = NULL";
        string2 = String.valueOf(string2) + "]";
        uniqueVector.addElement(string2);
        if (this.simple()) {
            object = this.first;
            while (!((Instruction)object).equals(this.last)) {
                object = (Instruction)((Instruction)object).nextInstructionList.elementAt(0);
            }
        } else if (this.orderedContainer() || bl) {
            int n2 = 0;
            while (n2 < this.subBlocks.size()) {
                CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n2);
                codeBlock.toString(uniqueVector, String.valueOf(string) + unitTab, bl);
                ++n2;
            }
        } else {
            object = this.entry;
            do {
                ((CodeBlock)object).toString(uniqueVector, String.valueOf(string) + unitTab, bl);
            } while ((object = ((CodeBlock)object).nextBlock) != null && this.containsDirectly((CodeBlock)object));
        }
    }

    public CodeBlock whichSubContainsAll(UniqueVector uniqueVector) {
        int n = 0;
        while (n < this.subBlocks.size()) {
            CodeBlock codeBlock = (CodeBlock)this.subBlocks.elementAt(n);
            if (codeBlock.containsAll(uniqueVector)) {
                return codeBlock;
            }
            ++n;
        }
        return null;
    }
}

