/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.AnalyzerUtilities;

public class ExpandableArray {
    private int[] array = new int[this.max];
    private int elementCount = 0;
    private int max = 10;

    public void add(int n) {
        if (this.elementCount == this.max) {
            this.expand();
        }
        this.array[this.elementCount++] = n;
    }

    public boolean contains(int n) {
        int n2 = 0;
        while (n2 < this.elementCount) {
            if (this.array[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void expand() {
        this.max += 10;
        int[] nArray = new int[this.max];
        int n = 0;
        while (n < this.elementCount) {
            nArray[n] = this.array[n];
            ++n;
        }
        this.array = nArray;
    }

    public int get(int n) {
        if (n >= 0 && n < this.elementCount) {
            return this.array[n];
        }
        AnalyzerUtilities.alert("ExpandableArray: out of bounds");
        return 0;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        String string = "(";
        int n = 0;
        while (n < this.size()) {
            string = String.valueOf(string) + " " + this.get(n);
            ++n;
        }
        return String.valueOf(string) + ")";
    }
}

