/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.OpcData;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.UniqueVector;

public class ProgramElement
implements OpcData {
    public String oper = null;
    public UniqueVector operands = null;
    public String arrayInstructionType;
    public Object constantOrName;
    public UniqueVector argTypeVector;
    public Instruction genInstruction;

    protected static String buildInvoke(boolean bl, UniqueVector uniqueVector, String string, String string2, UniqueVector uniqueVector2, boolean bl2) throws DecompilerException {
        String string3 = DecompilerLibrary.removeClass(string);
        String string4 = DecompilerLibrary.removeMethodOrField(string);
        if (bl) {
            Object object;
            String string5 = ProgramElement.getArgs(uniqueVector.size() - 1, uniqueVector, uniqueVector2, false);
            if (!bl2 && string3.equals("toString") && string4.equals("java/lang/StringBuffer") && uniqueVector.size() == 1 && (object = ProgramElement.doAppendLogic((Operand)uniqueVector.elementAt(0), uniqueVector, true)) != null) {
                return "(" + (String)object + ")";
            }
            object = (Operand)uniqueVector.elementAt(uniqueVector.size() - 1);
            String string6 = ((Operand)object).getMyType().getResolvedType();
            String string7 = null;
            if (((ProgramElement)object).oper == "null") {
                throw new DecompilerException(19002);
            }
            string7 = string6.equals(string4) ? (((Operand)object).isThis() ? "" : ((Operand)object).output(null, null)) : (((Operand)object).isThis() ? (string4.equals(Decompiler.getSuperName()) || Decompiler.classHasMethod(string2) ? "super" : "") : ((Operand)object).output(null, string4));
            if (string3.equals("<init>")) {
                if (((Operand)object).isThis()) {
                    if (string4.equals(Decompiler.getClassName())) {
                        return "this(" + string5 + ")";
                    }
                    if (string4.equals(Decompiler.getSuperName())) {
                        return "super(" + string5 + ")";
                    }
                    Decompiler.report("Initializer references wrong class");
                } else {
                    throw new DecompilerException(21010);
                }
            }
            if (string7.equals("")) {
                return String.valueOf(string3) + "(" + string5 + ")";
            }
            return String.valueOf(string7) + "." + string3 + "(" + string5 + ")";
        }
        if (string4.equals(Decompiler.getClassName())) {
            return String.valueOf(string3) + ProgramElement.getArgs(uniqueVector.size(), uniqueVector, uniqueVector2, true);
        }
        return String.valueOf(NameMgr.useConvert(string4, 1)) + "." + string3 + ProgramElement.getArgs(uniqueVector.size(), uniqueVector, uniqueVector2, true);
    }

    protected static int dimensions(String string) {
        int n = 0;
        int n2;
        while ((n2 = string.lastIndexOf("[]")) >= 0) {
            ++n;
            string = string.substring(0, n2);
        }
        return n;
    }

    public static String doAppendLogic(Operand operand, UniqueVector uniqueVector, boolean bl) throws DecompilerException {
        if (operand.oper == "INVOKEVIRTUAL") {
            String string = (String)operand.constantOrName;
            String string2 = DecompilerLibrary.removeClass(string);
            String string3 = DecompilerLibrary.removeMethodOrField(string);
            if (string2.equals("append") && string3.equals("java/lang/StringBuffer") && operand.operands.size() == 2) {
                Operand operand2 = (Operand)operand.operands.elementAt(1);
                String string4 = ProgramElement.doAppendLogic(operand2, operand.operands, false);
                if (string4 == null) {
                    return null;
                }
                String string5 = ProgramElement.getArgs(operand.operands.size() - 1, operand.operands, operand.argTypeVector, false);
                if (string4.equals("")) {
                    return string5;
                }
                return String.valueOf(string4) + " + " + string5;
            }
        }
        if (!bl && operand.oper == "NEWINITIALIZE" && operand.operands.size() == 0 && operand.constantOrName.equals("java/lang/StringBuffer")) {
            return "";
        }
        return null;
    }

    protected static String getArgs(int n, UniqueVector uniqueVector, UniqueVector uniqueVector2, boolean bl) throws DecompilerException {
        String string = "";
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            Operand operand = (Operand)uniqueVector.elementAt(n3);
            if (n3 != n - 1) {
                string = String.valueOf(string) + ", ";
            }
            String string2 = operand.output(null, (String)uniqueVector2.elementAt(n2));
            ++n2;
            string = String.valueOf(string) + string2;
            --n3;
        }
        if (bl) {
            return "(" + string + ")";
        }
        return string;
    }

    protected static String getFieldObjectReference(Operand operand, String string) throws DecompilerException {
        String string2 = operand.getMyType().getResolvedType();
        if (string2.equals(string)) {
            if (operand.isThis()) {
                return "";
            }
            return String.valueOf(operand.output(null, null)) + ".";
        }
        if (operand.isThis()) {
            return "";
        }
        return "((" + NameMgr.useConvert(string, 1) + ") " + operand.output(null, null) + ").";
    }

    protected static String getStaticFieldName(String string) throws DecompilerException {
        String string2 = DecompilerLibrary.removeClass(string);
        String string3 = DecompilerLibrary.removeMethodOrField(string);
        if ((string3 = NameMgr.useConvert(string3, 1)).equals(Decompiler.getClassName())) {
            return string2;
        }
        return String.valueOf(string3) + "." + string2;
    }

    protected static String newArray(UniqueVector uniqueVector, String string) throws DecompilerException {
        int n = ProgramElement.dimensions(string);
        String string2 = "new " + ProgramElement.removeBrackets(string);
        int n2 = uniqueVector.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n2 - 1 - n3;
            String string3 = ((Operand)uniqueVector.elementAt(n4)).output(null, "int");
            string2 = String.valueOf(string2) + "[" + string3 + "]";
            ++n3;
        }
        while (n3 < n) {
            string2 = String.valueOf(string2) + "[]";
            ++n3;
        }
        return string2;
    }

    protected static String newInitialize(UniqueVector uniqueVector, UniqueVector uniqueVector2, String string) throws DecompilerException {
        return "new " + string + ProgramElement.getArgs(uniqueVector.size(), uniqueVector, uniqueVector2, true);
    }

    public static String removeBrackets(String string) {
        int n = string.indexOf("[]");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }
}

