/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer.info;

import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.CodeBlock;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.LocalDescriptor;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.OpcData;
import org.apache.tools.analyzer.Operand;
import org.apache.tools.analyzer.ProgramElement;
import org.apache.tools.analyzer.Statement;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.MethodInfo;
import org.apache.tools.analyzer.info.ResolvedLocal;
import org.apache.tools.analyzer.info.VariableUsage;
import org.apache.tools.analyzer.structures.Name;
import org.apache.tools.analyzer.structures.Parameter;

public class LocalVariableInfo
implements OpcData {
    private static final String[] tokenImage = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static UniqueVector variables;
    private static UniqueVector resolvedLocals;
    private static MethodInfo method;
    private static Parameter[] params;
    private static UniqueVector namesInUse;
    private static UniqueVector allNames;

    private static String abbrev(String string) {
        string = string.toLowerCase();
        String string2 = "";
        int n = string.charAt(0);
        if (n > 122 || n < 97) {
            string = "class" + string;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            if (n > 122 || n < 97) {
                int n3 = n;
                if (n >= 48) {
                    n3 = n - 48;
                }
                n = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(n3 %= 25);
            }
            string2 = String.valueOf(string2) + (char)n;
            ++n2;
        }
        return string2;
    }

    private static CodeBlock defineBlock(ResolvedLocal resolvedLocal) throws DecompilerException {
        if (resolvedLocal.firstInstruction == null) {
            throw new DecompilerException(1211);
        }
        if (resolvedLocal.enclosingBlock.simple()) {
            return null;
        }
        CodeBlock codeBlock = resolvedLocal.enclosingBlock.entry;
        if (codeBlock == null) {
            return resolvedLocal.enclosingBlock;
        }
        while (true) {
            if (LocalVariableInfo.usedIn(resolvedLocal, codeBlock)) {
                if (codeBlock.simple()) {
                    if (!codeBlock.containsInstruction(resolvedLocal.firstInstruction)) break;
                    return null;
                }
                if (codeBlock.type != "IF" && codeBlock.type != "SWITCH" && codeBlock.type != "TRYCATCHFINALLY") break;
                if ((codeBlock.type == "IF" || codeBlock.type == "SWITCH") && ((CodeBlock)codeBlock.subBlocks.elementAt(0)).containsInstruction(resolvedLocal.firstInstruction)) {
                    return null;
                }
                return codeBlock;
            }
            CodeBlock codeBlock2 = codeBlock.nextBlock;
            if (codeBlock2 == codeBlock || codeBlock2 == null || !resolvedLocal.enclosingBlock.containsDirectly(codeBlock2)) break;
            codeBlock = codeBlock2;
        }
        return resolvedLocal.enclosingBlock;
    }

    private static String diff() {
        long l = System.currentTimeMillis() / 10L;
        int n = (int)(l % 9L);
        return String.valueOf(n);
    }

    public static void dump() throws DecompilerException {
        int n = 0;
        while (n < resolvedLocals.size()) {
            ResolvedLocal resolvedLocal = (ResolvedLocal)resolvedLocals.elementAt(n);
            AnalyzerUtilities.p("resolved local in " + resolvedLocal.slot + " of type " + resolvedLocal.type + " contained in " + resolvedLocal.enclosingBlock.name());
            int n2 = 0;
            while (n2 < resolvedLocal.blocks.size()) {
                AnalyzerUtilities.p("   " + ((CodeBlock)resolvedLocal.blocks.elementAt(n2)).name());
                ++n2;
            }
            ++n;
        }
    }

    private static ResolvedLocal find(int n, String string) {
        int n2 = 0;
        while (n2 < resolvedLocals.size()) {
            ResolvedLocal resolvedLocal = (ResolvedLocal)resolvedLocals.elementAt(n2);
            if (resolvedLocal.slot == n && resolvedLocal.type.equals(string)) {
                return resolvedLocal;
            }
            ++n2;
        }
        return null;
    }

    private static CodeBlock findEnclosingBlock(ResolvedLocal resolvedLocal) throws DecompilerException {
        CodeBlock codeBlock;
        if (resolvedLocal.blocks.size() == 1) {
            return (CodeBlock)resolvedLocal.blocks.elementAt(0);
        }
        CodeBlock codeBlock2 = Decompiler.getMethodBlock();
        while ((codeBlock = codeBlock2.whichSubContainsAll(resolvedLocal.blocks)) != null) {
            codeBlock2 = codeBlock;
        }
        return codeBlock2;
    }

    private static Name findName(String string) {
        int n = 0;
        while (n < allNames.size()) {
            Name name = (Name)allNames.elementAt(n);
            if (name.name.equals(string)) {
                return name;
            }
            ++n;
        }
        return null;
    }

    private static Parameter findParameter(int n) {
        int n2 = 0;
        while (n2 < params.length) {
            if (LocalVariableInfo.params[n2].slot == n) {
                return params[n2];
            }
            ++n2;
        }
        return null;
    }

    private static String firstCharUpper(String string) {
        return String.valueOf(new String(String.valueOf(string.charAt(0))).toUpperCase()) + string.substring(1, string.length());
    }

    private static String generateName(String string, int n, boolean bl) throws DecompilerException {
        String string2;
        string = NameMgr.useConvert(string, 1);
        String string3 = null;
        if (!bl) {
            if (string == "int") {
                string2 = "ijkmnpqrstvwxyz";
                int n2 = 0;
                while (n2 < string2.length()) {
                    String string4 = string2.substring(n2, n2 + 1);
                    if (!LocalVariableInfo.nameUsed(string4)) {
                        string3 = string4;
                        break;
                    }
                    ++n2;
                }
            }
            if (string == "double" || string == "float") {
                if (!LocalVariableInfo.nameUsed("f")) {
                    string3 = "f";
                } else if (!LocalVariableInfo.nameUsed("g")) {
                    string3 = "g";
                } else if (!LocalVariableInfo.nameUsed("h")) {
                    string3 = "h";
                } else if (!LocalVariableInfo.nameUsed("r")) {
                    string3 = "r";
                } else if (!LocalVariableInfo.nameUsed("s")) {
                    string3 = "s";
                } else if (!LocalVariableInfo.nameUsed("t")) {
                    string3 = "t";
                }
            }
            if (string == "char" && !LocalVariableInfo.nameUsed("c")) {
                string3 = "c";
            }
            if (string == "byte" && !LocalVariableInfo.nameUsed("b")) {
                string3 = "b";
            }
        }
        if (string3 == null) {
            String string5;
            string2 = "";
            String string6 = string5 = bl ? "par" : "";
            if (string.indexOf("[]") > 0) {
                string = ProgramElement.removeBrackets(string);
                string2 = "Array";
            }
            if (string == "boolean") {
                string = "bool";
            }
            if (string == "float") {
                string = "flt";
            }
            if (string == "double") {
                string = "dbl";
            }
            if (string == "long") {
                string = "lng";
            }
            if (string == "short") {
                string = "shortInt";
            }
            if (string == "char") {
                string = "ch";
            }
            string = LocalVariableInfo.abbrev(string);
            if (bl) {
                string = LocalVariableInfo.firstCharUpper(string);
            }
            string3 = String.valueOf(string5) + string + string2;
        }
        if (LocalVariableInfo.isKeyword(string3)) {
            return String.valueOf(string3) + "m";
        }
        return string3;
    }

    public static String getLocalName(int n, Instruction instruction) throws DecompilerException {
        if (n == 0 && !method.isStatic()) {
            return "this";
        }
        if (!Decompiler.isLocal(n)) {
            return LocalVariableInfo.findParameter((int)n).name;
        }
        LocalDescriptor localDescriptor = instruction.localTable.getSlot(n);
        if (localDescriptor == null) {
            Decompiler.report("Unknown variable encountered in local " + n);
            return "unknownVar" + n;
        }
        String string = localDescriptor.partialType.getResolvedType();
        return LocalVariableInfo.find((int)n, (String)string).name;
    }

    public static Type getLocalType(int n, Instruction instruction) throws DecompilerException {
        if (n == 0 && !method.isStatic()) {
            return new Type(Decompiler.getClassName());
        }
        if (!Decompiler.isLocal(n)) {
            return new Type(LocalVariableInfo.findParameter((int)n).type);
        }
        LocalDescriptor localDescriptor = instruction.localTable.getSlot(n);
        if (localDescriptor == null) {
            return null;
        }
        return localDescriptor.partialType;
    }

    public static void initialize(MethodInfo methodInfo, Parameter[] parameterArray) {
        variables = new UniqueVector();
        method = methodInfo;
        params = parameterArray;
    }

    public static boolean isKeyword(String string) {
        int n = 0;
        while (n < tokenImage.length) {
            if (string.equals(tokenImage[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static void locateInitializers() throws DecompilerException {
        Object object;
        Object object2;
        Object object3;
        resolvedLocals = new UniqueVector();
        int n = 0;
        while (n < variables.size()) {
            VariableUsage variableUsage = (VariableUsage)variables.elementAt(n);
            int n2 = variableUsage.descriptor.slot;
            object3 = variableUsage.descriptor.partialType.getResolvedType();
            object2 = LocalVariableInfo.find(n2, (String)object3);
            if (object2 == null) {
                object2 = new ResolvedLocal(n2, (String)object3, variableUsage.instruction, variableUsage.set);
                resolvedLocals.addElement(object2);
            }
            if (!((ResolvedLocal)object2).blocks.contains(object = variableUsage.instruction.enclosingCodeBlock)) {
                ((ResolvedLocal)object2).blocks.addElement(object);
            }
            ++n;
        }
        LocalVariableInfo.setAllNames();
        int n3 = 0;
        while (n3 < resolvedLocals.size()) {
            ResolvedLocal resolvedLocal = (ResolvedLocal)resolvedLocals.elementAt(n3);
            resolvedLocal.enclosingBlock = LocalVariableInfo.findEnclosingBlock(resolvedLocal);
            object3 = resolvedLocal.firstInstruction.statement;
            object2 = LocalVariableInfo.defineBlock(resolvedLocal);
            object = NameMgr.useConvert(resolvedLocal.type, 1);
            if (resolvedLocal.setFirst) {
                if (object2 != null) {
                    ((CodeBlock)object2).initializers.addElement(String.valueOf(object) + " " + resolvedLocal.name + ";");
                } else if (object3 != null && ((ProgramElement)object3).oper == "PUTLOCAL") {
                    ((Statement)object3).initializer = object;
                } else {
                    if (resolvedLocal.firstInstruction.saveLabel < 0) {
                        throw new DecompilerException(12201);
                    }
                    resolvedLocal.firstInstruction.saveInit = object;
                }
            } else {
                if (object2 == null) {
                    object2 = resolvedLocal.enclosingBlock;
                }
                ((CodeBlock)object2).initializers.addElement(String.valueOf(object) + " " + resolvedLocal.name + " = " + Operand.convertZero(resolvedLocal.type) + ";");
                Decompiler.report("Local variable " + resolvedLocal.name + " accessed before being set.");
            }
            ++n3;
        }
    }

    private static boolean nameUsed(String string) {
        return LocalVariableInfo.findName(string) != null;
    }

    public static void set(LocalDescriptor localDescriptor, Instruction instruction, String string) throws DecompilerException {
        if (string == "subroutineReturnAddress") {
            return;
        }
        if (instruction == null) {
            throw new DecompilerException(1209);
        }
        variables.addElement(new VariableUsage(localDescriptor, instruction, true));
    }

    private static void setAllNames() throws DecompilerException {
        int n;
        Object object;
        Object object2;
        Object object3;
        allNames = new UniqueVector();
        int n2 = 0;
        while (n2 < params.length) {
            String string;
            LocalVariableInfo.params[n2].name = string = LocalVariableInfo.generateName(LocalVariableInfo.params[n2].type, method.isStatic() ? n2 : n2 + 1, true);
            object3 = LocalVariableInfo.findName(string);
            if (object3 == null) {
                allNames.addElement(new Name(string, 1));
            } else {
                ++((Name)object3).count;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < resolvedLocals.size()) {
            object3 = (ResolvedLocal)resolvedLocals.elementAt(n3);
            ((ResolvedLocal)object3).name = LocalVariableInfo.generateName(((ResolvedLocal)object3).type, ((ResolvedLocal)object3).slot, false);
            object2 = LocalVariableInfo.findName(((ResolvedLocal)object3).name);
            if (object2 == null) {
                allNames.addElement(new Name(((ResolvedLocal)object3).name, 1));
            } else {
                ++((Name)object2).count;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < params.length) {
            object2 = LocalVariableInfo.params[n4].name;
            object = LocalVariableInfo.findName((String)object2);
            n = ((Name)object).count;
            if (n > 1) {
                object2 = n < 26 ? String.valueOf(object2) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(((Name)object).usedCount++) : String.valueOf(object2) + (((Name)object).usedCount++ + 1);
            }
            LocalVariableInfo.params[n4].name = object2;
            ++n4;
        }
        int n5 = 0;
        while (n5 < resolvedLocals.size()) {
            object = (ResolvedLocal)resolvedLocals.elementAt(n5);
            String string = ((ResolvedLocal)object).name;
            Name name = LocalVariableInfo.findName(string);
            int n6 = name.count;
            if (n6 > 1) {
                string = n6 < 26 ? String.valueOf(string) + "ABCDEFGHIJKLMNOPQRSTUVWXYZ".charAt(name.usedCount++) : String.valueOf(string) + (name.usedCount++ + 1);
            }
            ((ResolvedLocal)object).name = string;
            ++n5;
        }
        boolean bl = true;
        block4: while (bl) {
            Object object4;
            int n7;
            bl = false;
            int n8 = 0;
            while (n8 < params.length) {
                n = 0;
                String string = LocalVariableInfo.params[n8].name;
                if (Decompiler.isFieldName(string)) {
                    n = 1;
                }
                int n9 = 0;
                while (n9 < params.length) {
                    String string2;
                    if (n8 != n9 && string.equals(string2 = LocalVariableInfo.params[n9].name)) {
                        n = 1;
                    }
                    ++n9;
                }
                n7 = 0;
                while (n7 < resolvedLocals.size()) {
                    object4 = (ResolvedLocal)resolvedLocals.elementAt(n7);
                    if (((ResolvedLocal)object4).name.equals(string)) {
                        n = 1;
                    }
                    ++n7;
                }
                if (n != 0) {
                    bl = true;
                    LocalVariableInfo.params[n8].name = String.valueOf(string) + LocalVariableInfo.diff();
                    continue block4;
                }
                ++n8;
            }
            int n10 = 0;
            while (n10 < resolvedLocals.size()) {
                n = 0;
                ResolvedLocal resolvedLocal = (ResolvedLocal)resolvedLocals.elementAt(n10);
                if (Decompiler.isFieldName(resolvedLocal.name)) {
                    n = 1;
                }
                if (AnalyzerUtilities.isClassName(resolvedLocal.name)) {
                    n = 1;
                }
                n7 = 0;
                while (n7 < params.length) {
                    object4 = LocalVariableInfo.params[n7].name;
                    if (((String)object4).equals(resolvedLocal.name)) {
                        n = 1;
                    }
                    ++n7;
                }
                int n11 = 0;
                while (n11 < resolvedLocals.size()) {
                    if (n10 != n11) {
                        ResolvedLocal resolvedLocal2 = (ResolvedLocal)resolvedLocals.elementAt(n11);
                        if (resolvedLocal.name.equals(resolvedLocal2.name)) {
                            n = 1;
                        }
                    }
                    ++n11;
                }
                if (n != 0) {
                    bl = true;
                    resolvedLocal.name = String.valueOf(resolvedLocal.name) + LocalVariableInfo.diff();
                    continue block4;
                }
                ++n10;
            }
        }
    }

    public static void used(LocalDescriptor localDescriptor, Instruction instruction, String string) throws DecompilerException {
        if (string == "subroutineReturnAddress") {
            return;
        }
        if (instruction == null) {
            throw new DecompilerException(1211);
        }
        variables.addElement(new VariableUsage(localDescriptor, instruction, false));
    }

    private static boolean usedIn(ResolvedLocal resolvedLocal, CodeBlock codeBlock) {
        int n = 0;
        while (n < resolvedLocal.blocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)resolvedLocal.blocks.elementAt(n);
            if (codeBlock2 == codeBlock) {
                return true;
            }
            if (!codeBlock.simple() && codeBlock.containsAsSubBlock(codeBlock2)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

