/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.util.Vector;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.CodeBlock;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.ExpandableArray;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.TargetSet;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.structures.TryEntry;

public class CodeBlockAnalyzer {
    private static CodeBlock e;
    private static CodeBlock methodBlock;
    private static UniqueVector instructionList;
    private static long startTime;
    private static long currTime;
    private static boolean debugTime;
    private static boolean debug;
    private static UniqueVector codeIslands;

    static {
        debugTime = false;
        debug = false;
    }

    private static void addBlocksReachableOnlyAcross(CodeBlock codeBlock, CodeBlock codeBlock2, UniqueVector uniqueVector, CodeBlock codeBlock3, CodeBlock codeBlock4, CodeBlock codeBlock5) throws DecompilerException {
        CodeBlockAnalyzer.addIfBlocksReachableOnlyAcross(codeBlock2, uniqueVector, codeBlock3, codeBlock4);
    }

    private static void addBlocksReachableOnlyThroughExcluding(CodeBlock codeBlock, CodeBlock codeBlock2, UniqueVector uniqueVector, CodeBlock codeBlock3) throws DecompilerException {
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock4 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (!(codeBlock.containsDirectly(codeBlock4) || !CodeBlockAnalyzer.canBeReached(codeBlock2.entry, codeBlock4, codeBlock2, null, null) || CodeBlockAnalyzer.canBeReached(codeBlock2.entry, codeBlock4, codeBlock2, null, codeBlock.entry) || codeBlock4.equals(codeBlock3) || CodeBlockAnalyzer.canBeReached(codeBlock3, codeBlock4, codeBlock2, null, null))) {
                codeBlock.addSubBlock(codeBlock4);
                if (uniqueVector != null) {
                    uniqueVector.addElement(codeBlock4);
                }
            }
            ++n;
        }
    }

    private static void addBlocksToCatch(CodeBlock codeBlock, CodeBlock codeBlock2, Instruction instruction) throws DecompilerException {
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (!codeBlock.containsDirectly(codeBlock3) && CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock3, codeBlock2, null, null) && !CodeBlockAnalyzer.canBeReached(codeBlock2.entry, codeBlock3, codeBlock2, null, null) && !CodeBlockAnalyzer.canBeReachedByIslands(codeBlock3, instruction)) {
                codeBlock.addSubBlock(codeBlock3);
            }
            ++n;
        }
    }

    private static void addCaseBlocksReachableOnlyThrough(CodeBlock codeBlock, CodeBlock codeBlock2, UniqueVector uniqueVector) throws DecompilerException {
        CodeBlockAnalyzer.setSearch(codeBlock2, false);
        CodeBlockAnalyzer.setProcessed(codeBlock2, false);
        codeBlock.entry.setNextNoLoop(true, null);
        CodeBlockAnalyzer.setProcessed(codeBlock2, false);
        codeBlock2.entry.setNextNoLoop(false, codeBlock.entry);
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (codeBlock3.search) {
                codeBlock.addSubBlock(codeBlock3);
                uniqueVector.addElement(codeBlock3);
            }
            ++n;
        }
    }

    private static void addIfBlocksReachableOnlyAcross(CodeBlock codeBlock, UniqueVector uniqueVector, CodeBlock codeBlock2, CodeBlock codeBlock3) throws DecompilerException {
        UniqueVector uniqueVector2 = new UniqueVector();
        CodeBlockAnalyzer.setSearch(codeBlock, false);
        CodeBlockAnalyzer.setProcessed(codeBlock, false);
        codeBlock2.setNextNoLoop(true, null);
        CodeBlockAnalyzer.setProcessed(codeBlock, false);
        codeBlock.entry.setNextNoLoop(false, codeBlock3);
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock4 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            if (codeBlock4.search) {
                uniqueVector.addElement(codeBlock4);
            }
            ++n;
        }
    }

    private static void addLoopBlocksReachableOnlyThrough(CodeBlock codeBlock, CodeBlock codeBlock2, UniqueVector uniqueVector) throws DecompilerException {
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (!codeBlock.containsDirectly(codeBlock3) && CodeBlockAnalyzer.canBeReached(codeBlock2.entry, codeBlock3, codeBlock2, null, null) && !CodeBlockAnalyzer.canBeReached(codeBlock2.entry, codeBlock3, codeBlock2, null, codeBlock.entry)) {
                codeBlock.addSubBlock(codeBlock3);
                if (uniqueVector != null) {
                    uniqueVector.addElement(codeBlock3);
                }
            }
            ++n;
        }
    }

    private static boolean allReachableOnlyThrough(CodeBlock codeBlock, CodeBlock codeBlock2) throws DecompilerException {
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock3, codeBlock2, null, null) && CodeBlockAnalyzer.canBeReached(codeBlock2.entry, codeBlock3, codeBlock2, null, codeBlock.entry)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void analyze(CodeBlock codeBlock, UniqueVector uniqueVector, UniqueVector uniqueVector2, ExpandableArray expandableArray, UniqueVector uniqueVector3) throws DecompilerException {
        methodBlock = codeBlock;
        instructionList = uniqueVector;
        codeIslands = uniqueVector3;
        if (debug) {
            AnalyzerUtilities.p("start");
            methodBlock.print(true);
        }
        startTime = System.currentTimeMillis();
        CodeBlockAnalyzer.time(10);
        CodeBlockAnalyzer.makeTryBlocks(uniqueVector2, expandableArray);
        CodeBlockAnalyzer.time(11);
        CodeBlockAnalyzer.makeLoopsInBlock(methodBlock);
        CodeBlockAnalyzer.time(12);
        CodeBlockAnalyzer.makeIfsInBlock(methodBlock);
        CodeBlockAnalyzer.time(13);
        CodeBlockAnalyzer.makeSwitchesInBlock(methodBlock);
        CodeBlockAnalyzer.time(14);
        CodeBlockAnalyzer.orderBlocksInBlock(methodBlock, null, null);
        CodeBlockAnalyzer.time(15);
        CodeBlockAnalyzer.setBreaks(methodBlock);
    }

    private static boolean canBeReached(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3, CodeBlock codeBlock4, CodeBlock codeBlock5) throws DecompilerException {
        CodeBlockAnalyzer.setSearch(codeBlock3, true);
        boolean bl = codeBlock4 != null || codeBlock5 != null ? CodeBlockAnalyzer.reachable(codeBlock, codeBlock2, codeBlock3, codeBlock4, codeBlock5) : CodeBlockAnalyzer.reachableFast(codeBlock, codeBlock2, codeBlock3);
        return bl;
    }

    private static boolean canBeReachedByIslands(CodeBlock codeBlock, Instruction instruction) throws DecompilerException {
        int n = 0;
        while (n < codeIslands.size()) {
            Instruction instruction2 = (Instruction)codeIslands.elementAt(n);
            if (!instruction2.equals(instruction) && methodBlock.containsDirectly(instruction2.enclosingCodeBlock) && methodBlock.containsDirectly(codeBlock) && CodeBlockAnalyzer.canBeReached(instruction2.enclosingCodeBlock, codeBlock, methodBlock, null, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static CodeBlock checkChainValidReturnLast(CodeBlock codeBlock, int n) throws DecompilerException {
        CodeBlock codeBlock2;
        CodeBlock codeBlock3 = codeBlock2 = codeBlock.entry;
        int n2 = 1;
        while (true) {
            if (debug) {
                AnalyzerUtilities.p("   " + codeBlock2.name());
            }
            if ((codeBlock2 = codeBlock2.nextBlock) == null) break;
            codeBlock3 = codeBlock2;
            ++n2;
        }
        if (n2 != n) {
            CodeBlockAnalyzer.listBlocks(codeBlock);
            methodBlock.print(true);
            Decompiler.report("Invalid block count in block ordering algorithm");
        }
        if (codeBlock3.nextBlock != null) {
            Decompiler.report("Invalid following block in block ordering algorithm");
        }
        return codeBlock3;
    }

    private static int complexity(UniqueVector uniqueVector) {
        int n = 0;
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            n += ((CodeBlock)uniqueVector.elementAt(n2)).complexity();
            ++n2;
        }
        return n;
    }

    private static void deleteNonReachable(CodeBlock codeBlock) throws DecompilerException {
        UniqueVector uniqueVector = new UniqueVector();
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            uniqueVector.addElement(codeBlock2);
            if (!codeBlock2.equals(codeBlock.entry) && !CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock2, codeBlock, null, null)) {
                if (!codeBlock2.simple()) {
                    if (codeBlock2.type == "FINALLY" && Decompiler.someSynchs) {
                        Decompiler.report("Assuming finally block is for synchronized block");
                    } else {
                        Decompiler.report(String.valueOf(codeBlock2.name()) + " is unreachable");
                    }
                }
                uniqueVector.removeElement(codeBlock2);
            }
            ++n;
        }
        codeBlock.subBlocks = uniqueVector;
        int n2 = 0;
        while (n2 < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock.subBlocks.elementAt(n2);
            if (!codeBlock3.simple()) {
                CodeBlockAnalyzer.deleteNonReachable(codeBlock3);
            }
            ++n2;
        }
    }

    private static CodeBlock endOfChain(CodeBlock codeBlock) {
        while (codeBlock.nextBlock != null) {
            codeBlock = codeBlock.nextBlock;
        }
        return codeBlock;
    }

    private static void fillNextBlockList(CodeBlock codeBlock) {
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            int n2 = 0;
            while (n2 < codeBlock2.nextBlockList.size()) {
                CodeBlock codeBlock3 = (CodeBlock)codeBlock2.nextBlockList.elementAt(n2);
                if (!codeBlock.containsAsSubBlock(codeBlock3)) {
                    codeBlock.addNextBlockList(codeBlock3);
                }
                ++n2;
            }
            ++n;
        }
    }

    private static CodeBlock findCaseBlockStartingAt(UniqueVector uniqueVector, int n) {
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            CodeBlock codeBlock = (CodeBlock)uniqueVector.elementAt(n2);
            if (codeBlock.type == "CASE" && codeBlock.startLocation() == n) {
                return codeBlock;
            }
            ++n2;
        }
        return null;
    }

    private static void findEntry(CodeBlock codeBlock, CodeBlock codeBlock2) throws DecompilerException {
        e = null;
        CodeBlockAnalyzer.searchEntry(codeBlock, methodBlock);
        if (e == null) {
            if (!codeBlock.containsAsSubBlock(codeBlock2.entry)) {
                if (codeBlock.subBlocks.size() != 1) {
                    throw new DecompilerException(1201);
                }
                codeBlock.entry = (CodeBlock)codeBlock.subBlocks.elementAt(0);
            } else {
                codeBlock.entry = codeBlock2.entry;
            }
        } else {
            codeBlock.entry = e;
        }
    }

    private static TargetSet findTargetSet(UniqueVector uniqueVector, int n) {
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            if (((TargetSet)uniqueVector.elementAt((int)n2)).targetLocation == n) {
                return (TargetSet)uniqueVector.elementAt(n2);
            }
            ++n2;
        }
        return null;
    }

    private static CodeBlock getEnclosingBlockWithin(CodeBlock codeBlock, CodeBlock codeBlock2) throws DecompilerException {
        if (debug) {
            AnalyzerUtilities.p("getEnclosingBlockWithin find " + codeBlock.name() + " within " + codeBlock2.name());
        }
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (codeBlock3.equals(codeBlock)) {
                return codeBlock;
            }
            if (!codeBlock3.simple() && codeBlock3.containsAsSubBlock(codeBlock)) {
                return codeBlock3;
            }
            ++n;
        }
        throw new DecompilerException(8235);
    }

    private static CodeBlock getInnerMostEnclosingBlock(CodeBlock codeBlock, CodeBlock codeBlock2) throws DecompilerException {
        if (debug) {
            AnalyzerUtilities.p("getEnclosingBlock find " + codeBlock.name() + " within " + codeBlock2.name());
        }
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (codeBlock3.equals(codeBlock)) {
                return codeBlock2;
            }
            if (!codeBlock3.simple() && codeBlock3.containsAsSubBlock(codeBlock)) {
                return CodeBlockAnalyzer.getInnerMostEnclosingBlock(codeBlock, codeBlock3);
            }
            ++n;
        }
        throw new DecompilerException(8239);
    }

    private static CodeBlock getInnerMostEnclosingBlock2(CodeBlock codeBlock) throws DecompilerException {
        if (codeBlock.superBlock == null) {
            throw new DecompilerException(8251);
        }
        return codeBlock.superBlock;
    }

    private static CodeBlock getInnerMostEnclosingTryBlock(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3) throws DecompilerException {
        if (debug) {
            AnalyzerUtilities.p("getEnclosingTryBlock find " + codeBlock.name() + " within " + codeBlock2.name());
        }
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock4 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (codeBlock4.equals(codeBlock)) {
                return codeBlock3;
            }
            if (!codeBlock4.simple() && codeBlock4.containsAsSubBlock(codeBlock)) {
                if (codeBlock4.type == "TRY") {
                    return CodeBlockAnalyzer.getInnerMostEnclosingTryBlock(codeBlock, codeBlock4, codeBlock4);
                }
                return CodeBlockAnalyzer.getInnerMostEnclosingTryBlock(codeBlock, codeBlock4, codeBlock3);
            }
            ++n;
        }
        throw new DecompilerException(8237);
    }

    private static CodeBlock getInnerMostEnclosingTryBlock2(CodeBlock codeBlock) {
        CodeBlock codeBlock2 = codeBlock.superBlock;
        if (codeBlock2 == null) {
            return methodBlock;
        }
        if (codeBlock2.type == "TRY") {
            return codeBlock2;
        }
        return CodeBlockAnalyzer.getInnerMostEnclosingTryBlock2(codeBlock2);
    }

    private static CodeBlock getLoopContaining(CodeBlock codeBlock, CodeBlock codeBlock2) {
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (codeBlock3.type == "LOOP" && codeBlock3.containsAsSubBlock(codeBlock)) {
                CodeBlock codeBlock4 = CodeBlockAnalyzer.getLoopContaining(codeBlock, codeBlock3);
                if (codeBlock4 != null) {
                    return codeBlock4;
                }
                return codeBlock3;
            }
            ++n;
        }
        return null;
    }

    private static TargetSet getNextStarterCase(UniqueVector uniqueVector) {
        if (uniqueVector.size() == 1) {
            return (TargetSet)uniqueVector.elementAt(0);
        }
        TargetSet targetSet = (TargetSet)uniqueVector.elementAt(0);
        if (targetSet.isDefault) {
            targetSet = (TargetSet)uniqueVector.elementAt(1);
        }
        int n = targetSet.smallestValue;
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            TargetSet targetSet2 = (TargetSet)uniqueVector.elementAt(n2);
            if (targetSet2.smallestValue < n && !targetSet2.isDefault) {
                targetSet = targetSet2;
                n = targetSet.smallestValue;
            }
            ++n2;
        }
        return targetSet;
    }

    private static int insideTry(CodeBlock codeBlock, int n, int n2, UniqueVector uniqueVector) throws DecompilerException {
        if (codeBlock.simple()) {
            int n3 = codeBlock.allInstructionsBetween(n, n2, false);
            if (n3 == 1) {
                codeBlock.allInstructionsBetween(n, n2, true);
                DecompilerLibrary.dumpTryEntrys(uniqueVector);
                throw new DecompilerException(8253);
            }
            return n3;
        }
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        while (n6 < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n6);
            n5 = CodeBlockAnalyzer.insideTry(codeBlock2, n, n2, uniqueVector);
            if (n4 < 0) {
                n4 = n5;
            } else if (n4 != n5) {
                throw new DecompilerException(8257);
            }
            ++n6;
        }
        if (n5 < 0) {
            throw new DecompilerException(8281);
        }
        return n5;
    }

    private static boolean legalJump(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3, CodeBlock codeBlock4) {
        if (codeBlock3 == null) {
            if (codeBlock4 == null) {
                return true;
            }
            return codeBlock2.equals(codeBlock4) ^ true;
        }
        if (codeBlock4 == null) {
            return codeBlock.equals(codeBlock3) ^ true;
        }
        return (codeBlock.equals(codeBlock3) && codeBlock2.equals(codeBlock4)) ^ true;
    }

    private static void linkBlocks(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3) throws DecompilerException {
        int n = 0;
        while (n < codeBlock.orderNextList.size()) {
            CodeBlock codeBlock4 = (CodeBlock)codeBlock.orderNextList.elementAt(n);
            if (!codeBlock4.equals(codeBlock2) && !codeBlock2.orderNextList.contains(codeBlock4)) {
                codeBlock2.orderNextList.addElement(codeBlock4);
            }
            ++n;
        }
        if (codeBlock2.isEntryForBlock(methodBlock) != null) {
            throw new DecompilerException(1559);
        }
        codeBlock.nextBlock = codeBlock2;
        codeBlock.orderNextList = new UniqueVector(1, 1);
        codeBlock2.orderPrevList = new UniqueVector(1, 1);
        int n2 = 0;
        while (n2 < codeBlock3.subBlocks.size()) {
            CodeBlock codeBlock5 = (CodeBlock)codeBlock3.subBlocks.elementAt(n2);
            if (!codeBlock5.equals(codeBlock) && !codeBlock5.equals(codeBlock2)) {
                UniqueVector uniqueVector = new UniqueVector(2, 2);
                int n3 = 0;
                while (n3 < codeBlock5.orderPrevList.size()) {
                    CodeBlock codeBlock6 = (CodeBlock)codeBlock5.orderPrevList.elementAt(n3);
                    if (codeBlock6.equals(codeBlock)) {
                        CodeBlock codeBlock7 = CodeBlockAnalyzer.endOfChain(codeBlock2);
                        if (!uniqueVector.contains(codeBlock7)) {
                            uniqueVector.addElement(codeBlock7);
                        }
                    } else if (!uniqueVector.contains(codeBlock6)) {
                        uniqueVector.addElement(codeBlock6);
                    }
                    ++n3;
                }
                codeBlock5.orderPrevList = uniqueVector;
            }
            ++n2;
        }
    }

    private static void listBlocks(CodeBlock codeBlock) {
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            AnalyzerUtilities.p(codeBlock2.name());
            AnalyzerUtilities.p("   next");
            int n2 = 0;
            while (n2 < codeBlock2.orderNextList.size()) {
                AnalyzerUtilities.p("   =" + ((CodeBlock)codeBlock2.orderNextList.elementAt(n2)).name());
                ++n2;
            }
            AnalyzerUtilities.p("   prev");
            int n3 = 0;
            while (n3 < codeBlock2.orderPrevList.size()) {
                AnalyzerUtilities.p("   =" + ((CodeBlock)codeBlock2.orderPrevList.elementAt(n3)).name());
                ++n3;
            }
            String string = "none";
            if (codeBlock2.nextBlock != null) {
                string = codeBlock2.nextBlock.name();
            }
            AnalyzerUtilities.p("   nextblock = " + string);
            ++n;
        }
    }

    private static void makeBreakableBlocks(CodeBlock codeBlock) throws DecompilerException {
        CodeBlock codeBlock2 = codeBlock.entry;
        UniqueVector uniqueVector = new UniqueVector();
        do {
            UniqueVector uniqueVector2 = CodeBlockAnalyzer.pointsAhead(codeBlock2, codeBlock);
            int n = 0;
            while (n < uniqueVector2.size()) {
                uniqueVector.addElement(uniqueVector2.elementAt(n));
                ++n;
            }
        } while ((codeBlock2 = codeBlock2.nextBlock) != null);
        codeBlock2 = codeBlock.entry;
        do {
            if (!uniqueVector.contains(codeBlock2)) continue;
            codeBlock.setOnBreak(codeBlock2);
        } while ((codeBlock2 = codeBlock2.nextBlock) != null);
        if (codeBlock.nextBlock != null && uniqueVector.contains(codeBlock.nextBlock)) {
            codeBlock.setOnBreak(codeBlock.nextBlock);
        }
    }

    private static CodeBlock makeCatchBlockStartingAt(Instruction instruction, CodeBlock codeBlock) throws DecompilerException {
        CodeBlock codeBlock2 = CodeBlockAnalyzer.getInnerMostEnclosingTryBlock(codeBlock, methodBlock, methodBlock);
        if (!codeBlock2.equals(CodeBlockAnalyzer.getInnerMostEnclosingTryBlock2(codeBlock))) {
            throw new DecompilerException(1571);
        }
        CodeBlock codeBlock3 = instruction.enclosingCodeBlock;
        CodeBlock codeBlock4 = new CodeBlock("CATCH");
        codeBlock4.entry = CodeBlockAnalyzer.getEnclosingBlockWithin(codeBlock3, codeBlock2);
        codeBlock4.addSubBlock(codeBlock4.entry);
        CodeBlockAnalyzer.addBlocksToCatch(codeBlock4, codeBlock2, instruction);
        CodeBlockAnalyzer.fillNextBlockList(codeBlock4);
        int n = 0;
        while (n < codeBlock4.subBlocks.size()) {
            codeBlock2.subBlocks.removeElement((CodeBlock)codeBlock4.subBlocks.elementAt(n));
            ++n;
        }
        CodeBlock codeBlock5 = CodeBlockAnalyzer.getInnerMostEnclosingBlock(codeBlock, methodBlock);
        if (!codeBlock5.equals(CodeBlockAnalyzer.getInnerMostEnclosingBlock2(codeBlock))) {
            throw new DecompilerException(1573);
        }
        codeBlock5.addSubBlock(codeBlock4);
        return codeBlock4;
    }

    private static CodeBlock makeFinallyBlockStartingAt(Instruction instruction) throws DecompilerException {
        CodeBlock codeBlock = instruction.enclosingCodeBlock;
        if (codeBlock == null) {
            throw new DecompilerException(8231);
        }
        CodeBlock codeBlock2 = CodeBlockAnalyzer.getInnerMostEnclosingTryBlock(codeBlock, methodBlock, methodBlock);
        CodeBlock codeBlock3 = new CodeBlock("FINALLY");
        codeBlock3.entry = CodeBlockAnalyzer.getEnclosingBlockWithin(codeBlock, codeBlock2);
        codeBlock3.addSubBlock(codeBlock3.entry);
        CodeBlockAnalyzer.addBlocksToCatch(codeBlock3, codeBlock2, instruction);
        CodeBlockAnalyzer.fillNextBlockList(codeBlock3);
        if (codeBlock3.nextBlockList.size() != 0) {
            throw new DecompilerException(8232);
        }
        int n = 0;
        while (n < codeBlock3.subBlocks.size()) {
            codeBlock2.subBlocks.removeElement((CodeBlock)codeBlock3.subBlocks.elementAt(n));
            ++n;
        }
        methodBlock.addSubBlock(codeBlock3);
        return codeBlock3;
    }

    private static void makeIfsInBlock(CodeBlock codeBlock) throws DecompilerException {
        CodeBlockAnalyzer.makeSubIfs(codeBlock);
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlockAnalyzer.makeIfsInBlock((CodeBlock)codeBlock.subBlocks.elementAt(n));
            ++n;
        }
    }

    private static void makeLoopsInBlock(CodeBlock codeBlock) throws DecompilerException {
        CodeBlockAnalyzer.makeSubLoops(codeBlock);
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlockAnalyzer.makeLoopsInBlock((CodeBlock)codeBlock.subBlocks.elementAt(n));
            ++n;
        }
    }

    private static boolean makeOneSubIf(CodeBlock codeBlock) throws DecompilerException {
        if (codeBlock.type == "IF") {
            return false;
        }
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            if (codeBlock2.simple() && codeBlock2.last.type == "CONDBRANCH" && codeBlock2.nextBlockList.size() < 3) {
                boolean bl;
                CodeBlock codeBlock3;
                CodeBlock codeBlock4;
                CodeBlock codeBlock5 = new CodeBlock("IF");
                UniqueVector uniqueVector = new UniqueVector();
                codeBlock5.addSubBlock(codeBlock2);
                uniqueVector.addElement(codeBlock2);
                codeBlock5.entry = codeBlock2;
                CodeBlock codeBlock6 = new CodeBlock("IFTRUE");
                CodeBlock codeBlock7 = new CodeBlock("IFFALSE");
                if (codeBlock2.nextBlockList.size() == 2) {
                    codeBlock4 = (CodeBlock)codeBlock2.nextBlockList.elementAt(1);
                    codeBlock3 = (CodeBlock)codeBlock2.nextBlockList.elementAt(0);
                } else if (codeBlock2.nextBlockList.size() == 1) {
                    codeBlock3 = codeBlock4 = (CodeBlock)codeBlock2.nextBlockList.elementAt(0);
                } else {
                    throw new DecompilerException(16001);
                }
                if (!codeBlock4.equals(codeBlock2.getTrueBranch(false)) && codeBlock4.startLocation() != codeBlock2.getTrueBranch(false).startLocation()) {
                    AnalyzerUtilities.p(String.valueOf(codeBlock2.getTrueBranch(false).name()) + " " + codeBlock4.name());
                }
                if (!codeBlock3.equals(codeBlock2.getFalseBranch(false)) && codeBlock3.startLocation() != codeBlock2.getFalseBranch(false).startLocation()) {
                    AnalyzerUtilities.p(String.valueOf(codeBlock2.getFalseBranch(false).name()) + " " + codeBlock3.name());
                }
                UniqueVector uniqueVector2 = new UniqueVector();
                if (codeBlock.containsDirectly(codeBlock4) && CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock4, codeBlock, null, null) && !CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock4, codeBlock, codeBlock2, codeBlock4)) {
                    if (debugTime) {
                        AnalyzerUtilities.p("start reach");
                    }
                    CodeBlockAnalyzer.addBlocksReachableOnlyAcross(codeBlock6, codeBlock, uniqueVector2, codeBlock2, codeBlock4, codeBlock3);
                    if (debugTime) {
                        AnalyzerUtilities.p("add true");
                    }
                }
                UniqueVector uniqueVector3 = new UniqueVector();
                if (codeBlock.containsDirectly(codeBlock3) && CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock3, codeBlock, null, null) && !CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock3, codeBlock, codeBlock2, codeBlock3)) {
                    if (debugTime) {
                        AnalyzerUtilities.p("start reach");
                    }
                    CodeBlockAnalyzer.addBlocksReachableOnlyAcross(codeBlock7, codeBlock, uniqueVector3, codeBlock2, codeBlock3, codeBlock4);
                    if (debugTime) {
                        AnalyzerUtilities.p("add false");
                    }
                }
                boolean bl2 = false;
                boolean bl3 = bl = codeBlock.type == "LOOP" && codeBlock2.equals(codeBlock.entry);
                if (!bl && uniqueVector3.size() > 0 && uniqueVector2.size() > 0) {
                    boolean bl4 = CodeBlockAnalyzer.neverContinuesInBlock(uniqueVector2, codeBlock);
                    boolean bl5 = CodeBlockAnalyzer.neverContinuesInBlock(uniqueVector3, codeBlock);
                    if (bl4 && bl5) {
                        if (CodeBlockAnalyzer.complexity(uniqueVector2) > CodeBlockAnalyzer.complexity(uniqueVector3)) {
                            CodeBlockAnalyzer.processIfBranch(codeBlock7, codeBlock5, codeBlock, uniqueVector, uniqueVector3);
                        } else {
                            CodeBlockAnalyzer.processIfBranch(codeBlock6, codeBlock5, codeBlock, uniqueVector, uniqueVector2);
                        }
                        bl2 = true;
                    } else if (bl4) {
                        CodeBlockAnalyzer.processIfBranch(codeBlock6, codeBlock5, codeBlock, uniqueVector, uniqueVector2);
                        bl2 = true;
                    } else if (bl5) {
                        CodeBlockAnalyzer.processIfBranch(codeBlock7, codeBlock5, codeBlock, uniqueVector, uniqueVector3);
                        bl2 = true;
                    }
                }
                if (!bl2) {
                    CodeBlockAnalyzer.processIfBranch(codeBlock7, codeBlock5, codeBlock, uniqueVector, uniqueVector3);
                    CodeBlockAnalyzer.processIfBranch(codeBlock6, codeBlock5, codeBlock, uniqueVector, uniqueVector2);
                }
                CodeBlockAnalyzer.moveBlocks(codeBlock, codeBlock5, uniqueVector, false);
                if (debug) {
                    AnalyzerUtilities.p("After if");
                    methodBlock.print(false);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean makeOneSubLoop(CodeBlock codeBlock) throws DecompilerException {
        int n = codeBlock.subBlocks.size();
        UniqueVector uniqueVector = new UniqueVector();
        int n2 = 0;
        while (n2 < n) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n2);
            if (CodeBlockAnalyzer.canBeReached(codeBlock2, codeBlock2, codeBlock, null, null)) {
                CodeBlock codeBlock3;
                CodeBlock codeBlock4 = new CodeBlock("LOOP");
                codeBlock4.addSubBlock(codeBlock2);
                uniqueVector.addElement(codeBlock2);
                int n3 = 0;
                while (n3 < n) {
                    codeBlock3 = (CodeBlock)codeBlock.subBlocks.elementAt(n3);
                    if (!codeBlock3.equals(codeBlock2) && CodeBlockAnalyzer.canBeReached(codeBlock3, codeBlock2, codeBlock, null, null) && CodeBlockAnalyzer.canBeReached(codeBlock2, codeBlock3, codeBlock, null, null)) {
                        codeBlock4.addSubBlock(codeBlock3);
                        uniqueVector.addElement(codeBlock3);
                    }
                    ++n3;
                }
                CodeBlockAnalyzer.findEntry(codeBlock4, codeBlock);
                boolean cfr_ignored_0 = CodeBlockAnalyzer.allReachableOnlyThrough(codeBlock4, codeBlock) ^ true;
                if (false) {
                    CodeBlockAnalyzer.addLoopBlocksReachableOnlyThrough(codeBlock4, codeBlock, uniqueVector);
                    CodeBlockAnalyzer.moveBlocks(codeBlock, codeBlock4, uniqueVector, false);
                } else {
                    codeBlock3 = null;
                    if (codeBlock4.entry.type == "SIMPLECONDBRANCH") {
                        CodeBlock codeBlock5 = codeBlock4.entry.getTrueBranch(true);
                        CodeBlock codeBlock6 = codeBlock4.entry.getFalseBranch(true);
                        if (!codeBlock4.containsAsSubBlock(codeBlock5) && codeBlock.containsDirectly(codeBlock5)) {
                            codeBlock3 = codeBlock5;
                        } else if (!codeBlock4.containsAsSubBlock(codeBlock6) && codeBlock.containsDirectly(codeBlock6)) {
                            codeBlock3 = codeBlock6;
                        }
                    } else {
                        codeBlock3 = CodeBlockAnalyzer.mostComplexPathOut(codeBlock4);
                    }
                    boolean bl = false;
                    if (codeBlock3 == null) {
                        bl = true;
                    }
                    if (!codeBlock.containsDirectly(codeBlock3)) {
                        bl = true;
                    }
                    if (bl) {
                        CodeBlockAnalyzer.addLoopBlocksReachableOnlyThrough(codeBlock4, codeBlock, uniqueVector);
                    } else {
                        CodeBlockAnalyzer.addBlocksReachableOnlyThroughExcluding(codeBlock4, codeBlock, uniqueVector, codeBlock3);
                    }
                    CodeBlockAnalyzer.moveBlocks(codeBlock, codeBlock4, uniqueVector, false);
                }
                if (debug) {
                    methodBlock.print(false);
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean makeOneSubSwitch(CodeBlock codeBlock) throws DecompilerException {
        if (codeBlock.type == "SWITCH") {
            return false;
        }
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            if (codeBlock2.simple() && codeBlock2.last.type == "MULTIBRANCH") {
                CodeBlock codeBlock3 = new CodeBlock("SWITCH");
                UniqueVector uniqueVector = new UniqueVector();
                codeBlock3.addSubBlock(codeBlock2);
                uniqueVector.addElement(codeBlock2);
                codeBlock3.entry = codeBlock2;
                UniqueVector uniqueVector2 = new UniqueVector();
                int n2 = 0;
                while (n2 < codeBlock2.nextBlockList.size()) {
                    CodeBlock codeBlock4 = (CodeBlock)codeBlock2.nextBlockList.elementAt(n2);
                    if (!uniqueVector2.contains(codeBlock4)) {
                        uniqueVector2.addElement(codeBlock4);
                    }
                    ++n2;
                }
                int n3 = 0;
                while (n3 < uniqueVector2.size()) {
                    CodeBlock codeBlock5 = (CodeBlock)uniqueVector2.elementAt(n3);
                    CodeBlock codeBlock6 = new CodeBlock("CASE");
                    UniqueVector uniqueVector3 = new UniqueVector();
                    if (debugTime) {
                        AnalyzerUtilities.p("attempt to add case block");
                    }
                    if (codeBlock.containsDirectly(codeBlock5) && CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock5, codeBlock, null, null) && !CodeBlockAnalyzer.canBeReached(codeBlock.entry, codeBlock5, codeBlock, codeBlock2, null) && codeBlock5.numberOfReferringInstructions() <= 2) {
                        codeBlock6.addSubBlock(codeBlock5);
                        codeBlock6.entry = codeBlock5;
                        CodeBlockAnalyzer.addCaseBlocksReachableOnlyThrough(codeBlock6, codeBlock, uniqueVector3);
                        if (debugTime) {
                            AnalyzerUtilities.p("add case block");
                        }
                    }
                    if (codeBlock6.subBlocks.size() > 0) {
                        CodeBlockAnalyzer.findEntry(codeBlock6, codeBlock);
                        CodeBlockAnalyzer.moveBlocks(codeBlock, codeBlock6, uniqueVector3, false);
                        codeBlock3.addSubBlock(codeBlock6);
                        uniqueVector.addElement(codeBlock6);
                    }
                    ++n3;
                }
                CodeBlockAnalyzer.moveBlocks(codeBlock, codeBlock3, uniqueVector, false);
                if (debug) {
                    methodBlock.print(false);
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    private static void makeSubIfs(CodeBlock codeBlock) throws DecompilerException {
        while (CodeBlockAnalyzer.makeOneSubIf(codeBlock)) {
        }
    }

    private static void makeSubLoops(CodeBlock codeBlock) throws DecompilerException {
        while (CodeBlockAnalyzer.makeOneSubLoop(codeBlock)) {
        }
    }

    private static void makeSubSwitches(CodeBlock codeBlock) throws DecompilerException {
        while (CodeBlockAnalyzer.makeOneSubSwitch(codeBlock)) {
        }
    }

    private static void makeSwitchesInBlock(CodeBlock codeBlock) throws DecompilerException {
        CodeBlockAnalyzer.makeSubSwitches(codeBlock);
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlockAnalyzer.makeSwitchesInBlock((CodeBlock)codeBlock.subBlocks.elementAt(n));
            ++n;
        }
    }

    private static void makeTryBlocks(UniqueVector uniqueVector, ExpandableArray expandableArray) throws DecompilerException {
        CodeBlock codeBlock;
        Object object;
        int n;
        Object object2;
        Object object3;
        int n2;
        int n3;
        Object object4;
        UniqueVector uniqueVector2 = new UniqueVector();
        int n4 = 0;
        while (n4 < uniqueVector.size()) {
            object4 = (TryEntry)uniqueVector.elementAt(n4);
            n3 = ((TryEntry)object4).startPC;
            n2 = ((TryEntry)object4).inactivePC;
            object3 = new UniqueVector();
            int n5 = 0;
            while (n5 < CodeBlockAnalyzer.methodBlock.subBlocks.size()) {
                object2 = (CodeBlock)CodeBlockAnalyzer.methodBlock.subBlocks.elementAt(n5);
                n = CodeBlockAnalyzer.insideTry((CodeBlock)object2, n3, n2, uniqueVector);
                if (n != 1 && n == 2) {
                    ((Vector)object3).addElement(object2);
                }
                ++n5;
            }
            if (((Vector)object3).size() < 1) {
                Decompiler.report("Empty try block found");
            } else {
                object2 = new CodeBlock("TRY");
                uniqueVector2.addElement(object2);
                n = 0;
                while (n < ((Vector)object3).size()) {
                    ((CodeBlock)object2).addSubBlock((CodeBlock)((Vector)object3).elementAt(n));
                    ++n;
                }
                CodeBlockAnalyzer.findEntry((CodeBlock)object2, methodBlock);
                CodeBlockAnalyzer.moveBlocks(methodBlock, (CodeBlock)object2, null, true);
                if (debug) {
                    AnalyzerUtilities.p("after try");
                    methodBlock.print(true);
                }
            }
            ++n4;
        }
        object4 = new UniqueVector();
        n3 = 0;
        while (n3 < uniqueVector2.size()) {
            TryEntry tryEntry = (TryEntry)uniqueVector.elementAt(n3);
            object3 = (CodeBlock)uniqueVector2.elementAt(n3);
            CodeBlock codeBlock2 = new CodeBlock("TRYCATCHFINALLY");
            ((Vector)object4).addElement(codeBlock2);
            object2 = CodeBlockAnalyzer.getInnerMostEnclosingBlock((CodeBlock)object3, methodBlock);
            if (!((CodeBlock)object2).equals(CodeBlockAnalyzer.getInnerMostEnclosingBlock2((CodeBlock)object3))) {
                throw new DecompilerException(1539);
            }
            n = 0;
            while (n < tryEntry.handlerInstructions.size()) {
                object = Decompiler.findInstruction(tryEntry.handlerInstructions.get(n), instructionList);
                codeBlock = CodeBlockAnalyzer.makeCatchBlockStartingAt((Instruction)object, (CodeBlock)object3);
                codeBlock2.addSubBlock(codeBlock);
                ((CodeBlock)object3).nextBlockList.addElement(codeBlock);
                ++n;
            }
            codeBlock2.addSubBlock((CodeBlock)object3);
            codeBlock2.entry = object3;
            CodeBlockAnalyzer.moveBlocks((CodeBlock)object2, codeBlock2, null, false);
            if (debug) {
                methodBlock.print(true);
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < expandableArray.size()) {
            object3 = Decompiler.findInstruction(expandableArray.get(n2), instructionList);
            CodeBlock codeBlock3 = CodeBlockAnalyzer.makeFinallyBlockStartingAt((Instruction)object3);
            if (debug) {
                AnalyzerUtilities.p("make finally block " + codeBlock3.name());
            }
            ++n2;
        }
        int n6 = 0;
        while (n6 < ((Vector)object4).size()) {
            CodeBlock codeBlock4 = (CodeBlock)((Vector)object4).elementAt(n6);
            object2 = (TryEntry)uniqueVector.elementAt(n6);
            if (((TryEntry)object2).mayBeWrapper) {
                if (((TryEntry)object2).synch) {
                    Decompiler.report("Converting try block to synchronized - probably OK");
                    object = codeBlock4.findTry();
                    if (object != null && ((TryEntry)object2).synch) {
                        ((CodeBlock)object).synch = true;
                    }
                    codeBlock4.removeSingleCatch();
                } else {
                    codeBlock = methodBlock.findFinallyStartingAt(((TryEntry)object2).finallyStart);
                    if (codeBlock != null) {
                        CodeBlock codeBlock5 = codeBlock4.protectedTryCatch();
                        if (codeBlock5 != null) {
                            CodeBlock codeBlock6 = CodeBlockAnalyzer.getInnerMostEnclosingBlock(codeBlock4, methodBlock);
                            codeBlock6.subBlocks.removeElement(codeBlock4);
                            codeBlock6.addSubBlock(codeBlock5);
                            methodBlock.repointTo(codeBlock4, codeBlock5);
                            codeBlock5.addSubBlock(codeBlock);
                            object = codeBlock5.findTry();
                            if (object != null) {
                                ((CodeBlock)object).addNextBlockList(codeBlock);
                            }
                            CodeBlockAnalyzer.methodBlock.subBlocks.removeElement(codeBlock);
                        } else {
                            Decompiler.report("Found try/finally without catch blocks - probably OK");
                            object = codeBlock4.findTry();
                            if (object != null) {
                                ((CodeBlock)object).addNextBlockList(codeBlock);
                            }
                            codeBlock4.removeSingleCatch();
                            codeBlock4.addSubBlock(codeBlock);
                            CodeBlockAnalyzer.methodBlock.subBlocks.removeElement(codeBlock);
                        }
                    }
                }
            }
            ++n6;
        }
        CodeBlockAnalyzer.deleteNonReachable(methodBlock);
        if (debug) {
            methodBlock.print(true);
        }
    }

    private static CodeBlock mostComplexPathOut(CodeBlock codeBlock) {
        UniqueVector uniqueVector = new UniqueVector();
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            int n2 = 0;
            while (n2 < codeBlock2.nextBlockList.size()) {
                CodeBlock codeBlock3 = (CodeBlock)codeBlock2.nextBlockList.elementAt(n2);
                if (!codeBlock.containsAsSubBlock(codeBlock3) && codeBlock3 != codeBlock) {
                    uniqueVector.addElement(codeBlock3);
                }
                ++n2;
            }
            ++n;
        }
        int n3 = 0;
        CodeBlock codeBlock4 = null;
        int n4 = 0;
        while (n4 < uniqueVector.size()) {
            CodeBlock codeBlock5 = (CodeBlock)uniqueVector.elementAt(n4);
            int n5 = codeBlock5.complexity();
            if (n5 > n3) {
                n3 = n5;
                codeBlock4 = codeBlock5;
            }
            ++n4;
        }
        return codeBlock4;
    }

    private static void moveBlocks(CodeBlock codeBlock, CodeBlock codeBlock2, UniqueVector uniqueVector, boolean bl) throws DecompilerException {
        CodeBlock codeBlock3;
        int n;
        if (uniqueVector != null) {
            n = 0;
            while (n < uniqueVector.size()) {
                codeBlock3 = (CodeBlock)uniqueVector.elementAt(n);
                if (!codeBlock2.containsAsSubBlock(codeBlock3)) {
                    codeBlock2.addSubBlock(codeBlock3);
                }
                ++n;
            }
        }
        n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            codeBlock.subBlocks.removeElement(codeBlock3);
            ++n;
        }
        codeBlock.addSubBlock(codeBlock2);
        CodeBlockAnalyzer.repointEntry(codeBlock2, methodBlock, bl);
        CodeBlockAnalyzer.fillNextBlockList(codeBlock2);
    }

    private static boolean neverContinuesInBlock(UniqueVector uniqueVector, CodeBlock codeBlock) {
        int n = 0;
        while (n < uniqueVector.size()) {
            CodeBlock codeBlock2 = (CodeBlock)uniqueVector.elementAt(n);
            int n2 = 0;
            while (n2 < codeBlock2.nextBlockList.size()) {
                CodeBlock codeBlock3 = (CodeBlock)codeBlock2.nextBlockList.elementAt(n2);
                if (!uniqueVector.contains(codeBlock3)) {
                    return false;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    private static void orderBlocksInBlock(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3) throws DecompilerException {
        CodeBlockAnalyzer.orderOneBlock(codeBlock, codeBlock2, codeBlock3);
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock4 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            CodeBlock codeBlock5 = null;
            if (codeBlock.entry.equals(codeBlock4)) {
                codeBlock5 = codeBlock3 == null ? codeBlock : codeBlock3;
            }
            CodeBlockAnalyzer.orderBlocksInBlock(codeBlock4, codeBlock, codeBlock5);
            ++n;
        }
    }

    private static void orderOneBlock(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3) throws DecompilerException {
        CodeBlock codeBlock4;
        int n;
        if (codeBlock.simple()) {
            return;
        }
        if (codeBlock.orderedContainer()) {
            if (codeBlock.type == "SWITCH") {
                CodeBlockAnalyzer.orderSwitch(codeBlock);
            } else {
                CodeBlockAnalyzer.setNextForAll(codeBlock);
            }
            return;
        }
        UniqueVector uniqueVector = new UniqueVector();
        int n2 = 0;
        while (n2 < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock5 = (CodeBlock)codeBlock.subBlocks.elementAt(n2);
            if (codeBlock5.type != "FINALLY") {
                uniqueVector.addElement(codeBlock5);
            } else {
                Decompiler.report("Found finally not appended to try");
            }
            ++n2;
        }
        if (debug) {
            CodeBlockAnalyzer.listBlocks(codeBlock);
        }
        int n3 = 0;
        while (n3 < uniqueVector.size()) {
            CodeBlock codeBlock6 = (CodeBlock)uniqueVector.elementAt(n3);
            n = 0;
            while (n < codeBlock6.nextBlockList.size()) {
                codeBlock4 = (CodeBlock)codeBlock6.nextBlockList.elementAt(n);
                if (codeBlock.containsDirectly(codeBlock4)) {
                    if (!codeBlock6.equals(codeBlock4)) {
                        codeBlock6.orderNextList.addElement(codeBlock4);
                        if (!codeBlock4.orderPrevList.contains(codeBlock6)) {
                            codeBlock4.orderPrevList.addElement(codeBlock6);
                        }
                    } else if (codeBlock6.type != "LOOP") {
                        throw new DecompilerException(1551);
                    }
                }
                ++n;
            }
            ++n3;
        }
        if (codeBlock.entry.orderPrevList.size() != 0) {
            Decompiler.report("Entry previous list invalid");
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            n = 0;
            while (n < uniqueVector.size()) {
                codeBlock4 = (CodeBlock)uniqueVector.elementAt(n);
                if (codeBlock4.orderPrevList.size() == 1) {
                    CodeBlockAnalyzer.linkBlocks((CodeBlock)codeBlock4.orderPrevList.elementAt(0), codeBlock4, codeBlock);
                    bl = true;
                }
                ++n;
            }
        }
        CodeBlock codeBlock7 = CodeBlockAnalyzer.checkChainValidReturnLast(codeBlock, uniqueVector.size());
        codeBlock7.nextBlock = codeBlock.type == "LOOP" ? codeBlock : codeBlock.nextBlock;
    }

    private static void orderSwitch(CodeBlock codeBlock) throws DecompilerException {
        TargetSet targetSet;
        int n;
        if (codeBlock.entry.last.type != "MULTIBRANCH") {
            throw new DecompilerException(1553);
        }
        UniqueVector uniqueVector = codeBlock.entry.last.nextInstructionList;
        ExpandableArray expandableArray = codeBlock.entry.last.onValueList;
        if (uniqueVector.size() != expandableArray.size()) {
            throw new DecompilerException(1557);
        }
        int n2 = ((Instruction)uniqueVector.elementAt((int)(uniqueVector.size() - 1))).location;
        UniqueVector uniqueVector2 = new UniqueVector();
        int n3 = 0;
        while (n3 < uniqueVector.size()) {
            Instruction instruction = (Instruction)uniqueVector.elementAt(n3);
            n = instruction.location;
            targetSet = CodeBlockAnalyzer.findTargetSet(uniqueVector2, n);
            if (targetSet == null) {
                targetSet = new TargetSet(n, expandableArray.get(n3));
                uniqueVector2.addElement(targetSet);
            } else {
                targetSet.addValue(expandableArray.get(n3));
            }
            if (n == n2) {
                targetSet.isDefault = true;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < uniqueVector2.size()) {
            targetSet = (TargetSet)uniqueVector2.elementAt(n4);
            n = targetSet.targetLocation;
            targetSet.caseBlock = CodeBlockAnalyzer.findCaseBlockStartingAt(codeBlock.subBlocks, n);
            ++n4;
        }
        UniqueVector uniqueVector3 = new UniqueVector();
        int n5 = 0;
        while (n5 < uniqueVector2.size()) {
            targetSet = (TargetSet)uniqueVector2.elementAt(n5);
            if (!CodeBlockAnalyzer.pointedToByAnother(targetSet.caseBlock, uniqueVector2)) {
                uniqueVector3.addElement(targetSet);
            }
            ++n5;
        }
        codeBlock.targetSets = new UniqueVector();
        while (uniqueVector3.size() > 0) {
            TargetSet targetSet2;
            targetSet = CodeBlockAnalyzer.getNextStarterCase(uniqueVector3);
            uniqueVector3.removeElement(targetSet);
            codeBlock.targetSets.addElement(targetSet);
            if (targetSet.caseBlock != null && (targetSet2 = targetSet.getNextTargetSet(uniqueVector2)) != null) {
                targetSet.caseBlock.nextBlock = targetSet2.caseBlock;
            }
            while ((targetSet = targetSet.getNextTargetSet(uniqueVector2)) != null) {
                codeBlock.targetSets.addElement(targetSet);
                if (targetSet.caseBlock == null || (targetSet2 = targetSet.getNextTargetSet(uniqueVector2)) == null) continue;
                targetSet.caseBlock.nextBlock = targetSet2.caseBlock;
            }
        }
        int n6 = 0;
        while (n6 < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n6);
            if (codeBlock2.type == "CASE") {
                boolean bl = false;
                int n7 = 0;
                while (n7 < codeBlock.targetSets.size()) {
                    TargetSet targetSet3 = (TargetSet)codeBlock.targetSets.elementAt(n7);
                    if (targetSet3.caseBlock == codeBlock2) {
                        bl = true;
                        break;
                    }
                    ++n7;
                }
                if (!bl) {
                    throw new DecompilerException(15001);
                }
            }
            ++n6;
        }
    }

    private static boolean pointedToByAnother(CodeBlock codeBlock, UniqueVector uniqueVector) {
        if (codeBlock == null) {
            return false;
        }
        int n = 0;
        while (n < uniqueVector.size()) {
            TargetSet targetSet = (TargetSet)uniqueVector.elementAt(n);
            if (targetSet.caseBlock != null && targetSet.caseBlock != codeBlock) {
                int n2 = 0;
                while (n2 < targetSet.caseBlock.nextBlockList.size()) {
                    CodeBlock codeBlock2 = (CodeBlock)targetSet.caseBlock.nextBlockList.elementAt(n2);
                    if (codeBlock2 == codeBlock) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return false;
    }

    private static UniqueVector pointsAhead(CodeBlock codeBlock, CodeBlock codeBlock2) {
        UniqueVector uniqueVector = new UniqueVector();
        int n = 0;
        while (n < codeBlock.nextBlockList.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock.nextBlockList.elementAt(n);
            if (codeBlock3 != codeBlock.nextBlock) {
                if (codeBlock2.containsAsSubBlock(codeBlock3)) {
                    if (!codeBlock3.equals(codeBlock)) {
                        uniqueVector.addElement(codeBlock3);
                    }
                } else {
                    if (codeBlock2.nextBlock == codeBlock3) {
                        uniqueVector.addElement(codeBlock3);
                    }
                    if (codeBlock2 == codeBlock3) {
                        uniqueVector.addElement(codeBlock3);
                    }
                }
            }
            ++n;
        }
        return uniqueVector;
    }

    private static void processIfBranch(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3, UniqueVector uniqueVector, UniqueVector uniqueVector2) throws DecompilerException {
        if (uniqueVector2.size() > 0) {
            int n = 0;
            while (n < uniqueVector2.size()) {
                codeBlock.addSubBlock((CodeBlock)uniqueVector2.elementAt(n));
                ++n;
            }
            CodeBlockAnalyzer.findEntry(codeBlock, codeBlock3);
            CodeBlockAnalyzer.moveBlocks(codeBlock3, codeBlock, uniqueVector2, false);
            codeBlock2.addSubBlock(codeBlock);
            uniqueVector.addElement(codeBlock);
        }
    }

    private static boolean reachable(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3, CodeBlock codeBlock4, CodeBlock codeBlock5) throws DecompilerException {
        if (!codeBlock3.containsDirectly(codeBlock)) {
            throw new DecompilerException(12023);
        }
        if (!codeBlock3.containsDirectly(codeBlock2)) {
            throw new DecompilerException(12025);
        }
        if (codeBlock.equals(codeBlock5)) {
            return false;
        }
        UniqueVector uniqueVector = codeBlock.nextBlockList;
        int n = 0;
        while (n < uniqueVector.size()) {
            CodeBlock codeBlock6 = (CodeBlock)uniqueVector.elementAt(n);
            if (codeBlock3.containsDirectly(codeBlock6) && codeBlock6.equals(codeBlock2) && CodeBlockAnalyzer.legalJump(codeBlock, codeBlock6, codeBlock4, codeBlock5) && !CodeBlock.jumpToLoopTop(codeBlock, codeBlock6)) {
                return true;
            }
            ++n;
        }
        codeBlock.search = false;
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            CodeBlock codeBlock7 = (CodeBlock)uniqueVector.elementAt(n2);
            if (codeBlock3.containsDirectly(codeBlock7) && codeBlock7.search && CodeBlockAnalyzer.legalJump(codeBlock, codeBlock7, codeBlock4, codeBlock5) && !CodeBlock.jumpToLoopTop(codeBlock, codeBlock7) && CodeBlockAnalyzer.reachable(codeBlock7, codeBlock2, codeBlock3, codeBlock4, codeBlock5)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean reachableFast(CodeBlock codeBlock, CodeBlock codeBlock2, CodeBlock codeBlock3) throws DecompilerException {
        if (!codeBlock3.containsDirectly(codeBlock)) {
            throw new DecompilerException(12021);
        }
        if (!codeBlock3.containsDirectly(codeBlock2)) {
            throw new DecompilerException(12022);
        }
        UniqueVector uniqueVector = codeBlock.nextBlockList;
        int n = 0;
        while (n < uniqueVector.size()) {
            CodeBlock codeBlock4 = (CodeBlock)uniqueVector.elementAt(n);
            if (codeBlock4.equals(codeBlock2) && codeBlock3.containsDirectly(codeBlock4) && (codeBlock4.type != "LOOP" || !codeBlock4.containsAsSubBlock(codeBlock) && !codeBlock4.equals(codeBlock))) {
                return true;
            }
            ++n;
        }
        codeBlock.search = false;
        int n2 = 0;
        while (n2 < uniqueVector.size()) {
            CodeBlock codeBlock5 = (CodeBlock)uniqueVector.elementAt(n2);
            if (codeBlock5.search && codeBlock3.containsDirectly(codeBlock5) && (codeBlock5.type != "LOOP" || !codeBlock5.containsAsSubBlock(codeBlock) && !codeBlock5.equals(codeBlock)) && CodeBlockAnalyzer.reachableFast(codeBlock5, codeBlock2, codeBlock3)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static void repointEntry(CodeBlock codeBlock, CodeBlock codeBlock2, boolean bl) throws DecompilerException {
        if (!codeBlock.equals(codeBlock2) && codeBlock.containsDirectly(codeBlock2.entry)) {
            codeBlock2.entry = codeBlock;
        }
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (!codeBlock3.simple()) {
                CodeBlockAnalyzer.repointEntry(codeBlock, codeBlock3, bl);
            }
            if (!bl || !codeBlock.containsAsSubBlock(codeBlock3)) {
                UniqueVector uniqueVector = new UniqueVector();
                int n2 = 0;
                while (n2 < codeBlock3.nextBlockList.size()) {
                    CodeBlock codeBlock4 = (CodeBlock)codeBlock3.nextBlockList.elementAt(n2);
                    boolean bl2 = true;
                    if (codeBlock4.type == "LOOP" && codeBlock4.containsAsSubBlock(codeBlock3)) {
                        bl2 = false;
                    }
                    if (codeBlock4.equals(codeBlock.entry) && bl2) {
                        uniqueVector.addElement(codeBlock);
                    } else {
                        uniqueVector.addElement(codeBlock4);
                    }
                    ++n2;
                }
                codeBlock3.nextBlockList = uniqueVector;
            }
            ++n;
        }
    }

    private static boolean same(UniqueVector uniqueVector, UniqueVector uniqueVector2) {
        if (uniqueVector == null || uniqueVector2 == null) {
            return false;
        }
        if (uniqueVector.size() != uniqueVector2.size()) {
            return false;
        }
        int n = 0;
        while (n < uniqueVector.size()) {
            if (uniqueVector.elementAt(n) != uniqueVector2.elementAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static void searchEntry(CodeBlock codeBlock, CodeBlock codeBlock2) throws DecompilerException {
        int n = 0;
        while (n < codeBlock2.subBlocks.size()) {
            CodeBlock codeBlock3 = (CodeBlock)codeBlock2.subBlocks.elementAt(n);
            if (!codeBlock3.simple()) {
                CodeBlockAnalyzer.searchEntry(codeBlock, codeBlock3);
            }
            if (!codeBlock.containsAsSubBlock(codeBlock3)) {
                int n2 = 0;
                while (n2 < codeBlock3.nextBlockList.size()) {
                    CodeBlock codeBlock4 = (CodeBlock)codeBlock3.nextBlockList.elementAt(n2);
                    if (codeBlock.containsAsSubBlock(codeBlock4)) {
                        if (e != null) {
                            if (!e.equals(codeBlock4)) {
                                Decompiler.report("Multiple transfers into block");
                            }
                        } else {
                            e = codeBlock4;
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static void setBreaks(CodeBlock codeBlock) throws DecompilerException {
        CodeBlockAnalyzer.setBreaksFor(codeBlock);
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            CodeBlock codeBlock2 = (CodeBlock)codeBlock.subBlocks.elementAt(n);
            CodeBlockAnalyzer.setBreaks(codeBlock2);
            ++n;
        }
    }

    private static void setBreaksFor(CodeBlock codeBlock) throws DecompilerException {
        if (codeBlock.superBlock != null && (codeBlock.type == "LOOP" || codeBlock.type == "SWITCH")) {
            codeBlock.setStdBreak(codeBlock.nextBlock);
        }
        if (codeBlock.type == "LOOP") {
            codeBlock.setContinue();
        }
        if (!codeBlock.simple() && !codeBlock.orderedContainer()) {
            CodeBlockAnalyzer.makeBreakableBlocks(codeBlock);
        }
    }

    private static void setNextForAll(CodeBlock codeBlock) throws DecompilerException {
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            ((CodeBlock)codeBlock.subBlocks.elementAt((int)n)).nextBlock = codeBlock.nextBlock;
            ++n;
        }
    }

    private static void setProcessed(CodeBlock codeBlock, boolean bl) {
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            ((CodeBlock)codeBlock.subBlocks.elementAt((int)n)).processed = bl;
            ++n;
        }
    }

    private static void setSearch(CodeBlock codeBlock, boolean bl) {
        int n = 0;
        while (n < codeBlock.subBlocks.size()) {
            ((CodeBlock)codeBlock.subBlocks.elementAt((int)n)).search = bl;
            ++n;
        }
    }

    private static void time(int n) {
        if (debugTime) {
            currTime = System.currentTimeMillis();
            AnalyzerUtilities.p("Point " + n + " " + (currTime - startTime));
            startTime = currTime;
        }
    }
}

