/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.io.IOException;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.ClassFileInputStream;

public class ConstantPool {
    public static final int LITERAL = 1;
    public static final int INTEGER = 3;
    public static final int FLOAT = 4;
    public static final int LONG = 5;
    public static final int DOUBLE = 6;
    public static final int CLASS = 7;
    public static final int STRINGCONSTANT = 8;
    public static final int FIELD = 9;
    public static final int METHOD = 10;
    public static final int INTERFACEMETHOD = 11;
    public static final int NAME_AND_TYPE_DEFINITION = 12;
    public byte[] constant_tag;
    private int[] constant_val1;
    private Object[] constant_obj;
    static int currBytes = 0;

    public ConstantPool(int n) {
        this.constant_tag = new byte[n];
        this.constant_val1 = new int[n];
        this.constant_obj = new Object[n];
    }

    public boolean fill(ClassFileInputStream classFileInputStream, int n) throws IOException {
        int n2 = 1;
        while (n2 < n) {
            int n3 = this.getCPEntry(n2, classFileInputStream);
            if (n3 < 0) {
                return false;
            }
            if (n3 > 0) {
                ++n2;
            }
            ++n2;
        }
        return true;
    }

    private int getCPEntry(int n, ClassFileInputStream classFileInputStream) throws IOException {
        byte by = this.constant_tag[n] = classFileInputStream.readByte();
        int n2 = 0;
        switch (by) {
            case 1: {
                this.constant_obj[n] = classFileInputStream.readUTF();
                break;
            }
            case 2: {
                AnalyzerUtilities.p("Unknown CP type(2).");
                break;
            }
            case 3: {
                this.constant_val1[n] = classFileInputStream.getInt(4);
                break;
            }
            case 4: {
                this.constant_obj[n] = classFileInputStream.getFloat();
                break;
            }
            case 5: {
                this.constant_obj[n] = classFileInputStream.getLong(8);
                n2 = 1;
                break;
            }
            case 6: {
                this.constant_obj[n] = classFileInputStream.getDouble();
                n2 = 1;
                break;
            }
            case 7: {
                this.constant_val1[n] = classFileInputStream.getInt(2);
                break;
            }
            case 8: {
                this.constant_val1[n] = classFileInputStream.getInt(2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                int n3 = classFileInputStream.getInt(2);
                int n4 = classFileInputStream.getInt(2);
                this.constant_val1[n] = n3 << 16 | n4;
                break;
            }
            default: {
                AnalyzerUtilities.alert("Unknown Constant Pool type.");
                n2 = -1;
            }
        }
        return n2;
    }

    public String getConstantName(int n) {
        byte by;
        if (n >= 0 && n < this.constant_tag.length && ((by = this.constant_tag[n]) == 7 || by == 9 || by == 10 || by == 11)) {
            return (String)this.readConstantPoolEntry(n);
        }
        return null;
    }

    public Object readConstantPoolEntry(int n) {
        int n2 = -1;
        if (n >= 0 && n < this.constant_tag.length) {
            n2 = this.constant_tag[n];
            switch (n2) {
                case 1: {
                    return this.constant_obj[n];
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return new Integer(this.constant_val1[n]);
                }
                case 4: {
                    return this.constant_obj[n];
                }
                case 5: {
                    return this.constant_obj[n];
                }
                case 6: {
                    return this.constant_obj[n];
                }
                case 7: {
                    return this.readConstantPoolEntry(this.constant_val1[n]);
                }
                case 8: {
                    return this.readConstantPoolEntry(this.constant_val1[n]);
                }
                case 9: 
                case 10: 
                case 11: {
                    int n3 = this.constant_val1[n] >> 16;
                    int n4 = this.constant_val1[n] & 0xFFFF;
                    return String.valueOf(String.valueOf(this.readConstantPoolEntry(n3))) + "." + this.readConstantPoolEntry(n4);
                }
                case 12: {
                    int n5 = this.constant_val1[n] >> 16;
                    int n6 = this.constant_val1[n] & 0xFFFF;
                    return String.valueOf(String.valueOf(this.readConstantPoolEntry(n5))) + ":" + this.readConstantPoolEntry(n6);
                }
            }
        }
        AnalyzerUtilities.p("Unable to resolve constant pool entry, type = " + n2 + " index = " + n);
        return null;
    }
}

