/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import java.util.Hashtable;
import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.UnitInfo;

public class HashedVector {
    private UniqueVector theObjectsV;
    private Hashtable hash;

    public HashedVector() {
        this(false, 1, 1);
    }

    public HashedVector(boolean bl, int n, int n2) {
        this.theObjectsV = new UniqueVector(n, n2);
        this.hash = bl ? new Hashtable() : null;
    }

    public void add(HashedVector hashedVector, int n, boolean bl) {
        this.add((UnitInfo)hashedVector.theObjectsV.elementAt(n), bl);
    }

    public void add(HashedVector hashedVector, boolean bl) {
        int n = 0;
        while (n < hashedVector.size()) {
            this.add(hashedVector, n, bl);
            ++n;
        }
    }

    public boolean add(UnitInfo unitInfo, boolean bl) {
        if (unitInfo == null) {
            AnalyzerUtilities.alert("Cannot add null");
        }
        if (this.hash != null) {
            String string = unitInfo.uniqueNameString();
            if (bl && this.get(string) != null) {
                return false;
            }
            if (this.hash.put(string, unitInfo) != null && bl) {
                return false;
            }
            this.theObjectsV.addElement(unitInfo);
            return true;
        }
        int n = this.theObjectsV.size();
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                if (this.theObjectsV.elementAt(n2) == unitInfo) {
                    return false;
                }
                ++n2;
            }
        }
        this.theObjectsV.addElement(unitInfo);
        return true;
    }

    public Object get(int n) {
        if (n >= 0 && n < this.theObjectsV.size()) {
            return this.theObjectsV.elementAt(n);
        }
        return null;
    }

    public Object get(String string) {
        return this.get(null, string);
    }

    private Object get(char[] cArray, String string) {
        if (string != null && this.hash != null) {
            return this.hash.get(string);
        }
        int n = cArray == null ? string.length() : cArray.length;
        int n2 = 0;
        while (n2 < this.size()) {
            char[] cArray2 = ((UnitInfo)this.theObjectsV.elementAt(n2)).uniqueName();
            if (n == cArray2.length) {
                if (cArray == null) {
                    cArray = string.toCharArray();
                }
                int n3 = 0;
                while (n3 < n) {
                    if (cArray[n3] != cArray2[n3]) break;
                    ++n3;
                }
                if (n3 == n) {
                    return this.theObjectsV.elementAt(n2);
                }
            }
            ++n2;
        }
        return null;
    }

    public int indexOf(UnitInfo unitInfo) {
        int n = this.theObjectsV.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.theObjectsV.elementAt(n2) == unitInfo) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int size() {
        return this.theObjectsV.size();
    }

    public String toString() {
        return "HashedVector: size = " + this.size();
    }
}

