/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.analyzer;

import org.apache.tools.analyzer.AnalyzerUtilities;
import org.apache.tools.analyzer.Decompiler;
import org.apache.tools.analyzer.DecompilerException;
import org.apache.tools.analyzer.DecompilerLibrary;
import org.apache.tools.analyzer.Instruction;
import org.apache.tools.analyzer.NameMgr;
import org.apache.tools.analyzer.ProgramElement;
import org.apache.tools.analyzer.Statement;
import org.apache.tools.analyzer.Type;
import org.apache.tools.analyzer.UniqueVector;
import org.apache.tools.analyzer.info.LocalVariableInfo;

public class Operand
extends ProgramElement {
    public Integer incrementValue = null;
    public Type typeDescriptor;
    public int touchCount = 0;
    public Statement statement = null;
    public Operand last = null;

    public Operand(String string, Object object, Operand operand, Operand operand2, Type type, Statement statement, Instruction instruction) throws DecompilerException {
        this.oper = string;
        this.typeDescriptor = type;
        this.constantOrName = object;
        this.genInstruction = instruction;
        this.operands = new UniqueVector(2, 2);
        if (operand != null) {
            this.operands.addElement(operand);
        }
        if (operand2 != null) {
            this.operands.addElement(operand2);
        }
        this.statement = statement;
        if (this.genInstruction != null) {
            this.genInstruction.whatYouPush(this);
        }
    }

    public Operand(String string, Object object, UniqueVector uniqueVector, Type type, Statement statement, Instruction instruction) throws DecompilerException {
        this.oper = string;
        this.typeDescriptor = type;
        this.constantOrName = object;
        this.operands = uniqueVector;
        this.genInstruction = instruction;
        this.statement = statement;
        if (this.oper != "INITIALIZE" && this.oper != "NEWINITIALIZE" && this.oper != "INVOKEVIRTUAL" && this.oper != "INVOKESTATIC" && this.oper != "NEWARRAY" && this.oper != "ARRAYSTORE" && !Operand.arithmeticOrLogicalOperator(this.oper)) {
            throw new DecompilerException(3103);
        }
        if (this.genInstruction != null) {
            this.genInstruction.whatYouPush(this);
        }
    }

    private static String arithmeticOperator(String string, UniqueVector uniqueVector, String string2) throws DecompilerException {
        Operand operand = (Operand)uniqueVector.elementAt(0);
        Operand operand2 = (Operand)uniqueVector.elementAt(1);
        if (operand == null || operand2 == null) {
            throw new DecompilerException(1833);
        }
        String string3 = operand.trueBoolean() || operand2.trueBoolean() ? "boolean" : null;
        String string4 = String.valueOf(operand2.output(string, string3)) + " " + Operand.getArithmeticString(string) + " " + operand.output(string, string3);
        if (string2 == null) {
            return "(" + string4 + ")";
        }
        if (string2.equals(string) && Operand.commutative(string)) {
            return string4;
        }
        return "(" + string4 + ")";
    }

    private String arithmeticOrLogical(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        String string4 = null;
        if (string == "NOT") {
            string4 = Operand.notOperator(this.operands, string2);
        } else if (string == "NEG") {
            string4 = Operand.negOperator(this.operands, string2);
        } else if (Operand.binaryArithmeticOperator(string)) {
            string4 = Operand.arithmeticOperator(string, this.operands, string2);
        } else if (Operand.numericEqualityOperator(string)) {
            string4 = Operand.equalityOperator(string, this.operands, string2);
        } else if (Operand.quantityComparisonOperator(string)) {
            string4 = Operand.quantityOperator(string, this.operands, string2);
        } else if (Operand.nullEqualityOperator(string)) {
            string4 = Operand.nullEquality(string, this.operands, string2);
        } else {
            throw new DecompilerException(3121);
        }
        return string4;
    }

    private static boolean arithmeticOrLogicalOperator(String string) {
        return Operand.getArithmeticString(string) != null || Operand.getCompareString(string) != null;
    }

    private String arrayAccess(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        String string4;
        String string5;
        Type type = operand2.getMyType();
        if (type.isArrayType()) {
            string5 = operand2.output(null, null);
            string4 = type.getResolvedType();
        } else {
            string4 = String.valueOf(this.nameFor(this.arrayInstructionType)) + "[]";
            string5 = operand2.output(null, string4);
        }
        string5 = String.valueOf(string5) + "[" + operand.output(null, "int") + "]";
        if (string3 != null && !string4.equals(string3)) {
            string5 = "((" + NameMgr.useConvert(string3, 1) + ") " + string5 + ")";
        }
        return string5;
    }

    private String asBoolean(Object object) throws DecompilerException {
        if (object instanceof Integer) {
            int n = (Integer)object;
            if (n == 0) {
                return "false";
            }
            if (n == 1) {
                return "true";
            }
        }
        throw new DecompilerException(3151);
    }

    private String asChar(Object object) {
        return DecompilerLibrary.asChar((char)((Integer)object).intValue());
    }

    private String asDouble(Object object) {
        return this.constantOrName.toString();
    }

    private String asFloat(Object object) {
        return String.valueOf(this.constantOrName.toString()) + "f";
    }

    private String asInt(Object object) {
        String string = object.toString();
        if (!(object instanceof Integer)) {
            return "((int) " + string + ")";
        }
        return string;
    }

    private String asLong(Object object) {
        return String.valueOf(this.constantOrName.toString()) + "L";
    }

    public static boolean binaryArithmeticOperator(String string) {
        return string.equals("ADD") || string.equals("MUL") || string.equals("SUB") || string.equals("XOR") || string.equals("OR") || string.equals("AND") || string.equals("DIV") || string.equals("SHR") || string.equals("USR") || string.equals("SHL") || string.equals("CMP") || string.equals("REM") || string.equals("LAND") || string.equals("LOR");
    }

    private static String booleanExpression(Operand operand, String string, int n) throws DecompilerException {
        String string2 = operand.output(null);
        if (string == "EQ" && n == 1 || string == "NE" && n == 0) {
            return string2;
        }
        return "!" + string2;
    }

    private String cast(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        String string4 = this.getNameToUse(1);
        String string5 = operand.output(null, null);
        return "((" + string4 + ") " + string5 + ")";
    }

    private static boolean commutative(String string) {
        return string.equals("MUL") || string.equals("ADD") || string.equals("LAND") || string.equals("LOR");
    }

    private String constant(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        if (this.constantOrName == null) {
            throw new DecompilerException(8305);
        }
        if (this.constantOrName instanceof String) {
            return "\"" + DecompilerLibrary.makeReadable((String)this.constantOrName) + "\"";
        }
        String string4 = string3 != null ? string3 : this.typeDescriptor.getResolvedTypeConstant();
        if (string4.equals("boolean")) {
            return this.asBoolean(this.constantOrName);
        }
        if (string4.equals("int")) {
            return this.asInt(this.constantOrName);
        }
        if (string4.equals("char")) {
            return "((char) " + this.asChar(this.constantOrName) + ")";
        }
        if (string4.equals("byte")) {
            return "((byte) " + this.asInt(this.constantOrName) + ")";
        }
        if (string4.equals("short")) {
            return "((short) " + this.asInt(this.constantOrName) + ")";
        }
        if (string4.equals("float")) {
            return this.asFloat(this.constantOrName);
        }
        if (string4.equals("long")) {
            return this.asLong(this.constantOrName);
        }
        if (string4.equals("double")) {
            return this.asDouble(this.constantOrName);
        }
        if (string4.equals("java/lang/String")) {
            return this.constantOrName.toString();
        }
        throw new DecompilerException(23003);
    }

    public static String convertZero(String string) {
        if (string == "float") {
            return "0.0f";
        }
        if (string == "long") {
            return "0L";
        }
        if (string == "double") {
            return "0.0";
        }
        if (string == "boolean") {
            return "false";
        }
        if (string == "int") {
            return "0";
        }
        if (string == "short") {
            return "0";
        }
        if (string == "byte") {
            return "0";
        }
        if (string == "char") {
            return "'\\000'";
        }
        if (string == "Object") {
            return "null";
        }
        if (string == "java/lang/Object") {
            return "null";
        }
        return "0";
    }

    private static String convertZero(Operand operand) throws DecompilerException {
        String string = operand.getMyType().getResolvedType();
        return Operand.convertZero(string);
    }

    private static String equalityOperator(String string, UniqueVector uniqueVector, String string2) throws DecompilerException {
        Operand operand = (Operand)uniqueVector.elementAt(0);
        Operand operand2 = (Operand)uniqueVector.elementAt(1);
        if (operand == null || operand2 == null) {
            throw new DecompilerException(1835);
        }
        if (Operand.isOpBoolean(operand) && Operand.isOpBoolean(operand2)) {
            int n = Operand.getBooleanValue(operand2);
            if (n >= 0) {
                return Operand.booleanExpression(operand, string, n);
            }
            n = Operand.getBooleanValue(operand);
            if (n >= 0) {
                return Operand.booleanExpression(operand2, string, n);
            }
        }
        String string3 = operand.output(null);
        String string4 = operand2.output(null);
        if (operand.isUndeterminedZero()) {
            string3 = Operand.convertZero(operand2);
        }
        if (operand2.isUndeterminedZero()) {
            string4 = Operand.convertZero(operand);
        }
        if ((Operand.isLocalObj(operand) || Operand.isLocalObj(operand2)) && !operand.getMyType().equals(operand2.getMyType())) {
            string3 = operand.output(null, "java/lang/Object");
            string4 = operand2.output(null, "java/lang/Object");
        }
        String string5 = operand2.oper.equals("CONSTANT") ? String.valueOf(string3) + " " + Operand.getCompareString(string) + " " + string4 : String.valueOf(string4) + " " + Operand.getCompareString(string) + " " + string3;
        if (string2 == null) {
            return string5;
        }
        return "(" + string5 + ")";
    }

    public Operand get(int n) throws DecompilerException {
        if (this.operands == null) {
            return null;
        }
        if (n < 0 || n >= this.operands.size()) {
            return null;
        }
        return (Operand)this.operands.elementAt(n);
    }

    private static String getArithmeticString(String string) {
        if (string == "ADD") {
            return "+";
        }
        if (string == "SUB") {
            return "-";
        }
        if (string == "MUL") {
            return "*";
        }
        if (string == "DIV") {
            return "/";
        }
        if (string == "OR") {
            return "|";
        }
        if (string == "LOR") {
            return "||";
        }
        if (string == "AND") {
            return "&";
        }
        if (string == "LAND") {
            return "&&";
        }
        if (string == "XOR") {
            return "^";
        }
        if (string == "REM") {
            return "%";
        }
        if (string == "SHL") {
            return "<<";
        }
        if (string == "SHR") {
            return ">>";
        }
        if (string == "USR") {
            return ">>>";
        }
        if (string == "NEG") {
            return "-";
        }
        if (string == "CMP") {
            return "-";
        }
        if (string == "NOT") {
            return "!";
        }
        return null;
    }

    private static int getBooleanValue(Operand operand) {
        if (operand.oper == "CONSTANT") {
            if (operand.constantOrName == "Zero") {
                return 0;
            }
            if (operand.constantOrName instanceof Integer) {
                int n = (Integer)operand.constantOrName;
                if (n == 0) {
                    return 0;
                }
                if (n == 1) {
                    return 1;
                }
            }
        }
        return -1;
    }

    private static String getCompareString(String string) {
        if (string == "EQ") {
            return "==";
        }
        if (string == "NE") {
            return "!=";
        }
        if (string == "LT") {
            return "<";
        }
        if (string == "GE") {
            return ">=";
        }
        if (string == "GT") {
            return ">";
        }
        if (string == "LE") {
            return "<=";
        }
        if (string == "EQN") {
            return "==";
        }
        if (string == "NEN") {
            return "!=";
        }
        return null;
    }

    private String getLocal(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        String string4 = LocalVariableInfo.getLocalName((Integer)this.constantOrName, this.genInstruction);
        if (string3 != null && !this.getMyType().getResolvedType().equals(string3)) {
            string4 = "((" + NameMgr.useConvert(string3, 1) + ") " + string4 + ")";
        }
        if (this.incrementValue != null) {
            return String.valueOf(string4) + (this.incrementValue == 1 ? "++" : "--");
        }
        return string4;
    }

    public Type getMyType() throws DecompilerException {
        if (this.oper == "GETLOCAL") {
            Type type = LocalVariableInfo.getLocalType((Integer)this.constantOrName, this.genInstruction);
            if (!type.fullyResolved()) {
                throw new DecompilerException(21001);
            }
            return type;
        }
        if (this.oper == "ARRAYACCESS") {
            Operand operand = this.get(1);
            Type type = operand.getMyType();
            if (!type.fullyResolved()) {
                throw new DecompilerException(21003);
            }
            if ((type = type.arrayElementType()) == null) {
                return new Type("CompletelyTotallyUnknown");
            }
            return type;
        }
        if (!this.typeDescriptor.fullyResolved()) {
            if (this.oper == "CONSTANT" && Operand.getBooleanValue(this) == -1) {
                return new Type(this.typeDescriptor.getResolvedTypeConstant());
            }
            if (this.oper == "AND" || this.oper == "OR") {
                if (this.get(0).getMyType().getResolvedType().equals("boolean") && this.get(1).getMyType().getResolvedType().equals("boolean")) {
                    return new Type("boolean");
                }
                if (this.get(0).getMyType().getBaseType().equals("int") && this.get(1).getMyType().getBaseType().equals("int")) {
                    return new Type("int");
                }
            }
        }
        this.typeDescriptor.resolveAsLocal();
        return this.typeDescriptor;
    }

    private String getNameToUse(int n) {
        return NameMgr.useConvert((String)this.constantOrName, n);
    }

    private static String getOpposite(String string) {
        if (string == "EQ") {
            return "NE";
        }
        if (string == "NE") {
            return "EQ";
        }
        if (string == "LT") {
            return "GE";
        }
        if (string == "GE") {
            return "LT";
        }
        if (string == "GT") {
            return "LE";
        }
        if (string == "LE") {
            return "GT";
        }
        if (string == "EQN") {
            return "NEN";
        }
        if (string == "NEN") {
            return "EQN";
        }
        return null;
    }

    private static String getReverse(String string) throws DecompilerException {
        if (string == "LT") {
            return "GT";
        }
        if (string == "GE") {
            return "LE";
        }
        if (string == "GT") {
            return "LT";
        }
        if (string == "LE") {
            return "GE";
        }
        throw new DecompilerException(1851);
    }

    private String getStatic(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        String string4 = ProgramElement.getStaticFieldName((String)this.constantOrName);
        String string5 = this.incrementValue != null ? String.valueOf(string4) + (this.incrementValue == 1 ? "++" : "--") : string4;
        if (string3 != null && !this.getMyType().getResolvedType().equals(string3)) {
            string5 = "((" + NameMgr.useConvert(string3, 1) + ") " + string5 + ")";
        }
        return string5;
    }

    private String getVirtual(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        String string4 = DecompilerLibrary.removeClass((String)this.constantOrName);
        String string5 = DecompilerLibrary.removeMethodOrField((String)this.constantOrName);
        String string6 = ProgramElement.getFieldObjectReference(operand, string5);
        string6 = this.incrementValue != null ? String.valueOf(string6) + string4 + (this.incrementValue == 1 ? "++" : "--") : String.valueOf(string6) + string4;
        if (string3 != null && !this.getMyType().getResolvedType().equals(string3)) {
            string6 = "((" + NameMgr.useConvert(string3, 1) + ") " + string6 + ")";
        }
        return string6;
    }

    private static boolean isLocalObj(Operand operand) throws DecompilerException {
        return operand.oper == "GETLOCAL" && operand.typeDescriptor.getBaseType() == "Object";
    }

    private static boolean isOpBoolean(Operand operand) throws DecompilerException {
        if (operand.oper == "CONSTANT") {
            return Operand.getBooleanValue(operand) != -1;
        }
        return operand.getMyType().getResolvedType().equals("boolean");
    }

    public boolean isThis() {
        return Decompiler.isVirtualMethod() && this.oper == "GETLOCAL" && (Integer)this.constantOrName == 0;
    }

    private boolean isUndeterminedZero() {
        return this.oper == "CONSTANT" && this.constantOrName == "Zero";
    }

    public void markNever() throws DecompilerException {
        if (this.statement != null) {
            this.statement.markNever();
        }
        int n = 0;
        while (n < this.operands.size()) {
            Operand operand = (Operand)this.operands.elementAt(n);
            operand.markNever();
            ++n;
        }
    }

    private String nameFor(String string) {
        if (AnalyzerUtilities.isBasicType(string) && !string.equals("void")) {
            return string;
        }
        if (string.equals("Object")) {
            return "java/lang/Object";
        }
        Decompiler.report("Unknown type for array found");
        return "int";
    }

    private static String negOperator(UniqueVector uniqueVector, String string) throws DecompilerException {
        Operand operand = (Operand)uniqueVector.elementAt(0);
        return "(-" + operand.output("NEG") + ")";
    }

    private String newInit(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        if (this.argTypeVector == null) {
            throw new DecompilerException(3123);
        }
        return ProgramElement.newInitialize(this.operands, this.argTypeVector, this.getNameToUse(1));
    }

    private String newOp(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        Decompiler.report("New object never initialized");
        return "(new uninitialized) " + this.getNameToUse(1);
    }

    private static String notOperator(UniqueVector uniqueVector, String string) throws DecompilerException {
        Operand operand = (Operand)uniqueVector.elementAt(0);
        if (operand == null) {
            throw new DecompilerException(1831);
        }
        String string2 = operand.oper;
        if (string2 == "LAND" || string2 == "LOR") {
            UniqueVector uniqueVector2 = new UniqueVector();
            uniqueVector2.addElement(new Operand("NOT", null, operand.get(0), null, new Type("boolean"), null, null));
            uniqueVector2.addElement(new Operand("NOT", null, operand.get(1), null, new Type("boolean"), null, null));
            Operand operand2 = new Operand(string2 == "LAND" ? "LOR" : "LAND", null, uniqueVector2, new Type("boolean"), null, null);
            return operand2.output(string, null);
        }
        if (Operand.reversibleOperator(string2)) {
            Operand operand3 = new Operand(Operand.getOpposite(string2), null, operand.operands, new Type("boolean"), null, null);
            return operand3.output(string, null);
        }
        if (string2 == "NOT") {
            return operand.get(0).output(string, null);
        }
        return "!(" + operand.output("NOT", null) + ")";
    }

    private static String nullEquality(String string, UniqueVector uniqueVector, String string2) throws DecompilerException {
        Operand operand = (Operand)uniqueVector.elementAt(0);
        Operand operand2 = (Operand)uniqueVector.elementAt(1);
        if (operand == null || operand2 == null) {
            throw new DecompilerException(1839);
        }
        String string3 = operand.output(null);
        String string4 = operand2.output(null);
        String string5 = "No null for null equality operator";
        string5 = operand.oper.equals("null") ? String.valueOf(string4) + " " + Operand.getCompareString(string) + " null" : String.valueOf(string3) + " " + Operand.getCompareString(string) + " null";
        if (string2 == null) {
            return string5;
        }
        return "(" + string5 + ")";
    }

    private static boolean nullEqualityOperator(String string) {
        return string == "EQN" || string == "NEN";
    }

    private static boolean numericEqualityOperator(String string) {
        return string == "EQ" || string == "NE";
    }

    public String output(String string) throws DecompilerException {
        return this.output(string, null);
    }

    public String output(String string, String string2) throws DecompilerException {
        int n = this.operands.size();
        Operand operand = null;
        Operand operand2 = null;
        Operand operand3 = null;
        if (n > 0) {
            operand = (Operand)this.operands.elementAt(0);
        }
        if (n > 1) {
            operand2 = (Operand)this.operands.elementAt(1);
        }
        if (n > 2) {
            operand3 = (Operand)this.operands.elementAt(2);
        }
        if (Operand.arithmeticOrLogicalOperator(this.oper)) {
            return this.arithmeticOrLogical(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "null") {
            return "null";
        }
        if (this.oper == "CONSTANT") {
            return this.constant(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "GETLOCAL") {
            return this.getLocal(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "GETVIRTUAL") {
            return this.getVirtual(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "CONVERSION") {
            return "((" + (String)this.constantOrName + ") " + operand.output(null, null) + ")";
        }
        if (this.oper == "INVOKEVIRTUAL") {
            return ProgramElement.buildInvoke(true, this.operands, (String)this.constantOrName, this.statement.fullMethodName, this.argTypeVector, false);
        }
        if (this.oper == "GETSTATIC") {
            return this.getStatic(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "INVOKESTATIC") {
            return ProgramElement.buildInvoke(false, this.operands, (String)this.constantOrName, this.statement.fullMethodName, this.argTypeVector, false);
        }
        if (this.oper == "NEW") {
            return this.newOp(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "NEWINITIALIZE") {
            return this.newInit(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "ARRAYLENGTH") {
            return String.valueOf(operand.output(null, null)) + ".length";
        }
        if (this.oper == "INSTANCEOF") {
            return "(" + operand.output(null, null) + " instanceof " + this.getNameToUse(1) + ")";
        }
        if (this.oper == "NEWARRAY") {
            return ProgramElement.newArray(this.operands, this.getNameToUse(1));
        }
        if (this.oper == "ARRAYACCESS") {
            return this.arrayAccess(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper == "CATCHPARAMETER") {
            return "parCatchException" + (Integer)this.constantOrName;
        }
        if (this.oper == "CAST") {
            return this.cast(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper.equals("PCONDITIONAL")) {
            return this.pconditional(this.oper, operand, operand2, operand3, string, string2);
        }
        if (this.oper.equals("subroutineReturnAddress")) {
            return "return_adress";
        }
        throw new DecompilerException(3127);
    }

    private String pconditional(String string, Operand operand, Operand operand2, Operand operand3, String string2, String string3) throws DecompilerException {
        if (operand.oper == "NE") {
            Operand operand4 = new Operand("NOT", null, operand, null, new Type("boolean"), null, null);
            return "(" + operand4.output(null, null) + " ? " + operand3.output(null, null) + " : " + operand2.output(null, null) + ")";
        }
        return "(" + operand.output(null, null) + " ? " + operand2.output(null, null) + " : " + operand3.output(null, null) + ")";
    }

    private static boolean quantityComparisonOperator(String string) {
        return string == "LT" || string == "GE" || string == "GT" || string == "LE";
    }

    private static String quantityOperator(String string, UniqueVector uniqueVector, String string2) throws DecompilerException {
        Operand operand = (Operand)uniqueVector.elementAt(0);
        Operand operand2 = (Operand)uniqueVector.elementAt(1);
        if (operand == null || operand2 == null) {
            throw new DecompilerException(1837);
        }
        String string3 = operand.output(null);
        String string4 = operand2.output(null);
        if (operand.isUndeterminedZero()) {
            string3 = Operand.convertZero(operand2);
        }
        if (operand2.isUndeterminedZero()) {
            string4 = Operand.convertZero(operand);
        }
        String string5 = operand2.oper.equals("CONSTANT") ? String.valueOf(string3) + " " + Operand.getCompareString(Operand.getReverse(string)) + " " + string4 : String.valueOf(string4) + " " + Operand.getCompareString(string) + " " + string3;
        if (string2 == null) {
            return string5;
        }
        return "(" + string5 + ")";
    }

    private static boolean reversibleOperator(String string) {
        return Operand.numericEqualityOperator(string) || Operand.quantityComparisonOperator(string) || Operand.nullEqualityOperator(string);
    }

    public void saveStaleField(String string) {
        if ((this.oper == "GETVIRTUAL" || this.oper == "GETSTATIC") && this.constantOrName.equals(string)) {
            if (this.genInstruction.saveLabel < 0) {
                this.genInstruction.saveLabel = 7000000 + this.genInstruction.location;
            } else {
                AnalyzerUtilities.p("Field " + string + " occuring on stack will be saved");
            }
        }
        int n = 0;
        while (n < this.operands.size()) {
            ((Operand)this.operands.elementAt(n)).saveStaleField(string);
            ++n;
        }
    }

    public void saveStaleLocal(int n) {
        if (this.oper == "GETLOCAL" && (Integer)this.constantOrName == n) {
            if (this.genInstruction.saveLabel < 0) {
                this.genInstruction.saveLabel = 7000000 + this.genInstruction.location;
            } else {
                AnalyzerUtilities.p("Local " + n + " occuring on stack will be saved");
            }
        }
        int n2 = 0;
        while (n2 < this.operands.size()) {
            ((Operand)this.operands.elementAt(n2)).saveStaleLocal(n);
            ++n2;
        }
    }

    public void setNewInitialize(UniqueVector uniqueVector, UniqueVector uniqueVector2) throws DecompilerException {
        if (this.oper != "NEW") {
            throw new DecompilerException(3105);
        }
        if (this.operands.size() != 0) {
            throw new DecompilerException(3107);
        }
        this.oper = "NEWINITIALIZE";
        this.operands = uniqueVector;
        this.argTypeVector = uniqueVector2;
    }

    public void touch(boolean bl) throws DecompilerException {
        if (this.touchCount == 1 && this.statement != null) {
            if (bl) {
                throw new DecompilerException(10999);
            }
            if (this.genInstruction.saveLabel < 0) {
                this.genInstruction.saveLabel = 5000000 + this.genInstruction.location;
            } else {
                AnalyzerUtilities.p("Saving value at instruction " + this.genInstruction.location);
            }
        }
        ++this.touchCount;
        int n = 0;
        while (n < this.operands.size()) {
            ((Operand)this.operands.elementAt(n)).touch(bl);
            ++n;
        }
    }

    public boolean trueBoolean() throws DecompilerException {
        return this.typeDescriptor.fullyResolved() && this.getMyType().equals("boolean");
    }

    public boolean type2() throws DecompilerException {
        return this.typeDescriptor.type2();
    }
}

